/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDownloadTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ChangesetQueryTask
extends PleaseWaitRunnable
implements ChangesetDownloadTask {
    private ChangesetQuery query;
    private boolean canceled;
    private Set<Changeset> downloadedChangesets;
    private Exception lastException;
    private OsmServerUserInfoReader userInfoReader;
    private OsmServerChangesetReader changesetReader;

    public ChangesetQueryTask(ChangesetQuery changesetQuery) {
        super(I18n.tr("Querying and downloading changesets", false));
        CheckParameterUtil.ensureParameterNotNull(changesetQuery, "query");
        this.query = changesetQuery;
    }

    public ChangesetQueryTask(Component component, ChangesetQuery changesetQuery) {
        super(component, I18n.tr("Querying and downloading changesets", new Object[0]), false);
        CheckParameterUtil.ensureParameterNotNull(changesetQuery, "query");
        this.query = changesetQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        this.canceled = true;
        ChangesetQueryTask changesetQueryTask = this;
        synchronized (changesetQueryTask) {
            if (this.userInfoReader != null) {
                this.userInfoReader.cancel();
            }
        }
        changesetQueryTask = this;
        synchronized (changesetQueryTask) {
            if (this.changesetReader != null) {
                this.changesetReader.cancel();
            }
        }
    }

    @Override
    protected void finish() {
        if (this.canceled) {
            return;
        }
        if (this.lastException != null) {
            GuiHelper.runInEDTAndWait(new Runnable(){
                private final Component parent;
                {
                    this.parent = ChangesetQueryTask.this.progressMonitor != null ? ChangesetQueryTask.this.progressMonitor.getWindowParent() : null;
                }

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(this.parent != null ? this.parent : Main.parent, ExceptionUtil.explainException(ChangesetQueryTask.this.lastException), I18n.tr("Errors during download", new Object[0]), 0);
                }
            });
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ChangesetCache.getInstance().update(ChangesetQueryTask.this.downloadedChangesets);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while updating changeset cache");
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    BugReportExceptionHandler.handleException(throwable);
                }
                if (throwable instanceof Exception) {
                    ExceptionUtil.explainException(invocationTargetException);
                }
                BugReportExceptionHandler.handleException(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fullyIdentifyCurrentUser() throws OsmTransferException {
        this.getProgressMonitor().indeterminateSubTask(I18n.tr("Determine user id for current user...", new Object[0]));
        Object object = this;
        synchronized (object) {
            this.userInfoReader = new OsmServerUserInfoReader();
        }
        object = this.userInfoReader.fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
        Object object2 = this;
        synchronized (object2) {
            this.userInfoReader = null;
        }
        object2 = JosmUserIdentityManager.getInstance();
        ((JosmUserIdentityManager)object2).setFullyIdentified(((JosmUserIdentityManager)object2).getUserName(), (UserInfo)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        try {
            JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
            if (this.query.isRestrictedToPartiallyIdentifiedUser() && josmUserIdentityManager.isCurrentUser(this.query.getUserName())) {
                if (josmUserIdentityManager.isPartiallyIdentified()) {
                    this.fullyIdentifyCurrentUser();
                }
                this.query = this.query.forUser(JosmUserIdentityManager.getInstance().getUserId());
            }
            if (this.canceled) {
                return;
            }
            this.getProgressMonitor().indeterminateSubTask(I18n.tr("Query and download changesets ...", new Object[0]));
            ChangesetQueryTask changesetQueryTask = this;
            synchronized (changesetQueryTask) {
                this.changesetReader = new OsmServerChangesetReader();
            }
            this.downloadedChangesets = new HashSet<Changeset>();
            this.downloadedChangesets.addAll(this.changesetReader.queryChangesets(this.query, this.getProgressMonitor().createSubTaskMonitor(0, false)));
            changesetQueryTask = this;
            synchronized (changesetQueryTask) {
                this.changesetReader = null;
            }
        }
        catch (OsmTransferCanceledException osmTransferCanceledException) {
            this.canceled = true;
        }
        catch (OsmTransferException osmTransferException) {
            if (this.canceled) {
                return;
            }
            this.lastException = osmTransferException;
        }
    }

    @Override
    public Set<Changeset> getDownloadedChangesets() {
        return this.downloadedChangesets;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isFailed() {
        return this.lastException != null;
    }
}

