/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDetailPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetTagsPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.SingleChangesetDownloadPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.ChangesetQueryDialog;
import org.openstreetmap.josm.gui.dialogs.changeset.query.ChangesetQueryTask;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ChangesetCacheManager
extends JFrame {
    public static final ImageIcon DOWNLOAD_CONTENT_ICON = ImageProvider.get("dialogs/changeset", "downloadchangesetcontent");
    public static final ImageIcon UPDATE_CONTENT_ICON = ImageProvider.get("dialogs/changeset", "updatechangesetcontent");
    private static volatile ChangesetCacheManager instance;
    private ChangesetCacheManagerModel model;
    private JSplitPane spContent;
    private boolean needsSplitPaneAdjustment;
    private RemoveFromCacheAction actRemoveFromCacheAction;
    private CloseSelectedChangesetsAction actCloseSelectedChangesetsAction;
    private DownloadSelectedChangesetsAction actDownloadSelectedChangesets;
    private DownloadSelectedChangesetContentAction actDownloadSelectedContent;
    private JTable tblChangesets;

    public static ChangesetCacheManager getInstance() {
        if (instance == null) {
            instance = new ChangesetCacheManager();
        }
        return instance;
    }

    public static void destroyInstance() {
        if (instance != null) {
            instance.setVisible(true);
            instance.dispose();
            instance = null;
        }
    }

    protected void buildModel() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setSelectionMode(2);
        this.model = new ChangesetCacheManagerModel(defaultListSelectionModel);
        this.actRemoveFromCacheAction = new RemoveFromCacheAction();
        this.actCloseSelectedChangesetsAction = new CloseSelectedChangesetsAction();
        this.actDownloadSelectedChangesets = new DownloadSelectedChangesetsAction();
        this.actDownloadSelectedContent = new DownloadSelectedChangesetContentAction();
    }

    protected JPanel buildToolbarPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        SideButton sideButton = new SideButton(new QueryAction());
        jPanel.add(sideButton);
        jPanel.add(new SingleChangesetDownloadPanel());
        jPanel.add(new SideButton(new DownloadMyChangesets()));
        return jPanel;
    }

    protected JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(new SideButton(new CancelAction()));
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/ChangesetManager"))));
        return jPanel;
    }

    protected JPanel buildChangesetDetailPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        ChangesetDetailPanel changesetDetailPanel = new ChangesetDetailPanel();
        jTabbedPane.add(changesetDetailPanel);
        this.model.addPropertyChangeListener(changesetDetailPanel);
        ChangesetTagsPanel changesetTagsPanel = new ChangesetTagsPanel();
        jTabbedPane.add(changesetTagsPanel);
        this.model.addPropertyChangeListener(changesetTagsPanel);
        ChangesetContentPanel changesetContentPanel = new ChangesetContentPanel();
        jTabbedPane.add(changesetContentPanel);
        this.model.addPropertyChangeListener(changesetContentPanel);
        ChangesetDiscussionPanel changesetDiscussionPanel = new ChangesetDiscussionPanel();
        jTabbedPane.add(changesetDiscussionPanel);
        this.model.addPropertyChangeListener(changesetDiscussionPanel);
        jTabbedPane.setTitleAt(0, I18n.tr("Properties", new Object[0]));
        jTabbedPane.setToolTipTextAt(0, I18n.tr("Display the basic properties of the changeset", new Object[0]));
        jTabbedPane.setTitleAt(1, I18n.tr("Tags", new Object[0]));
        jTabbedPane.setToolTipTextAt(1, I18n.tr("Display the tags of the changeset", new Object[0]));
        jTabbedPane.setTitleAt(2, I18n.tr("Content", new Object[0]));
        jTabbedPane.setToolTipTextAt(2, I18n.tr("Display the objects created, updated, and deleted by the changeset", new Object[0]));
        jTabbedPane.setTitleAt(3, I18n.tr("Discussion", new Object[0]));
        jTabbedPane.setToolTipTextAt(3, I18n.tr("Display the public discussion around this changeset", new Object[0]));
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    protected JPanel buildContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.spContent = new JSplitPane(0);
        this.spContent.setLeftComponent(this.buildChangesetTablePanel());
        this.spContent.setRightComponent(this.buildChangesetDetailPanel());
        this.spContent.setOneTouchExpandable(true);
        this.spContent.setDividerLocation(0.5);
        jPanel.add((Component)this.spContent, "Center");
        return jPanel;
    }

    protected JPanel buildChangesetTableActionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        this.model.getSelectionModel().addListSelectionListener(this.actRemoveFromCacheAction);
        jToolBar.add(this.actRemoveFromCacheAction);
        this.model.getSelectionModel().addListSelectionListener(this.actCloseSelectedChangesetsAction);
        jToolBar.add(this.actCloseSelectedChangesetsAction);
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadSelectedChangesets);
        jToolBar.add(this.actDownloadSelectedChangesets);
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadSelectedContent);
        jToolBar.add(this.actDownloadSelectedContent);
        jPanel.add((Component)jToolBar, "Center");
        return jPanel;
    }

    protected JPanel buildChangesetTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tblChangesets = new JTable(this.model, new ChangesetCacheTableColumnModel(), this.model.getSelectionModel());
        this.tblChangesets.addMouseListener(new MouseEventHandler());
        this.tblChangesets.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "showDetails");
        this.tblChangesets.getActionMap().put("showDetails", new ShowDetailAction());
        this.model.getSelectionModel().addListSelectionListener(new ChangesetDetailViewSynchronizer());
        this.tblChangesets.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "removeFromCache");
        this.tblChangesets.getActionMap().put("removeFromCache", this.actRemoveFromCacheAction);
        jPanel.add((Component)new JScrollPane(this.tblChangesets), "Center");
        jPanel.add((Component)this.buildChangesetTableActionPanel(), "West");
        return jPanel;
    }

    protected void build() {
        this.setTitle(I18n.tr("Changeset Management Dialog", new Object[0]));
        this.setIconImage(ImageProvider.get("dialogs/changeset", "changesetmanager").getImage());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.buildModel();
        container.add((Component)this.buildToolbarPanel(), "North");
        container.add((Component)this.buildContentPanel(), "Center");
        container.add((Component)this.buildButtonPanel(), "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/ChangesetManager"));
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelAndClose");
        this.getRootPane().getActionMap().put("cancelAndClose", new CancelAction());
        this.addWindowListener(new WindowEventHandler());
    }

    public ChangesetCacheManager() {
        this.build();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(1000, 600))).applySafe(this);
            this.needsSplitPaneAdjustment = true;
            this.model.init();
        } else if (this.isShowing()) {
            this.model.tearDown();
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public void setSelectedChangesets(Collection<Changeset> collection) {
        this.model.setSelectedChangesets(collection);
        int n = this.model.getSelectionModel().getMinSelectionIndex();
        if (n < 0) {
            return;
        }
        this.tblChangesets.scrollRectToVisible(this.tblChangesets.getCellRect(n, 0, true));
        this.repaint();
    }

    public void setSelectedChangesetsById(Collection<Integer> collection) {
        if (collection == null) {
            this.setSelectedChangesets(null);
            return;
        }
        HashSet<Changeset> hashSet = new HashSet<Changeset>();
        ChangesetCache changesetCache = ChangesetCache.getInstance();
        for (int n : collection) {
            if (!changesetCache.contains(n)) continue;
            hashSet.add(changesetCache.get(n));
        }
        this.setSelectedChangesets(hashSet);
    }

    public void runDownloadTask(final ChangesetDownloadTask changesetDownloadTask) {
        Main.worker.submit(changesetDownloadTask);
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                if (changesetDownloadTask.isCanceled() || changesetDownloadTask.isFailed()) {
                    return;
                }
                ChangesetCacheManager.this.setSelectedChangesets(changesetDownloadTask.getDownloadedChangesets());
            }
        });
    }

    class ChangesetDetailViewSynchronizer
    implements ListSelectionListener {
        ChangesetDetailViewSynchronizer() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            List<Changeset> list = ChangesetCacheManager.this.model.getSelectedChangesets();
            if (list.size() == 1) {
                ChangesetCacheManager.this.model.setChangesetInDetailView(list.get(0));
            } else {
                ChangesetCacheManager.this.model.setChangesetInDetailView(null);
            }
        }
    }

    class ChangesetTablePopupMenu
    extends JPopupMenu {
        public ChangesetTablePopupMenu() {
            this.add(ChangesetCacheManager.this.actRemoveFromCacheAction);
            this.add(ChangesetCacheManager.this.actCloseSelectedChangesetsAction);
            this.add(ChangesetCacheManager.this.actDownloadSelectedChangesets);
            this.add(ChangesetCacheManager.this.actDownloadSelectedContent);
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        public MouseEventHandler() {
            super(new ChangesetTablePopupMenu());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseEventHandler.isDoubleClick(mouseEvent)) {
                new ShowDetailAction().showDetails();
            }
        }
    }

    class DownloadMyChangesets
    extends AbstractAction {
        public DownloadMyChangesets() {
            this.putValue("Name", I18n.tr("My changesets", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "downloadchangeset"));
            this.putValue("ShortDescription", I18n.tr("Download my changesets from the OSM server (max. 100 changesets)", new Object[0]));
            this.setEnabled(!Main.isOffline(OnlineResource.OSM_API));
        }

        protected void alertAnonymousUser() {
            HelpAwareOptionPane.showOptionDialog(ChangesetCacheManager.this, I18n.tr("<html>JOSM is currently running with an anonymous user. It cannot download<br>your changesets from the OSM server unless you enter your OSM user name<br>in the JOSM preferences.</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetManager#CanDownloadMyChangesets"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
            if (josmUserIdentityManager.isAnonymous()) {
                this.alertAnonymousUser();
                return;
            }
            ChangesetQuery changesetQuery = new ChangesetQuery();
            changesetQuery = josmUserIdentityManager.isFullyIdentified() ? changesetQuery.forUser(josmUserIdentityManager.getUserId()) : changesetQuery.forUser(josmUserIdentityManager.getUserName());
            ChangesetQueryTask changesetQueryTask = new ChangesetQueryTask(ChangesetCacheManager.this, changesetQuery);
            ChangesetCacheManager.getInstance().runDownloadTask(changesetQueryTask);
        }
    }

    class ShowDetailAction
    extends AbstractAction {
        ShowDetailAction() {
        }

        public void showDetails() {
            List<Changeset> list = ChangesetCacheManager.this.model.getSelectedChangesets();
            if (list.size() != 1) {
                return;
            }
            ChangesetCacheManager.this.model.setChangesetInDetailView(list.get(0));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.showDetails();
        }
    }

    class DownloadSelectedChangesetContentAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadSelectedChangesetContentAction() {
            this.putValue("Name", I18n.tr("Download changeset content", new Object[0]));
            this.putValue("SmallIcon", DOWNLOAD_CONTENT_ICON);
            this.putValue("ShortDescription", I18n.tr("Download the content of the selected changesets from the server", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChangesetContentDownloadTask changesetContentDownloadTask = new ChangesetContentDownloadTask((Component)ChangesetCacheManager.this, ChangesetCacheManager.this.model.getSelectedChangesetIds());
            ChangesetCacheManager.getInstance().runDownloadTask(changesetContentDownloadTask);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetCacheManager.this.model.hasSelectedChangesets() && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class DownloadSelectedChangesetsAction
    extends AbstractAction
    implements ListSelectionListener {
        public DownloadSelectedChangesetsAction() {
            this.putValue("Name", I18n.tr("Update changeset", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "updatechangeset"));
            this.putValue("ShortDescription", I18n.tr("Updates the selected changesets with current data from the OSM server", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<Changeset> list = ChangesetCacheManager.this.model.getSelectedChangesets();
            ChangesetHeaderDownloadTask changesetHeaderDownloadTask = ChangesetHeaderDownloadTask.buildTaskForChangesets(ChangesetCacheManager.this, list);
            ChangesetCacheManager.getInstance().runDownloadTask(changesetHeaderDownloadTask);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetCacheManager.this.model.hasSelectedChangesets() && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class CloseSelectedChangesetsAction
    extends AbstractAction
    implements ListSelectionListener {
        public CloseSelectedChangesetsAction() {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("closechangeset"));
            this.putValue("ShortDescription", I18n.tr("Close the selected changesets", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<Changeset> list = ChangesetCacheManager.this.model.getSelectedChangesets();
            Main.worker.submit(new CloseChangesetTask(list));
        }

        protected void updateEnabledState() {
            List<Changeset> list = ChangesetCacheManager.this.model.getSelectedChangesets();
            JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
            for (Changeset changeset : list) {
                if (!changeset.isOpen()) continue;
                if (josmUserIdentityManager.isPartiallyIdentified() && changeset.getUser() != null && changeset.getUser().getName().equals(josmUserIdentityManager.getUserName())) {
                    this.setEnabled(true);
                    return;
                }
                if (!josmUserIdentityManager.isFullyIdentified() || changeset.getUser() == null || changeset.getUser().getId() != (long)josmUserIdentityManager.getUserId()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class RemoveFromCacheAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveFromCacheAction() {
            this.putValue("Name", I18n.tr("Remove from cache", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.putValue("ShortDescription", I18n.tr("Remove the selected changesets from the local cache", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<Changeset> list = ChangesetCacheManager.this.model.getSelectedChangesets();
            ChangesetCache.getInstance().remove(list);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetCacheManager.this.model.hasSelectedChangesets());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class QueryAction
    extends AbstractAction {
        public QueryAction() {
            this.putValue("Name", I18n.tr("Query", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "search"));
            this.putValue("ShortDescription", I18n.tr("Launch the dialog for querying changesets", new Object[0]));
            this.setEnabled(!Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChangesetQueryDialog changesetQueryDialog = new ChangesetQueryDialog(ChangesetCacheManager.this);
            changesetQueryDialog.initForUserInput();
            changesetQueryDialog.setVisible(true);
            if (changesetQueryDialog.isCanceled()) {
                return;
            }
            try {
                ChangesetQuery changesetQuery = changesetQueryDialog.getChangesetQuery();
                if (changesetQuery == null) {
                    return;
                }
                ChangesetQueryTask changesetQueryTask = new ChangesetQueryTask(ChangesetCacheManager.this, changesetQuery);
                ChangesetCacheManager.getInstance().runDownloadTask(changesetQueryTask);
            }
            catch (IllegalStateException illegalStateException) {
                JOptionPane.showMessageDialog(ChangesetCacheManager.this, illegalStateException.getMessage(), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    static class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog", new Object[0]));
        }

        public void cancelAndClose() {
            ChangesetCacheManager.destroyInstance();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancelAndClose();
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            new CancelAction().cancelAndClose();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (ChangesetCacheManager.this.needsSplitPaneAdjustment) {
                ChangesetCacheManager.this.spContent.setDividerLocation(0.5);
                ChangesetCacheManager.this.needsSplitPaneAdjustment = false;
            }
        }
    }
}

