/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;

public class LatLonDialog
extends ExtendedDialog {
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    public JTabbedPane tabs;
    private JosmTextField tfLatLon;
    private JosmTextField tfEastNorth;
    private LatLon latLonCoordinates;
    private EastNorth eastNorthCoordinates;
    private static final double ZERO = 0.0;
    private static final String DEG = "\u00b0";
    private static final String MIN = "\u2032";
    private static final String SEC = "\u2033";
    private static final char N_TR = LatLon.NORTH.charAt(0);
    private static final char S_TR = LatLon.SOUTH.charAt(0);
    private static final char E_TR = LatLon.EAST.charAt(0);
    private static final char W_TR = LatLon.WEST.charAt(0);
    private static final Pattern p = Pattern.compile("([+|-]?\\d+[.,]\\d+)|([+|-]?\\d+)|(\u00b0|o|deg)|('|\u2032|min)|(\"|\u2033|sec)|(,|;)|([NSEW" + N_TR + S_TR + E_TR + W_TR + "])|" + "\\s+|" + "(.+)");

    protected JPanel buildLatLon() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(I18n.tr("Coordinates:", new Object[0])), GBC.std().insets(0, 10, 5, 0));
        this.tfLatLon = new JosmTextField(24);
        jPanel.add((Component)this.tfLatLon, GBC.eol().insets(0, 10, 0, 0).fill(2).weight(1.0, 0.0));
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        jPanel.add((Component)new HtmlPanel(I18n.tr("Enter the coordinates for the new node.<br/>You can separate longitude and latitude with space, comma or semicolon.<br/>Use positive numbers or N, E characters to indicate North or East cardinal direction.<br/>For South and West cardinal directions you can use either negative numbers or S, W characters.<br/>Coordinate value can be in one of three formats:<ul><li><i>degrees</i><tt>&deg;</tt></li><li><i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt></li><li><i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt> <i>seconds</i><tt>&quot</tt></li></ul>Symbols <tt>&deg;</tt>, <tt>&#39;</tt>, <tt>&prime;</tt>, <tt>&quot;</tt>, <tt>&Prime;</tt> are optional.<br/><br/>Some examples:<ul>{0}</ul>", "<li>49.29918&deg; 19.24788&deg;</li><li>N 49.29918 E 19.24788</li><li>W 49&deg;29.918&#39; S 19&deg;24.788&#39;</li><li>N 49&deg;29&#39;04&quot; E 19&deg;24&#39;43&quot;</li><li>49.29918 N, 19.24788 E</li><li>49&deg;29&#39;21&quot; N 19&deg;24&#39;38&quot; E</li><li>49 29 51, 19 24 18</li><li>49 29, 19 24</li><li>E 49 29, N 19 24</li><li>49&deg; 29; 19&deg; 24</li><li>N 49&deg; 29, W 19&deg; 24</li><li>49&deg; 29.5 S, 19&deg; 24.6 E</li><li>N 49 29.918 E 19 15.88</li><li>49 29.4 19 24.5</li><li>-49 29.4 N -19 24.5 W</li><li>48 deg 42&#39; 52.13\" N, 21 deg 11&#39; 47.60\" E</li>")), GBC.eol().fill().weight(1.0, 1.0));
        LatLonInputVerifier latLonInputVerifier = new LatLonInputVerifier();
        this.tfLatLon.getDocument().addDocumentListener(latLonInputVerifier);
        TextFieldFocusHandler textFieldFocusHandler = new TextFieldFocusHandler();
        this.tfLatLon.addFocusListener(textFieldFocusHandler);
        return jPanel;
    }

    private JPanel buildEastNorth() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(I18n.tr("Projected coordinates:", new Object[0])), GBC.std().insets(0, 10, 5, 0));
        this.tfEastNorth = new JosmTextField(24);
        jPanel.add((Component)this.tfEastNorth, GBC.eol().insets(0, 10, 0, 0).fill(2).weight(1.0, 0.0));
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        jPanel.add((Component)new HtmlPanel(I18n.tr("Enter easting and northing (x and y) separated by space, comma or semicolon.", new Object[0])), GBC.eol().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill().weight(1.0, 1.0));
        EastNorthInputVerifier eastNorthInputVerifier = new EastNorthInputVerifier();
        this.tfEastNorth.getDocument().addDocumentListener(eastNorthInputVerifier);
        TextFieldFocusHandler textFieldFocusHandler = new TextFieldFocusHandler();
        this.tfEastNorth.addFocusListener(textFieldFocusHandler);
        return jPanel;
    }

    protected void build() {
        this.tabs = new JTabbedPane();
        this.tabs.addTab(I18n.tr("Lat/Lon", new Object[0]), this.buildLatLon());
        this.tabs.addTab(I18n.tr("East/North", new Object[0]), this.buildEastNorth());
        this.tabs.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                switch (LatLonDialog.this.tabs.getModel().getSelectedIndex()) {
                    case 0: {
                        LatLonDialog.this.parseLatLonUserInput();
                        break;
                    }
                    case 1: {
                        LatLonDialog.this.parseEastNorthUserInput();
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        });
        this.setContent(this.tabs, false);
    }

    public LatLonDialog(Component component, String string, String string2) {
        super(component, string, new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0])});
        this.setButtonIcons(new String[]{"ok", "cancel"});
        this.configureContextsensitiveHelp(string2, true);
        this.build();
        this.setCoordinates(null);
    }

    public boolean isLatLon() {
        return this.tabs.getModel().getSelectedIndex() == 0;
    }

    public void setCoordinates(LatLon latLon) {
        if (latLon == null) {
            latLon = new LatLon(0.0, 0.0);
        }
        this.latLonCoordinates = latLon;
        this.tfLatLon.setText(latLon.latToString(CoordinateFormat.getDefaultFormat()) + " " + latLon.lonToString(CoordinateFormat.getDefaultFormat()));
        EastNorth eastNorth = Main.getProjection().latlon2eastNorth(latLon);
        this.tfEastNorth.setText(eastNorth.east() + " " + eastNorth.north());
        this.setOkEnabled(true);
    }

    public LatLon getCoordinates() {
        if (this.isLatLon()) {
            return this.latLonCoordinates;
        }
        if (this.eastNorthCoordinates == null) {
            return null;
        }
        return Main.getProjection().eastNorth2latlon(this.eastNorthCoordinates);
    }

    public LatLon getLatLonCoordinates() {
        return this.latLonCoordinates;
    }

    public EastNorth getEastNorthCoordinates() {
        return this.eastNorthCoordinates;
    }

    protected void setErrorFeedback(JosmTextField josmTextField, String string) {
        josmTextField.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
        josmTextField.setToolTipText(string);
        josmTextField.setBackground(BG_COLOR_ERROR);
    }

    protected void clearErrorFeedback(JosmTextField josmTextField, String string) {
        josmTextField.setBorder(UIManager.getBorder("TextField.border"));
        josmTextField.setToolTipText(string);
        josmTextField.setBackground(UIManager.getColor("TextField.background"));
    }

    protected Double parseDoubleFromUserInput(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        string = string.replaceAll(DEG, "");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number number = null;
        ParsePosition parsePosition = new ParsePosition(0);
        number = numberFormat.parse(string, parsePosition);
        if (parsePosition.getErrorIndex() >= 0 || parsePosition.getIndex() < string.length()) {
            parsePosition = new ParsePosition(0);
            numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
            number = numberFormat.parse(string, parsePosition);
            if (parsePosition.getErrorIndex() >= 0 || parsePosition.getIndex() < string.length()) {
                return null;
            }
        }
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    protected void parseLatLonUserInput() {
        LatLon latLon;
        try {
            latLon = LatLonDialog.parseLatLon(this.tfLatLon.getText());
            if (!LatLon.isValidLat(latLon.lat()) || !LatLon.isValidLon(latLon.lon())) {
                latLon = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            latLon = null;
        }
        if (latLon == null) {
            this.setErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates", new Object[0]));
            this.latLonCoordinates = null;
            this.setOkEnabled(false);
        } else {
            this.clearErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates", new Object[0]));
            this.latLonCoordinates = latLon;
            this.setOkEnabled(true);
        }
    }

    protected void parseEastNorthUserInput() {
        EastNorth eastNorth;
        try {
            eastNorth = LatLonDialog.parseEastNorth(this.tfEastNorth.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            eastNorth = null;
        }
        if (eastNorth == null) {
            this.setErrorFeedback(this.tfEastNorth, I18n.tr("Please enter a Easting and Northing", new Object[0]));
            this.latLonCoordinates = null;
            this.setOkEnabled(false);
        } else {
            this.clearErrorFeedback(this.tfEastNorth, I18n.tr("Please enter a Easting and Northing", new Object[0]));
            this.eastNorthCoordinates = eastNorth;
            this.setOkEnabled(true);
        }
    }

    private void setOkEnabled(boolean bl) {
        if (this.buttons != null && !this.buttons.isEmpty()) {
            ((JButton)this.buttons.get(0)).setEnabled(bl);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            WindowGeometry.centerInWindow(Main.parent, this.getSize()).applySafe(this);
        }
        super.setVisible(bl);
    }

    public static LatLon parseLatLon(String string) {
        String string2;
        Matcher matcher = p.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                stringBuilder.append('R');
                arrayList.add(Double.parseDouble(matcher.group(1).replace(',', '.')));
                continue;
            }
            if (matcher.group(2) != null) {
                stringBuilder.append('Z');
                arrayList.add(Double.parseDouble(matcher.group(2)));
                continue;
            }
            if (matcher.group(3) != null) {
                stringBuilder.append('o');
                continue;
            }
            if (matcher.group(4) != null) {
                stringBuilder.append('\'');
                continue;
            }
            if (matcher.group(5) != null) {
                stringBuilder.append('\"');
                continue;
            }
            if (matcher.group(6) != null) {
                stringBuilder.append(',');
                continue;
            }
            if (matcher.group(7) != null) {
                stringBuilder.append("x");
                string2 = matcher.group(7).toUpperCase();
                if ("N".equals(string2) || "S".equals(string2) || "E".equals(string2) || "W".equals(string2)) {
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add(string2.replace(N_TR, 'N').replace(S_TR, 'S').replace(E_TR, 'E').replace(W_TR, 'W'));
                continue;
            }
            if (matcher.group(8) == null) continue;
            throw new IllegalArgumentException("invalid token: " + matcher.group(8));
        }
        string2 = stringBuilder.toString();
        Object[] objectArray = arrayList.toArray();
        LatLonHolder latLonHolder = new LatLonHolder();
        if (string2.matches("Ro?,?Ro?")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], 0.0, 0.0, "N", objectArray[1], 0.0, 0.0, "E");
        } else if (string2.matches("xRo?,?xRo?")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[1], 0.0, 0.0, objectArray[0], objectArray[3], 0.0, 0.0, objectArray[2]);
        } else if (string2.matches("Ro?x,?Ro?x")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], 0.0, 0.0, objectArray[1], objectArray[2], 0.0, 0.0, objectArray[3]);
        } else if (string2.matches("Zo[RZ]'?,?Zo[RZ]'?|Z[RZ],?Z[RZ]")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], 0.0, "N", objectArray[2], objectArray[3], 0.0, "E");
        } else if (string2.matches("xZo[RZ]'?,?xZo[RZ]'?|xZo?[RZ],?xZo?[RZ]")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[1], objectArray[2], 0.0, objectArray[0], objectArray[4], objectArray[5], 0.0, objectArray[3]);
        } else if (string2.matches("Zo[RZ]'?x,?Zo[RZ]'?x|Zo?[RZ]x,?Zo?[RZ]x")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], 0.0, objectArray[2], objectArray[3], objectArray[4], 0.0, objectArray[5]);
        } else if (string2.matches("ZoZ'[RZ]\"?x,?ZoZ'[RZ]\"?x|ZZ[RZ]x,?ZZ[RZ]x")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7]);
        } else if (string2.matches("xZoZ'[RZ]\"?,?xZoZ'[RZ]\"?|xZZ[RZ],?xZZ[RZ]")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[1], objectArray[2], objectArray[3], objectArray[0], objectArray[5], objectArray[6], objectArray[7], objectArray[4]);
        } else if (string2.matches("ZZ[RZ],?ZZ[RZ]")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], objectArray[2], "N", objectArray[3], objectArray[4], objectArray[5], "E");
        } else {
            throw new IllegalArgumentException("invalid format: " + string2);
        }
        return new LatLon(latLonHolder.lat, latLonHolder.lon);
    }

    public static EastNorth parseEastNorth(String string) {
        String[] stringArray = string.split("[;, ]+");
        if (stringArray.length != 2) {
            return null;
        }
        try {
            double d = Double.parseDouble(stringArray[0]);
            double d2 = Double.parseDouble(stringArray[1]);
            return new EastNorth(d, d2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static void setLatLonObj(LatLonHolder latLonHolder, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        LatLonDialog.setLatLon(latLonHolder, (Double)object, (Double)object2, (Double)object3, (String)object4, (Double)object5, (Double)object6, (Double)object7, (String)object8);
    }

    private static void setLatLon(LatLonHolder latLonHolder, double d, double d2, double d3, String string, double d4, double d5, double d6, String string2) {
        LatLonDialog.setLatLon(latLonHolder, d, d2, d3, string);
        LatLonDialog.setLatLon(latLonHolder, d4, d5, d6, string2);
    }

    private static void setLatLon(LatLonHolder latLonHolder, double d, double d2, double d3, String string) {
        if (d < -180.0 || d > 180.0 || d2 < 0.0 || d2 >= 60.0 || d3 < 0.0 || d3 > 60.0) {
            throw new IllegalArgumentException("out of range");
        }
        double d4 = (double)(d < 0.0 ? -1 : 1) * (Math.abs(d) + d2 / 60.0 + d3 / 3600.0);
        double d5 = d4 = "N".equals(string) || "E".equals(string) ? d4 : -d4;
        if ("N".equals(string) || "S".equals(string)) {
            latLonHolder.lat = d4;
        } else {
            latLonHolder.lon = d4;
        }
    }

    public String getLatLonText() {
        return this.tfLatLon.getText();
    }

    public void setLatLonText(String string) {
        this.tfLatLon.setText(string);
    }

    public String getEastNorthText() {
        return this.tfEastNorth.getText();
    }

    public void setEastNorthText(String string) {
        this.tfEastNorth.setText(string);
    }

    private static class LatLonHolder {
        private double lat;
        private double lon;

        private LatLonHolder() {
        }
    }

    static class TextFieldFocusHandler
    implements FocusListener {
        TextFieldFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component instanceof JosmTextField) {
                JosmTextField josmTextField = (JosmTextField)component;
                josmTextField.selectAll();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class EastNorthInputVerifier
    implements DocumentListener {
        EastNorthInputVerifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseEastNorthUserInput();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseEastNorthUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseEastNorthUserInput();
        }
    }

    class LatLonInputVerifier
    implements DocumentListener {
        LatLonInputVerifier() {
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseLatLonUserInput();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseLatLonUserInput();
        }
    }
}

