/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractInfoAction;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetInSelectionListModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetListCellRenderer;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetListModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetsInActiveDataLayerListModel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.ListPopupMenu;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;

public class ChangesetDialog
extends ToggleDialog {
    private ChangesetInSelectionListModel inSelectionModel;
    private ChangesetsInActiveDataLayerListModel inActiveDataLayerModel;
    private JList<Changeset> lstInSelection;
    private JList<Changeset> lstInActiveDataLayer;
    private JCheckBox cbInSelectionOnly;
    private JPanel pnlList;
    private SelectObjectsAction selectObjectsAction;
    private ReadChangesetsAction readChangesetAction;
    private ShowChangesetInfoAction showChangesetInfoAction;
    private CloseOpenChangesetsAction closeChangesetAction;
    private LaunchChangesetManagerAction launchChangesetManagerAction;
    private ChangesetDialogPopup popupMenu;

    protected void buildChangesetsLists() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.inSelectionModel = new ChangesetInSelectionListModel(defaultListSelectionModel);
        this.lstInSelection = new JList<Changeset>(this.inSelectionModel);
        this.lstInSelection.setSelectionModel(defaultListSelectionModel);
        this.lstInSelection.setSelectionMode(2);
        this.lstInSelection.setCellRenderer(new ChangesetListCellRenderer());
        defaultListSelectionModel = new DefaultListSelectionModel();
        this.inActiveDataLayerModel = new ChangesetsInActiveDataLayerListModel(defaultListSelectionModel);
        this.lstInActiveDataLayer = new JList<Changeset>(this.inActiveDataLayerModel);
        this.lstInActiveDataLayer.setSelectionModel(defaultListSelectionModel);
        this.lstInActiveDataLayer.setSelectionMode(2);
        this.lstInActiveDataLayer.setCellRenderer(new ChangesetListCellRenderer());
        DblClickHandler dblClickHandler = new DblClickHandler();
        this.lstInSelection.addMouseListener(dblClickHandler);
        this.lstInActiveDataLayer.addMouseListener(dblClickHandler);
    }

    protected void registerAsListener() {
        ChangesetCache.getInstance().addChangesetCacheListener(this.inSelectionModel);
        MapView.addEditLayerChangeListener(this.inSelectionModel);
        DataSet.addSelectionListener(this.inSelectionModel);
        ChangesetCache.getInstance().addChangesetCacheListener(this.inActiveDataLayerModel);
        MapView.addEditLayerChangeListener(this.inActiveDataLayerModel);
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer != null) {
            osmDataLayer.data.addDataSetListener(this.inActiveDataLayerModel);
            this.inActiveDataLayerModel.initFromDataSet(osmDataLayer.data);
            this.inSelectionModel.initFromPrimitives(osmDataLayer.data.getAllSelected());
        }
    }

    protected void unregisterAsListener() {
        ChangesetCache.getInstance().removeChangesetCacheListener(this.inActiveDataLayerModel);
        MapView.removeEditLayerChangeListener(this.inActiveDataLayerModel);
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer != null) {
            osmDataLayer.data.removeDataSetListener(this.inActiveDataLayerModel);
        }
        MapView.removeEditLayerChangeListener(this.inSelectionModel);
        DataSet.removeSelectionListener(this.inSelectionModel);
    }

    @Override
    public void showNotify() {
        this.registerAsListener();
        DatasetEventManager.getInstance().addDatasetListener(this.inActiveDataLayerModel, DatasetEventManager.FireMode.IN_EDT);
    }

    @Override
    public void hideNotify() {
        this.unregisterAsListener();
        DatasetEventManager.getInstance().removeDatasetListener(this.inActiveDataLayerModel);
    }

    protected JPanel buildFilterPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBorder(null);
        this.cbInSelectionOnly = new JCheckBox(I18n.tr("For selected objects only", new Object[0]));
        jPanel.add(this.cbInSelectionOnly);
        this.cbInSelectionOnly.setToolTipText(I18n.tr("<html>Select to show changesets for the currently selected objects only.<br>Unselect to show all changesets for objects in the current data layer.</html>", new Object[0]));
        this.cbInSelectionOnly.setSelected(Main.pref.getBoolean("changeset-dialog.for-selected-objects-only", false));
        return jPanel;
    }

    protected JPanel buildListPanel() {
        this.buildChangesetsLists();
        JPanel jPanel = new JPanel(new BorderLayout());
        if (this.cbInSelectionOnly.isSelected()) {
            jPanel.add(new JScrollPane(this.lstInSelection));
        } else {
            jPanel.add(new JScrollPane(this.lstInActiveDataLayer));
        }
        return jPanel;
    }

    protected void build() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildFilterPanel(), "North");
        this.pnlList = this.buildListPanel();
        jPanel.add((Component)this.pnlList, "Center");
        this.cbInSelectionOnly.addItemListener(new FilterChangeHandler());
        HelpUtil.setHelpContext(jPanel, HelpUtil.ht("/Dialog/ChangesetList"));
        this.selectObjectsAction = new SelectObjectsAction();
        this.cbInSelectionOnly.addItemListener(this.selectObjectsAction);
        this.readChangesetAction = new ReadChangesetsAction();
        this.cbInSelectionOnly.addItemListener(this.readChangesetAction);
        this.closeChangesetAction = new CloseOpenChangesetsAction();
        this.cbInSelectionOnly.addItemListener(this.closeChangesetAction);
        this.showChangesetInfoAction = new ShowChangesetInfoAction();
        this.cbInSelectionOnly.addItemListener(this.showChangesetInfoAction);
        this.launchChangesetManagerAction = new LaunchChangesetManagerAction();
        this.popupMenu = new ChangesetDialogPopup(this.lstInActiveDataLayer, this.lstInSelection);
        PopupMenuLauncher popupMenuLauncher = new PopupMenuLauncher(this.popupMenu);
        this.lstInSelection.addMouseListener(popupMenuLauncher);
        this.lstInActiveDataLayer.addMouseListener(popupMenuLauncher);
        this.createLayout(jPanel, false, Arrays.asList(new SideButton((Action)this.selectObjectsAction, false), new SideButton((Action)this.readChangesetAction, false), new SideButton((Action)this.closeChangesetAction, false), new SideButton((Action)this.showChangesetInfoAction, false), new SideButton((Action)this.launchChangesetManagerAction, false)));
    }

    protected JList<Changeset> getCurrentChangesetList() {
        if (this.cbInSelectionOnly.isSelected()) {
            return this.lstInSelection;
        }
        return this.lstInActiveDataLayer;
    }

    protected ChangesetListModel getCurrentChangesetListModel() {
        if (this.cbInSelectionOnly.isSelected()) {
            return this.inSelectionModel;
        }
        return this.inActiveDataLayerModel;
    }

    protected void initWithCurrentData() {
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer != null) {
            this.inSelectionModel.initFromPrimitives(osmDataLayer.data.getAllSelected());
            this.inActiveDataLayerModel.initFromDataSet(osmDataLayer.data);
        }
    }

    public ChangesetDialog() {
        super(I18n.tr("Changesets", new Object[0]), "changesetdialog", I18n.tr("Open the list of changesets in the current layer.", new Object[0]), null, 200, false);
        this.build();
        this.initWithCurrentData();
    }

    public void addPopupMenuSeparator() {
        this.popupMenu.addSeparator();
    }

    public JMenuItem addPopupMenuAction(Action action) {
        return this.popupMenu.add(action);
    }

    class ChangesetDialogPopup
    extends ListPopupMenu {
        public ChangesetDialogPopup(JList<?> ... jListArray) {
            super(jListArray);
            this.add(ChangesetDialog.this.selectObjectsAction);
            this.addSeparator();
            this.add(ChangesetDialog.this.readChangesetAction);
            this.add(ChangesetDialog.this.closeChangesetAction);
            this.addSeparator();
            this.add(ChangesetDialog.this.showChangesetInfoAction);
        }
    }

    public static class LaunchChangesetManager {
        protected static void launchChangesetManager(Collection<Integer> collection) {
            ChangesetCacheManager changesetCacheManager = ChangesetCacheManager.getInstance();
            if (changesetCacheManager.isVisible()) {
                changesetCacheManager.setExtendedState(0);
                changesetCacheManager.toFront();
                changesetCacheManager.requestFocus();
            } else {
                changesetCacheManager.setVisible(true);
                changesetCacheManager.toFront();
                changesetCacheManager.requestFocus();
            }
            changesetCacheManager.setSelectedChangesetsById(collection);
        }

        public static void displayChangesets(Set<Integer> set) {
            Object object;
            Object object2;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (!Main.isOffline(OnlineResource.OSM_API)) {
                object2 = ChangesetCache.getInstance();
                object = set.iterator();
                while (object.hasNext()) {
                    int n = object.next();
                    if (((ChangesetCache)object2).contains(n)) continue;
                    hashSet.add(n);
                }
            }
            if (hashSet.isEmpty()) {
                object2 = null;
                object = null;
            } else {
                object2 = new ChangesetHeaderDownloadTask(hashSet);
                object = Main.worker.submit((Runnable)object2);
            }
            Runnable runnable = new Runnable((Future)object, (ChangesetHeaderDownloadTask)object2, hashSet, set){
                final /* synthetic */ Future val$future;
                final /* synthetic */ ChangesetHeaderDownloadTask val$task;
                final /* synthetic */ Set val$toDownload;
                final /* synthetic */ Set val$sel;
                {
                    this.val$future = future;
                    this.val$task = changesetHeaderDownloadTask;
                    this.val$toDownload = set;
                    this.val$sel = set2;
                }

                @Override
                public void run() {
                    if (this.val$future != null) {
                        try {
                            this.val$future.get();
                        }
                        catch (InterruptedException interruptedException) {
                            Main.warn("InterruptedException in " + this.getClass().getSimpleName() + " while downloading changeset header");
                        }
                        catch (ExecutionException executionException) {
                            Main.error(executionException);
                            BugReportExceptionHandler.handleException(executionException.getCause());
                            return;
                        }
                    }
                    if (this.val$task != null) {
                        if (this.val$task.isCanceled()) {
                            return;
                        }
                        if (this.val$task.isFailed()) {
                            this.val$toDownload.clear();
                        }
                    }
                    GuiHelper.runInEDT(new Runnable(){

                        @Override
                        public void run() {
                            LaunchChangesetManager.launchChangesetManager(val$sel);
                        }
                    });
                }
            };
            Main.worker.submit(runnable);
        }
    }

    class LaunchChangesetManagerAction
    extends AbstractAction {
        public LaunchChangesetManagerAction() {
            this.putValue("Name", I18n.tr("Details", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Opens the Changeset Manager window for the selected changesets", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs/changeset", "changesetmanager"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChangesetListModel changesetListModel = ChangesetDialog.this.getCurrentChangesetListModel();
            Set<Integer> set = changesetListModel.getSelectedChangesetIds();
            LaunchChangesetManager.displayChangesets(set);
        }
    }

    class ShowChangesetInfoAction
    extends AbstractAction
    implements ListSelectionListener,
    ItemListener {
        public ShowChangesetInfoAction() {
            this.putValue("Name", I18n.tr("Show info", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Open a web page for each selected changeset", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help/internet"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Set<Changeset> set = ChangesetDialog.this.getCurrentChangesetListModel().getSelectedChangesets();
            if (set.isEmpty()) {
                return;
            }
            if (set.size() > 10 && !AbstractInfoAction.confirmLaunchMultiple(set.size())) {
                return;
            }
            String string = Main.getBaseBrowseUrl();
            for (Changeset changeset : set) {
                String string2 = string + "/changeset/" + changeset.getId();
                OpenBrowser.displayUrl(string2);
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class CloseOpenChangesetsAction
    extends AbstractAction
    implements ListSelectionListener,
    ItemListener {
        public CloseOpenChangesetsAction() {
            this.putValue("Name", I18n.tr("Close open changesets", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Closes the selected open changesets", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("closechangeset"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<Changeset> list = ChangesetDialog.this.getCurrentChangesetListModel().getSelectedOpenChangesets();
            if (list.isEmpty()) {
                return;
            }
            Main.worker.submit(new CloseChangesetTask(list));
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetListModel().hasSelectedOpenChangesets());
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ReadChangesetsAction
    extends AbstractAction
    implements ListSelectionListener,
    ItemListener {
        public ReadChangesetsAction() {
            this.putValue("Name", I18n.tr("Download", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Download information about the selected changesets from the OSM server", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("download"));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChangesetListModel changesetListModel = ChangesetDialog.this.getCurrentChangesetListModel();
            Set<Integer> set = changesetListModel.getSelectedChangesetIds();
            if (set.isEmpty()) {
                return;
            }
            ChangesetHeaderDownloadTask changesetHeaderDownloadTask = new ChangesetHeaderDownloadTask(set);
            Main.worker.submit(changesetHeaderDownloadTask);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0 && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class SelectObjectsAction
    extends AbstractAction
    implements ListSelectionListener,
    ItemListener {
        public SelectObjectsAction() {
            this.putValue("Name", I18n.tr("Select", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Select all objects assigned to the currently selected changesets", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "select"));
            this.updateEnabledState();
        }

        public void selectObjectsByChangesetIds(DataSet dataSet, Set<Integer> set) {
            if (dataSet == null || set == null) {
                return;
            }
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            for (OsmPrimitive osmPrimitive : dataSet.allPrimitives()) {
                if (!set.contains(osmPrimitive.getChangesetId())) continue;
                hashSet.add(osmPrimitive);
            }
            dataSet.setSelected(hashSet);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!Main.main.hasEditLayer()) {
                return;
            }
            ChangesetListModel changesetListModel = ChangesetDialog.this.getCurrentChangesetListModel();
            Set<Integer> set = changesetListModel.getSelectedChangesetIds();
            if (set.isEmpty()) {
                return;
            }
            DataSet dataSet = Main.main.getEditLayer().data;
            this.selectObjectsByChangesetIds(dataSet, set);
        }

        protected void updateEnabledState() {
            this.setEnabled(ChangesetDialog.this.getCurrentChangesetList().getSelectedIndices().length > 0);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateEnabledState();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class FilterChangeHandler
    implements ItemListener {
        FilterChangeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Main.pref.put("changeset-dialog.for-selected-objects-only", ChangesetDialog.this.cbInSelectionOnly.isSelected());
            ChangesetDialog.this.pnlList.removeAll();
            if (ChangesetDialog.this.cbInSelectionOnly.isSelected()) {
                ChangesetDialog.this.pnlList.add((Component)new JScrollPane(ChangesetDialog.this.lstInSelection), "Center");
            } else {
                ChangesetDialog.this.pnlList.add((Component)new JScrollPane(ChangesetDialog.this.lstInActiveDataLayer), "Center");
            }
            ChangesetDialog.this.validate();
            ChangesetDialog.this.repaint();
        }
    }

    class DblClickHandler
    extends MouseAdapter {
        DblClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.getClickCount() < 2) {
                return;
            }
            Set<Integer> set = ChangesetDialog.this.getCurrentChangesetListModel().getSelectedChangesetIds();
            if (set.isEmpty()) {
                return;
            }
            if (Main.main.getCurrentDataSet() == null) {
                return;
            }
            new SelectObjectsAction().selectObjectsByChangesetIds(Main.main.getCurrentDataSet(), set);
        }
    }
}

