/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.IConflictResolver;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.MergedTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.MineTableCellRenderer;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeColumnModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeModel;
import org.openstreetmap.josm.gui.conflict.pair.tags.TheirTableCellRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class TagMerger
extends JPanel
implements IConflictResolver {
    private JTable mineTable;
    private JTable mergedTable;
    private JTable theirTable;
    private final TagMergeModel model = new TagMergeModel();
    private transient AdjustmentSynchronizer adjustmentSynchronizer;

    protected JScrollPane embeddInScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        this.adjustmentSynchronizer.synchronizeAdjustment(jScrollPane.getVerticalScrollBar());
        return jScrollPane;
    }

    protected JScrollPane buildMineTagTable() {
        this.mineTable = new JTable(this.model, new TagMergeColumnModel(new MineTableCellRenderer()));
        this.mineTable.setName("table.my");
        return this.embeddInScrollPane(this.mineTable);
    }

    protected JScrollPane buildTheirTable() {
        this.theirTable = new JTable(this.model, new TagMergeColumnModel(new TheirTableCellRenderer()));
        this.theirTable.setName("table.their");
        return this.embeddInScrollPane(this.theirTable);
    }

    protected JScrollPane buildMergedTable() {
        this.mergedTable = new JTable(this.model, new TagMergeColumnModel(new MergedTableCellRenderer()));
        this.mergedTable.setName("table.merged");
        return this.embeddInScrollPane(this.mergedTable);
    }

    protected final void build() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.adjustmentSynchronizer = new AdjustmentSynchronizer();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        JLabel jLabel = new JLabel(I18n.tr("My version (local dataset)", new Object[0]));
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jLabel = new JLabel(I18n.tr("Merged version", new Object[0]));
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jLabel = new JLabel(I18n.tr("Their version (server dataset)", new Object[0]));
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.buildMineTagTable(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepMineAction keepMineAction = new KeepMineAction();
        this.mineTable.getSelectionModel().addListSelectionListener(keepMineAction);
        JButton jButton = new JButton(keepMineAction);
        jButton.setName("button.keepmine");
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.buildMergedTable(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        KeepTheirAction keepTheirAction = new KeepTheirAction();
        JButton jButton2 = new JButton(keepTheirAction);
        jButton2.setName("button.keeptheir");
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.buildTheirTable(), gridBagConstraints);
        this.theirTable.getSelectionModel().addListSelectionListener(keepTheirAction);
        DoubleClickAdapter doubleClickAdapter = new DoubleClickAdapter();
        this.mineTable.addMouseListener(doubleClickAdapter);
        this.theirTable.addMouseListener(doubleClickAdapter);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        UndecideAction undecideAction = new UndecideAction();
        this.mergedTable.getSelectionModel().addListSelectionListener(undecideAction);
        JButton jButton3 = new JButton(undecideAction);
        jButton3.setName("button.undecide");
        this.add((Component)jButton3, gridBagConstraints);
    }

    public TagMerger() {
        this.build();
    }

    public TagMergeModel getModel() {
        return this.model;
    }

    private void selectNextConflict(int[] nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        int n3 = this.model.getFirstUndecided(n + 1);
        if (n3 == -1) {
            n3 = this.model.getFirstUndecided(0);
        }
        this.mineTable.getSelectionModel().setSelectionInterval(n3, n3);
        this.theirTable.getSelectionModel().setSelectionInterval(n3, n3);
    }

    @Override
    public void deletePrimitive(boolean bl) {
        MergeDecisionType mergeDecisionType = bl ? MergeDecisionType.KEEP_MINE : MergeDecisionType.UNDECIDED;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.model.decide(i, mergeDecisionType);
        }
    }

    @Override
    public void populate(Conflict<? extends OsmPrimitive> conflict) {
        this.model.populate(conflict.getMy(), conflict.getTheir());
        for (JTable jTable : new JTable[]{this.mineTable, this.theirTable}) {
            int n = jTable.getRowCount() > 0 ? 0 : -1;
            jTable.getSelectionModel().setSelectionInterval(n, n);
        }
    }

    class UndecideAction
    extends AbstractAction
    implements ListSelectionListener {
        public UndecideAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "tagundecide");
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", I18n.tr("Undecide", new Object[0]));
            }
            this.putValue("ShortDescription", I18n.tr("Mark the selected tags as undecided", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TagMerger.this.mergedTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            TagMerger.this.model.decide(nArray, MergeDecisionType.UNDECIDED);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(TagMerger.this.mergedTable.getSelectedRowCount() > 0);
        }
    }

    class DoubleClickAdapter
    extends MouseAdapter {
        DoubleClickAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            MergeDecisionType mergeDecisionType;
            if (mouseEvent.getClickCount() != 2) {
                return;
            }
            JTable jTable = null;
            if (mouseEvent.getSource() == TagMerger.this.mineTable) {
                jTable = TagMerger.this.mineTable;
                mergeDecisionType = MergeDecisionType.KEEP_MINE;
            } else if (mouseEvent.getSource() == TagMerger.this.theirTable) {
                jTable = TagMerger.this.theirTable;
                mergeDecisionType = MergeDecisionType.KEEP_THEIR;
            } else if (mouseEvent.getSource() == TagMerger.this.mergedTable) {
                jTable = TagMerger.this.mergedTable;
                mergeDecisionType = MergeDecisionType.UNDECIDED;
            } else {
                return;
            }
            int n = jTable.rowAtPoint(mouseEvent.getPoint());
            TagMerger.this.model.decide(n, mergeDecisionType);
        }
    }

    static class AdjustmentSynchronizer
    implements AdjustmentListener {
        private final List<Adjustable> synchronizedAdjustables = new ArrayList<Adjustable>();

        public void synchronizeAdjustment(Adjustable adjustable) {
            if (adjustable == null) {
                return;
            }
            if (this.synchronizedAdjustables.contains(adjustable)) {
                return;
            }
            this.synchronizedAdjustables.add(adjustable);
            adjustable.addAdjustmentListener(this);
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            for (Adjustable adjustable : this.synchronizedAdjustables) {
                if (adjustable == adjustmentEvent.getAdjustable()) continue;
                adjustable.setValue(adjustmentEvent.getValue());
            }
        }
    }

    class KeepTheirAction
    extends AbstractAction
    implements ListSelectionListener {
        public KeepTheirAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "tagkeeptheir");
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", ">");
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the server dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TagMerger.this.theirTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            TagMerger.this.model.decide(nArray, MergeDecisionType.KEEP_THEIR);
            TagMerger.this.selectNextConflict(nArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(TagMerger.this.theirTable.getSelectedRowCount() > 0);
        }
    }

    class KeepMineAction
    extends AbstractAction
    implements ListSelectionListener {
        public KeepMineAction() {
            ImageIcon imageIcon = ImageProvider.get("dialogs/conflict", "tagkeepmine");
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
                this.putValue("Name", "");
            } else {
                this.putValue("Name", ">");
            }
            this.putValue("ShortDescription", I18n.tr("Keep the selected key/value pairs from the local dataset", new Object[0]));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TagMerger.this.mineTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            TagMerger.this.model.decide(nArray, MergeDecisionType.KEEP_MINE);
            TagMerger.this.selectNextConflict(nArray);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(TagMerger.this.mineTable.getSelectedRowCount() > 0);
        }
    }
}

