/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

public class SourceButton
extends JComponent {
    private static final int LAYER_HEIGHT = 20;
    private static final int LEFT_PADDING = 5;
    private static final int TOP_PADDING = 5;
    private static final int BOTTOM_PADDING = 5;
    private transient TileSource[] sources;
    private final ImageIcon enlargeImage;
    private final ImageIcon shrinkImage;
    private final Dimension hiddenDimension;
    private int barWidth;
    private Dimension shownDimension;
    private Font font;
    private boolean isEnlarged = false;
    private int currentMap;
    private final SlippyMapBBoxChooser slippyMapBBoxChooser;
    private final transient MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                Point point = mouseEvent.getPoint();
                if (SourceButton.this.isEnlarged) {
                    if (SourceButton.this.barWidth < point.x && point.y < SourceButton.this.shrinkImage.getIconHeight()) {
                        SourceButton.this.toggle();
                    } else {
                        int n = (point.y - 5) / 20;
                        if (n >= 0 && n < SourceButton.this.sources.length) {
                            SourceButton.this.slippyMapBBoxChooser.toggleMapSource(SourceButton.this.sources[n]);
                            SourceButton.this.currentMap = n;
                            SourceButton.this.toggle();
                        }
                    }
                } else {
                    SourceButton.this.toggle();
                }
            }
        }
    };

    public SourceButton(SlippyMapBBoxChooser slippyMapBBoxChooser, Collection<TileSource> collection) {
        this.slippyMapBBoxChooser = slippyMapBBoxChooser;
        this.setSources(collection);
        this.enlargeImage = ImageProvider.get("layer-switcher-maximize");
        this.shrinkImage = ImageProvider.get("layer-switcher-minimize");
        this.hiddenDimension = new Dimension(this.enlargeImage.getIconWidth(), this.enlargeImage.getIconHeight());
        this.setPreferredSize(this.hiddenDimension);
        this.addMouseListener(this.mouseListener);
    }

    public final void setSources(Collection<TileSource> collection) {
        CheckParameterUtil.ensureParameterNotNull(collection, "sources");
        this.sources = collection.toArray(new TileSource[collection.size()]);
        this.shownDimension = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            this.calculateShownDimension();
            graphics2D.setFont(this.font);
            if (this.isEnlarged) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int n = 10;
                graphics2D.setColor(new Color(0, 0, 139, 179));
                graphics2D.fillRoundRect(0, 0, this.barWidth + this.shrinkImage.getIconWidth(), this.sources.length * 20 + 5 + 5, 10, 10);
                for (int i = 0; i < this.sources.length; ++i) {
                    graphics2D.setColor(Color.WHITE);
                    graphics2D.fillOval(5, 5 + i * 20 + 6, n, n);
                    graphics2D.drawString(this.sources[i].getName(), 5 + n + 5, 5 + i * 20 + graphics2D.getFontMetrics().getHeight());
                    if (this.currentMap != i) continue;
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.fillOval(6, 12 + i * 20, n - 2, n - 2);
                }
                graphics2D.drawImage(this.shrinkImage.getImage(), this.barWidth, 0, null);
            } else {
                graphics2D.drawImage(this.enlargeImage.getImage(), 0, 0, null);
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    public void toggle() {
        this.isEnlarged = !this.isEnlarged;
        this.calculateShownDimension();
        this.setPreferredSize(this.isEnlarged ? this.shownDimension : this.hiddenDimension);
        this.revalidate();
    }

    public void setCurrentMap(TileSource tileSource) {
        for (int i = 0; i < this.sources.length; ++i) {
            if (!this.sources[i].equals(tileSource)) continue;
            this.currentMap = i;
            return;
        }
        this.currentMap = 0;
    }

    private void calculateShownDimension() {
        if (this.shownDimension == null) {
            this.font = this.getFont().deriveFont(1).deriveFont(15.0f);
            int n = 0;
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            for (TileSource tileSource : this.sources) {
                int n2 = fontMetrics.stringWidth(tileSource.getName());
                if (n2 <= n) continue;
                n = n2;
            }
            this.barWidth = n + 50;
            this.shownDimension = new Dimension(this.barWidth + this.shrinkImage.getIconWidth(), this.sources.length * 20 + 5 + 5);
        }
    }
}

