/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.I18n;

public class UntaggedWay
extends Test {
    protected static final int EMPTY_WAY = 301;
    protected static final int UNTAGGED_WAY = 302;
    protected static final int UNNAMED_WAY = 303;
    protected static final int ONE_NODE_WAY = 304;
    protected static final int UNNAMED_JUNCTION = 305;
    protected static final int COMMENTED_WAY = 306;
    private Set<Way> waysUsedInRelations;
    public static final Set<String> NAMED_WAYS = new HashSet<String>();
    public static final Set<String> WHITELIST;

    public UntaggedWay() {
        super(I18n.tr("Untagged, empty and one node ways", new Object[0]), I18n.tr("This test checks for untagged, empty and one node ways.", new Object[0]));
    }

    @Override
    public void visit(Way way) {
        String string;
        if (!way.isUsable()) {
            return;
        }
        Map<String, String> map = way.getKeys();
        if (!(map.isEmpty() || (string = map.get("highway")) == null || !NAMED_WAYS.contains(string) || map.containsKey("name") || map.containsKey("ref") || "yes".equals(map.get("noname")))) {
            boolean bl = false;
            boolean bl2 = false;
            for (String string2 : way.keySet()) {
                boolean bl3 = bl2 = string2.startsWith("name:") || string2.endsWith("_name") || string2.endsWith("_ref");
                if (bl2) break;
                if (!"junction".equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl2 && !bl) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Unnamed ways", new Object[0]), 303, way));
            } else if (bl) {
                this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("Unnamed junction", new Object[0]), 305, way));
            }
        }
        if (!way.isTagged() && !this.waysUsedInRelations.contains(way)) {
            if (way.hasKeys()) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Untagged ways (commented)", new Object[0]), 306, way));
            } else {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Untagged ways", new Object[0]), 302, way));
            }
        }
        if (way.getNodesCount() == 0) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("Empty ways", new Object[0]), 301, way));
        } else if (way.getNodesCount() == 1) {
            this.errors.add(new TestError((Test)this, Severity.ERROR, I18n.tr("One node ways", new Object[0]), 304, way));
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.waysUsedInRelations = new HashSet<Way>();
        for (Relation relation : Main.main.getCurrentDataSet().getRelations()) {
            if (!relation.isUsable()) continue;
            for (RelationMember relationMember : relation.getMembers()) {
                OsmPrimitive osmPrimitive;
                if (!relation.isMultipolygon() && !WHITELIST.contains(relationMember.getRole()) || !((osmPrimitive = relationMember.getMember()) instanceof Way) || !osmPrimitive.isUsable() || osmPrimitive.isTagged()) continue;
                this.waysUsedInRelations.add((Way)osmPrimitive);
            }
        }
    }

    @Override
    public void endTest() {
        this.waysUsedInRelations = null;
        super.endTest();
    }

    @Override
    public boolean isFixable(TestError testError) {
        if (testError.getTester() instanceof UntaggedWay) {
            return testError.getCode() == 301 || testError.getCode() == 304;
        }
        return false;
    }

    @Override
    public Command fixError(TestError testError) {
        return this.deletePrimitivesIfNeeded(testError.getPrimitives());
    }

    @Override
    public boolean isPrimitiveUsable(OsmPrimitive osmPrimitive) {
        return osmPrimitive.isUsable();
    }

    static {
        NAMED_WAYS.add("motorway");
        NAMED_WAYS.add("trunk");
        NAMED_WAYS.add("primary");
        NAMED_WAYS.add("secondary");
        NAMED_WAYS.add("tertiary");
        NAMED_WAYS.add("residential");
        NAMED_WAYS.add("pedestrian");
        WHITELIST = new HashSet<String>();
        WHITELIST.add("outer");
        WHITELIST.add("inner");
        WHITELIST.add("perimeter");
        WHITELIST.add("edge");
        WHITELIST.add("outline");
    }
}

