/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;

public class SimplePrimitiveId
implements PrimitiveId,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long id;
    private final OsmPrimitiveType type;
    public static final Pattern ID_PATTERN = Pattern.compile("((n(ode)?|w(ay)?|r(el(ation)?)?)[ /]?)(\\d+)");

    public SimplePrimitiveId(long l, OsmPrimitiveType osmPrimitiveType) {
        this.id = l;
        this.type = osmPrimitiveType;
    }

    @Override
    public OsmPrimitiveType getType() {
        return this.type;
    }

    @Override
    public long getUniqueId() {
        return this.id;
    }

    @Override
    public boolean isNew() {
        return this.id <= 0L;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.id ^ this.id >>> 32);
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SimplePrimitiveId simplePrimitiveId = (SimplePrimitiveId)object;
        if (this.id != simplePrimitiveId.id) {
            return false;
        }
        return !(this.type == null ? simplePrimitiveId.type != null : !this.type.equals((Object)simplePrimitiveId.type));
    }

    public String toString() {
        return (Object)((Object)this.type) + " " + this.id;
    }

    public static SimplePrimitiveId fromString(String string) {
        Matcher matcher = ID_PATTERN.matcher(string);
        if (matcher.matches()) {
            return new SimplePrimitiveId(Long.parseLong(matcher.group(matcher.groupCount())), string.charAt(0) == 'n' ? OsmPrimitiveType.NODE : (string.charAt(0) == 'w' ? OsmPrimitiveType.WAY : OsmPrimitiveType.RELATION));
        }
        throw new IllegalArgumentException("The string " + string + " does not match the pattern " + ID_PATTERN);
    }

    public static List<SimplePrimitiveId> fuzzyParse(String string) {
        ArrayList<SimplePrimitiveId> arrayList = new ArrayList<SimplePrimitiveId>();
        Matcher matcher = ID_PATTERN.matcher(string);
        while (matcher.find()) {
            char c = string.charAt(matcher.start());
            arrayList.add(new SimplePrimitiveId(Long.parseLong(matcher.group(matcher.groupCount())), c == 'n' ? OsmPrimitiveType.NODE : (c == 'w' ? OsmPrimitiveType.WAY : OsmPrimitiveType.RELATION)));
        }
        return arrayList;
    }
}

