/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.AbstractVisitor;

public class PrimitiveDeepCopy {
    private final List<PrimitiveData> directlyAdded = new ArrayList<PrimitiveData>();
    private final List<PrimitiveData> referenced = new ArrayList<PrimitiveData>();
    private final CopyOnWriteArrayList<PasteBufferChangedListener> listeners = new CopyOnWriteArrayList();

    public PrimitiveDeepCopy() {
    }

    public PrimitiveDeepCopy(Collection<? extends OsmPrimitive> collection) {
        this.makeCopy(collection);
    }

    public final void makeCopy(final Collection<? extends OsmPrimitive> collection) {
        this.directlyAdded.clear();
        this.referenced.clear();
        final HashSet hashSet = new HashSet();
        final HashSet hashSet2 = new HashSet();
        final HashSet hashSet3 = new HashSet();
        new AbstractVisitor(){
            private boolean firstIteration;

            @Override
            public void visit(Node node) {
                if (!hashSet.add(node.getUniqueId())) {
                    return;
                }
                (this.firstIteration ? PrimitiveDeepCopy.this.directlyAdded : PrimitiveDeepCopy.this.referenced).add(node.save());
            }

            @Override
            public void visit(Way way) {
                if (!hashSet2.add(way.getUniqueId())) {
                    return;
                }
                (this.firstIteration ? PrimitiveDeepCopy.this.directlyAdded : PrimitiveDeepCopy.this.referenced).add(way.save());
                this.firstIteration = false;
                for (Node node : way.getNodes()) {
                    this.visit(node);
                }
            }

            @Override
            public void visit(Relation relation) {
                if (!hashSet3.add(relation.getUniqueId())) {
                    return;
                }
                (this.firstIteration ? PrimitiveDeepCopy.this.directlyAdded : PrimitiveDeepCopy.this.referenced).add(relation.save());
                this.firstIteration = false;
                for (RelationMember relationMember : relation.getMembers()) {
                    relationMember.getMember().accept(this);
                }
            }

            public final void visitAll() {
                for (OsmPrimitive osmPrimitive : collection) {
                    this.firstIteration = true;
                    osmPrimitive.accept(this);
                }
            }
        }.visitAll();
        this.firePasteBufferChanged();
    }

    public List<PrimitiveData> getDirectlyAdded() {
        return this.directlyAdded;
    }

    public List<PrimitiveData> getReferenced() {
        return this.referenced;
    }

    public List<PrimitiveData> getAll() {
        ArrayList<PrimitiveData> arrayList = new ArrayList<PrimitiveData>(this.directlyAdded.size() + this.referenced.size());
        arrayList.addAll(this.directlyAdded);
        arrayList.addAll(this.referenced);
        return arrayList;
    }

    public boolean isEmpty() {
        return this.directlyAdded.isEmpty() && this.referenced.isEmpty();
    }

    private void firePasteBufferChanged() {
        for (PasteBufferChangedListener pasteBufferChangedListener : this.listeners) {
            pasteBufferChangedListener.pasteBufferChanged(this);
        }
    }

    public void addPasteBufferChangedListener(PasteBufferChangedListener pasteBufferChangedListener) {
        this.listeners.addIfAbsent(pasteBufferChangedListener);
    }

    public void removePasteBufferChangedListener(PasteBufferChangedListener pasteBufferChangedListener) {
        this.listeners.remove(pasteBufferChangedListener);
    }

    public static interface PasteBufferChangedListener {
        public void pasteBufferChanged(PrimitiveDeepCopy var1);
    }
}

