/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import java.net.MalformedURLException;
import java.net.URL;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.basic.DefaultOAuthProvider;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class OAuthParameters {
    public static final String DEFAULT_JOSM_CONSUMER_KEY = "F7zPYlVCqE2BUH9Hr4SsWZSOnrKjpug1EgqkbsSb";
    public static final String DEFAULT_JOSM_CONSUMER_SECRET = "rIkjpPcBNkMQxrqzcOvOC4RRuYupYr7k8mfP13H5";
    public static final String DEFAULT_REQUEST_TOKEN_URL = Main.getOSMWebsite() + "/oauth/request_token";
    public static final String DEFAULT_ACCESS_TOKEN_URL = Main.getOSMWebsite() + "/oauth/access_token";
    public static final String DEFAULT_AUTHORISE_URL = Main.getOSMWebsite() + "/oauth/authorize";
    private String consumerKey;
    private String consumerSecret;
    private String requestTokenUrl;
    private String accessTokenUrl;
    private String authoriseUrl;

    public static OAuthParameters createDefault() {
        return OAuthParameters.createDefault(null);
    }

    public static OAuthParameters createDefault(String string) {
        OAuthParameters oAuthParameters = new OAuthParameters();
        oAuthParameters.setConsumerKey(DEFAULT_JOSM_CONSUMER_KEY);
        oAuthParameters.setConsumerSecret(DEFAULT_JOSM_CONSUMER_SECRET);
        oAuthParameters.setRequestTokenUrl(DEFAULT_REQUEST_TOKEN_URL);
        oAuthParameters.setAccessTokenUrl(DEFAULT_ACCESS_TOKEN_URL);
        oAuthParameters.setAuthoriseUrl(DEFAULT_AUTHORISE_URL);
        if (!"https://api.openstreetmap.org/api".equals(string)) {
            try {
                String string2 = new URL(string).getHost();
                if (string2.endsWith("dev.openstreetmap.org")) {
                    oAuthParameters.setRequestTokenUrl(DEFAULT_REQUEST_TOKEN_URL.replace("www.openstreetmap.org", string2));
                    oAuthParameters.setAccessTokenUrl(DEFAULT_ACCESS_TOKEN_URL.replace("www.openstreetmap.org", string2));
                    oAuthParameters.setAuthoriseUrl(DEFAULT_AUTHORISE_URL.replace("www.openstreetmap.org", string2));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return oAuthParameters;
    }

    public static OAuthParameters createFromPreferences(Preferences preferences) {
        OAuthParameters oAuthParameters = OAuthParameters.createDefault(preferences.get("osm-server.url"));
        oAuthParameters.setConsumerKey(preferences.get("oauth.settings.consumer-key", oAuthParameters.getConsumerKey()));
        oAuthParameters.setConsumerSecret(preferences.get("oauth.settings.consumer-secret", oAuthParameters.getConsumerSecret()));
        oAuthParameters.setRequestTokenUrl(preferences.get("oauth.settings.request-token-url", oAuthParameters.getRequestTokenUrl()));
        oAuthParameters.setAccessTokenUrl(preferences.get("oauth.settings.access-token-url", oAuthParameters.getAccessTokenUrl()));
        oAuthParameters.setAuthoriseUrl(preferences.get("oauth.settings.authorise-url", oAuthParameters.getAuthoriseUrl()));
        return oAuthParameters;
    }

    public OAuthParameters() {
    }

    public OAuthParameters(OAuthParameters oAuthParameters) {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "other");
        this.consumerKey = oAuthParameters.consumerKey;
        this.consumerSecret = oAuthParameters.consumerSecret;
        this.accessTokenUrl = oAuthParameters.accessTokenUrl;
        this.requestTokenUrl = oAuthParameters.requestTokenUrl;
        this.authoriseUrl = oAuthParameters.authoriseUrl;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String string) {
        this.consumerKey = string;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String string) {
        this.consumerSecret = string;
    }

    public String getRequestTokenUrl() {
        return this.requestTokenUrl;
    }

    public void setRequestTokenUrl(String string) {
        this.requestTokenUrl = string;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String string) {
        this.accessTokenUrl = string;
    }

    public String getAuthoriseUrl() {
        return this.authoriseUrl;
    }

    public void setAuthoriseUrl(String string) {
        this.authoriseUrl = string;
    }

    public OAuthConsumer buildConsumer() {
        return new DefaultOAuthConsumer(this.consumerKey, this.consumerSecret);
    }

    public OAuthProvider buildProvider(OAuthConsumer oAuthConsumer) {
        CheckParameterUtil.ensureParameterNotNull(oAuthConsumer, "consumer");
        return new DefaultOAuthProvider(this.requestTokenUrl, this.accessTokenUrl, this.authoriseUrl);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.accessTokenUrl == null ? 0 : this.accessTokenUrl.hashCode());
        n = 31 * n + (this.authoriseUrl == null ? 0 : this.authoriseUrl.hashCode());
        n = 31 * n + (this.consumerKey == null ? 0 : this.consumerKey.hashCode());
        n = 31 * n + (this.consumerSecret == null ? 0 : this.consumerSecret.hashCode());
        n = 31 * n + (this.requestTokenUrl == null ? 0 : this.requestTokenUrl.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OAuthParameters oAuthParameters = (OAuthParameters)object;
        if (this.accessTokenUrl == null ? oAuthParameters.accessTokenUrl != null : !this.accessTokenUrl.equals(oAuthParameters.accessTokenUrl)) {
            return false;
        }
        if (this.authoriseUrl == null ? oAuthParameters.authoriseUrl != null : !this.authoriseUrl.equals(oAuthParameters.authoriseUrl)) {
            return false;
        }
        if (this.consumerKey == null ? oAuthParameters.consumerKey != null : !this.consumerKey.equals(oAuthParameters.consumerKey)) {
            return false;
        }
        if (this.consumerSecret == null ? oAuthParameters.consumerSecret != null : !this.consumerSecret.equals(oAuthParameters.consumerSecret)) {
            return false;
        }
        return !(this.requestTokenUrl == null ? oAuthParameters.requestTokenUrl != null : !this.requestTokenUrl.equals(oAuthParameters.requestTokenUrl));
    }
}

