/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.FeatureAdapter;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.data.preferences.IntegerProperty;

public class TMSCachedTileLoaderJob
extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry>
implements TileJob,
ICachedLoaderListener {
    private static final Logger log = FeatureAdapter.getLogger(TMSCachedTileLoaderJob.class.getCanonicalName());
    private Tile tile;
    private volatile URL url;
    private static final ConcurrentMap<String, Set<TileLoaderListener>> inProgress = new ConcurrentHashMap<String, Set<TileLoaderListener>>();
    public static final IntegerProperty HOST_LIMIT = new IntegerProperty("imagery.tms.tmsloader.maxjobsperhost", 6);
    private static Map<String, Semaphore> HOST_LIMITS = new ConcurrentHashMap<String, Semaphore>();
    public static final IntegerProperty THREAD_LIMIT = new IntegerProperty("imagery.tms.tmsloader.maxjobs", 25);
    private static ThreadPoolExecutor DOWNLOAD_JOB_DISPATCHER = TMSCachedTileLoaderJob.getThreadPoolExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Semaphore getSemaphore() {
        String string = this.getUrl().getHost();
        Semaphore semaphore = HOST_LIMITS.get(string);
        if (semaphore == null) {
            Map<String, Semaphore> map = HOST_LIMITS;
            synchronized (map) {
                semaphore = HOST_LIMITS.get(string);
                if (semaphore == null) {
                    semaphore = new Semaphore(HOST_LIMIT.get());
                    HOST_LIMITS.put(string, semaphore);
                }
            }
        }
        return semaphore;
    }

    private boolean acquireSemaphore() {
        boolean bl = true;
        Semaphore semaphore = this.getSemaphore();
        if (semaphore != null && !(bl = semaphore.tryAcquire())) {
            Main.debug("rejecting job because of per host limit");
        }
        return bl;
    }

    private void releaseSemaphore() {
        Semaphore semaphore = this.getSemaphore();
        if (semaphore != null) {
            semaphore.release();
        }
    }

    private static ThreadPoolExecutor getThreadPoolExecutor() {
        return new ThreadPoolExecutor(THREAD_LIMIT.get(), THREAD_LIMIT.get(), 30L, TimeUnit.SECONDS, new JCSCachedTileLoaderJob.LIFOQueue(5));
    }

    public static final void reconfigureDownloadDispatcher() {
        HOST_LIMITS = new ConcurrentHashMap<String, Semaphore>();
        DOWNLOAD_JOB_DISPATCHER = TMSCachedTileLoaderJob.getThreadPoolExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TMSCachedTileLoaderJob(TileLoaderListener tileLoaderListener, Tile tile, ICacheAccess<String, BufferedImageCacheEntry> iCacheAccess, int n, int n2, Map<String, String> map) {
        super(iCacheAccess, n, n2, map);
        this.tile = tile;
        if (tileLoaderListener != null) {
            String string = this.getCacheKey();
            ConcurrentMap<String, Set<TileLoaderListener>> concurrentMap = inProgress;
            synchronized (concurrentMap) {
                HashSet<TileLoaderListener> hashSet = (HashSet<TileLoaderListener>)inProgress.get(string);
                if (hashSet == null) {
                    hashSet = new HashSet<TileLoaderListener>();
                    inProgress.put(string, hashSet);
                }
                hashSet.add(tileLoaderListener);
            }
        }
    }

    @Override
    public Tile getTile() {
        return this.getCachedTile();
    }

    @Override
    public String getCacheKey() {
        if (this.tile != null) {
            return this.tile.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getUrl() {
        if (this.url == null) {
            try {
                TMSCachedTileLoaderJob tMSCachedTileLoaderJob = this;
                synchronized (tMSCachedTileLoaderJob) {
                    if (this.url == null) {
                        this.url = new URL(this.tile.getUrl());
                    }
                }
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "JCS TMS Cache - error creating URL for tile {0}: {1}", new Object[]{this.tile.getKey(), iOException.getMessage()});
                log.log(Level.INFO, "Exception: ", iOException);
            }
        }
        return this.url;
    }

    @Override
    public boolean isObjectLoadable() {
        if (this.cacheData != null) {
            byte[] byArray = ((BufferedImageCacheEntry)this.cacheData).getContent();
            try {
                return byArray != null || ((BufferedImageCacheEntry)this.cacheData).getImage() != null || this.cacheAsEmpty();
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "JCS TMS - error loading from cache for tile {0}: {1}", new Object[]{this.tile.getKey(), iOException.getMessage()});
            }
        }
        return false;
    }

    private boolean isNoTileAtZoom() {
        return this.attributes != null && this.attributes.isNoTileAtZoom();
    }

    @Override
    protected boolean cacheAsEmpty() {
        return this.isNoTileAtZoom();
    }

    private boolean handleNoTileAtZoom() {
        if (this.isNoTileAtZoom()) {
            log.log(Level.FINE, "JCS TMS - Tile valid, but no file, as no tiles at this level {0}", this.tile);
            this.tile.setError("No tile at this zoom level");
            this.tile.putValue("tile-info", "no-tile");
            return true;
        }
        return false;
    }

    @Override
    protected Executor getDownloadExecutor() {
        return DOWNLOAD_JOB_DISPATCHER;
    }

    @Override
    protected boolean executionGuard() {
        return this.acquireSemaphore();
    }

    @Override
    protected void executionFinished() {
        this.releaseSemaphore();
    }

    @Override
    public void submit() {
        this.tile.initLoading();
        super.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadingFinished(CacheEntry cacheEntry, ICachedLoaderListener.LoadResult loadResult) {
        block12: {
            Set set;
            Object object = inProgress;
            synchronized (object) {
                set = (Set)inProgress.remove(this.getCacheKey());
            }
            try {
                if (!this.tile.isLoaded()) {
                    this.tile.finishLoading();
                    switch (loadResult) {
                        case FAILURE: {
                            this.tile.setError("Problem loading tile");
                        }
                        case SUCCESS: {
                            this.handleNoTileAtZoom();
                            if (cacheEntry == null || (object = (Object)cacheEntry.getContent()) == null || ((Object)object).length <= 0) break;
                            this.tile.loadImage(new ByteArrayInputStream((byte[])object));
                        }
                    }
                }
                if (set == null) break block12;
                for (TileLoaderListener tileLoaderListener : set) {
                    tileLoaderListener.tileLoadingFinished(this.tile, loadResult.equals((Object)ICachedLoaderListener.LoadResult.SUCCESS));
                }
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "JCS TMS - error loading object for tile {0}: {1}", new Object[]{this.tile.getKey(), iOException.getMessage()});
                this.tile.setError(iOException.getMessage());
                this.tile.setLoaded(false);
                if (set == null) break block12;
                for (TileLoaderListener tileLoaderListener : set) {
                    tileLoaderListener.tileLoadingFinished(this.tile, false);
                }
            }
        }
    }

    public Tile getCachedTile() {
        BufferedImageCacheEntry bufferedImageCacheEntry = (BufferedImageCacheEntry)this.get();
        if (this.isObjectLoadable()) {
            try {
                if (bufferedImageCacheEntry != null && bufferedImageCacheEntry.getImage() != null) {
                    this.tile.setImage(bufferedImageCacheEntry.getImage());
                    this.tile.finishLoading();
                }
                if (this.isNoTileAtZoom()) {
                    this.handleNoTileAtZoom();
                    this.tile.finishLoading();
                }
                return this.tile;
            }
            catch (IOException iOException) {
                log.log(Level.WARNING, "JCS TMS - error loading object for tile {0}: {1}", new Object[]{this.tile.getKey(), iOException.getMessage()});
                return null;
            }
        }
        return this.tile;
    }

    @Override
    protected boolean handleNotFound() {
        this.tile.setError("No tile at this zoom level");
        this.tile.putValue("tile-info", "no-tile");
        return true;
    }

    @Override
    protected String getServerKey() {
        TileSource tileSource = this.tile.getSource();
        if (tileSource instanceof AbstractTMSTileSource) {
            return ((AbstractTMSTileSource)tileSource).getBaseUrl();
        }
        return super.getServerKey();
    }

    @Override
    protected BufferedImageCacheEntry createCacheEntry(byte[] byArray) {
        return new BufferedImageCacheEntry(byArray);
    }
}

