/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoaderJob;
import org.openstreetmap.josm.data.preferences.IntegerProperty;

public class TMSCachedTileLoader
implements TileLoader,
CachedTileLoader,
TileCache {
    private ICacheAccess<String, BufferedImageCacheEntry> cache;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> headers;
    private TileLoaderListener listener;
    public static final String PREFERENCE_PREFIX = "imagery.tms.cache.";
    public static final IntegerProperty MAX_OBJECTS_ON_DISK = new IntegerProperty("imagery.tms.cache.max_objects_disk", 25000);

    public TMSCachedTileLoader(TileLoaderListener tileLoaderListener, String string, int n, int n2, Map<String, String> map, String string2) throws IOException {
        this.cache = JCSCacheManager.getCache(string, 200, MAX_OBJECTS_ON_DISK.get(), string2);
        this.connectTimeout = n;
        this.readTimeout = n2;
        this.headers = map;
        this.listener = tileLoaderListener;
    }

    @Override
    public TileJob createTileLoaderJob(Tile tile) {
        return new TMSCachedTileLoaderJob(this.listener, tile, this.cache, this.connectTimeout, this.readTimeout, this.headers);
    }

    @Override
    public void clearCache(TileSource tileSource) {
        this.cache.clear();
    }

    @Override
    public Tile getTile(TileSource tileSource, int n, int n2, int n3) {
        return this.createTileLoaderJob(new Tile(tileSource, n, n2, n3)).getTile();
    }

    @Override
    public void addTile(Tile tile) {
        this.createTileLoaderJob(tile).getTile();
    }

    @Override
    public int getTileCount() {
        return 0;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public String getStats() {
        return this.cache.getStats();
    }
}

