/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.session.SessionImporter;
import org.openstreetmap.josm.io.session.SessionReader;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class SessionLoadAction
extends DiskAccessAction {
    public SessionLoadAction() {
        super(I18n.tr("Load Session", new Object[0]), "open", I18n.tr("Load a session from file.", new Object[0]), null, true, "load-session", true);
        this.putValue("help", HelpUtil.ht("/Action/SessionLoad"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AbstractFileChooser abstractFileChooser = SessionLoadAction.createAndOpenFileChooser(true, false, I18n.tr("Open session", new Object[0]), Arrays.asList(SessionImporter.FILE_FILTER, FileFilterAllFiles.getInstance()), SessionImporter.FILE_FILTER, 0, "lastDirectory");
        if (abstractFileChooser == null) {
            return;
        }
        File file = abstractFileChooser.getSelectedFile();
        boolean bl = file.getName().toLowerCase().endsWith(".joz");
        Main.worker.submit(new Loader(file, bl));
    }

    public static class Loader
    extends PleaseWaitRunnable {
        private boolean canceled;
        private File file;
        private final URI uri;
        private final InputStream is;
        private final boolean zip;
        private List<Layer> layers;
        private Layer active;
        private List<Runnable> postLoadTasks;
        private ViewportData viewport;

        public Loader(File file, boolean bl) {
            super(I18n.tr("Loading session ''{0}''", file.getName()));
            CheckParameterUtil.ensureParameterNotNull(file, "file");
            this.file = file;
            this.uri = null;
            this.is = null;
            this.zip = bl;
        }

        public Loader(InputStream inputStream, URI uRI, boolean bl) {
            super(I18n.tr("Loading session ''{0}''", uRI));
            CheckParameterUtil.ensureParameterNotNull(inputStream, "is");
            CheckParameterUtil.ensureParameterNotNull(uRI, "uri");
            this.file = null;
            this.uri = uRI;
            this.is = inputStream;
            this.zip = bl;
        }

        @Override
        public void cancel() {
            this.canceled = true;
        }

        @Override
        protected void finish() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Loader.this.canceled) {
                        return;
                    }
                    if (!Loader.this.layers.isEmpty()) {
                        boolean bl;
                        Layer layer = (Layer)Loader.this.layers.iterator().next();
                        boolean bl2 = bl = Main.map == null;
                        if (bl) {
                            Main.main.createMapFrame(layer, Loader.this.viewport);
                        }
                        for (Layer layer2 : Loader.this.layers) {
                            if (Loader.this.canceled) {
                                return;
                            }
                            Main.main.addLayer(layer2);
                        }
                        if (Loader.this.active != null) {
                            Main.map.mapView.setActiveLayer(Loader.this.active);
                        }
                        if (bl) {
                            Main.map.setVisible(true);
                        }
                    }
                    for (Runnable runnable : Loader.this.postLoadTasks) {
                        if (Loader.this.canceled) {
                            return;
                        }
                        if (runnable == null) continue;
                        runnable.run();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void realRun() {
            try {
                ProgressMonitor progressMonitor = this.getProgressMonitor();
                SessionReader sessionReader = new SessionReader();
                boolean bl = false;
                try {
                    if (this.file == null) {
                        this.file = File.createTempFile("session_", ".joz", Utils.getJosmTempDir());
                        bl = true;
                        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
                            Utils.copyStream(this.is, fileOutputStream);
                        }
                    }
                    sessionReader.loadSession(this.file, this.zip, progressMonitor);
                    this.layers = sessionReader.getLayers();
                    this.active = sessionReader.getActive();
                    this.postLoadTasks = sessionReader.getPostLoadTasks();
                    this.viewport = sessionReader.getViewport();
                }
                finally {
                    if (bl) {
                        if (!this.file.delete()) {
                            this.file.deleteOnExit();
                        }
                        this.file = null;
                    }
                }
            }
            catch (IllegalDataException illegalDataException) {
                this.handleException(I18n.tr("Data Error", new Object[0]), illegalDataException);
            }
            catch (IOException iOException) {
                this.handleException(I18n.tr("IO Error", new Object[0]), iOException);
            }
            catch (Exception exception) {
                this.cancel();
                throw exception;
            }
        }

        private void handleException(String string, Exception exception) {
            Main.error(exception);
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not load session file ''{0}''.<br>Error is:<br>{1}</html>", this.uri != null ? this.uri : this.file.getName(), exception.getMessage()), string, 0, null);
            this.cancel();
        }
    }
}

