/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;

public class OsmTileLoader
implements TileLoader {
    public Map<String, String> headers = new HashMap<String, String>();
    public int timeoutConnect = 0;
    public int timeoutRead = 0;
    protected TileLoaderListener listener;

    public OsmTileLoader(TileLoaderListener tileLoaderListener) {
        this.headers.put("Accept", "text/html, image/png, image/jpeg, image/gif, */*");
        this.listener = tileLoaderListener;
    }

    @Override
    public TileJob createTileLoaderJob(final Tile tile) {
        return new TileJob(){
            InputStream input = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = tile;
                synchronized (object) {
                    if (tile.isLoaded() && !tile.hasError() || tile.isLoading()) {
                        return;
                    }
                    tile.loaded = false;
                    tile.error = false;
                    tile.loading = true;
                }
                try {
                    object = OsmTileLoader.this.loadTileFromOsm(tile);
                    OsmTileLoader.this.loadTileMetadata(tile, (URLConnection)object);
                    if ("no-tile".equals(tile.getValue("tile-info"))) {
                        tile.setError("No tile at this zoom level");
                    } else {
                        this.input = ((URLConnection)object).getInputStream();
                        try {
                            tile.loadImage(this.input);
                        }
                        finally {
                            this.input.close();
                            this.input = null;
                        }
                    }
                    tile.setLoaded(true);
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, true);
                }
                catch (Exception exception) {
                    tile.setError(exception.getMessage());
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, false);
                    if (this.input == null) {
                        try {
                            System.err.println("Failed loading " + tile.getUrl() + ": " + exception.getClass() + ": " + exception.getMessage());
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
                finally {
                    tile.loading = false;
                    tile.setLoaded(true);
                }
            }

            @Override
            public Tile getTile() {
                return tile;
            }

            @Override
            public void submit() {
                this.run();
            }
        };
    }

    protected URLConnection loadTileFromOsm(Tile tile) throws IOException {
        URL uRL = new URL(tile.getUrl());
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            this.prepareHttpUrlConnection((HttpURLConnection)uRLConnection);
        }
        uRLConnection.setReadTimeout(30000);
        return uRLConnection;
    }

    protected void loadTileMetadata(Tile tile, URLConnection uRLConnection) {
        Long l;
        String string = uRLConnection.getHeaderField("X-VE-TILEMETA-CaptureDatesRange");
        if (string != null) {
            tile.putValue("capture-date", string);
        }
        if ((string = uRLConnection.getHeaderField("X-VE-Tile-Info")) != null) {
            tile.putValue("tile-info", string);
        }
        if ((l = Long.valueOf(uRLConnection.getExpiration())).equals(0L)) {
            try {
                string = uRLConnection.getHeaderField("Cache-Control");
                if (string != null) {
                    for (String string2 : string.split(",")) {
                        if (!string2.startsWith("max-age=")) continue;
                        l = Long.parseLong(string2.substring(8)) * 1000L + System.currentTimeMillis();
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!l.equals(0L)) {
            tile.putValue("expires", l.toString());
        }
    }

    protected void prepareHttpUrlConnection(HttpURLConnection httpURLConnection) {
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (this.timeoutConnect != 0) {
            httpURLConnection.setConnectTimeout(this.timeoutConnect);
        }
        if (this.timeoutRead != 0) {
            httpURLConnection.setReadTimeout(this.timeoutRead);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

