/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.NewPropertyAction;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewComponent;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertiesInsertManager;
import com.intellij.lang.properties.editor.ResourceBundleStructureViewModel;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.ui.PopupHandler;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleStructureViewComponent
extends PropertiesGroupingStructureViewComponent {
    private static final Logger LOG = Logger.getInstance(ResourceBundleStructureViewComponent.class);
    private final ResourceBundle myResourceBundle;

    public ResourceBundleStructureViewComponent(ResourceBundle resourceBundle, ResourceBundleEditor editor) {
        super(resourceBundle.getProject(), editor, new ResourceBundleStructureViewModel(resourceBundle));
        this.myResourceBundle = resourceBundle;
        this.tunePopupActionGroup();
    }

    protected ActionGroup createActionGroup() {
        DefaultActionGroup result = (DefaultActionGroup)super.createActionGroup();
        result.add((AnAction)new ContextHelpAction(this.getHelpID()), Constraints.LAST);
        return result;
    }

    @Override
    protected void addGroupByActions(DefaultActionGroup result) {
        super.addGroupByActions(result);
        result.add((AnAction)new NewPropertyAction(true), Constraints.FIRST);
    }

    private void tunePopupActionGroup() {
        DefaultActionGroup propertiesPopupGroup = new DefaultActionGroup();
        propertiesPopupGroup.copyFromGroup((DefaultActionGroup)ActionManager.getInstance().getAction("StructureViewPopupMenu"));
        propertiesPopupGroup.add((AnAction)Separator.getInstance(), Constraints.FIRST);
        propertiesPopupGroup.add((AnAction)new NewPropertyAction(true), Constraints.FIRST);
        PopupHandler.installPopupHandler((JComponent)this.getTree(), (ActionGroup)propertiesPopupGroup, (String)"StructureViewPopupMenu", (ActionManager)ActionManager.getInstance());
    }

    public Object getData(String dataId) {
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return new ResourceBundleAsVirtualFile(this.myResourceBundle);
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.getFileEditor();
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            Collection<ResourceBundleEditorViewElement> selectedElements = ((ResourceBundleEditor)this.getFileEditor()).getSelectedElements();
            if (selectedElements.isEmpty()) {
                return null;
            }
            if (selectedElements.size() == 1) {
                return ((ResourceBundleEditorViewElement)ContainerUtil.getFirstItem(selectedElements)).getPsiElements();
            }
            ArrayList psiElements = new ArrayList();
            for (ResourceBundleEditorViewElement selectedElement : selectedElements) {
                Collections.addAll(psiElements, selectedElement.getPsiElements());
            }
            return psiElements.toArray(new PsiElement[psiElements.size()]);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            PsiElement[] psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData((DataProvider)this);
            if (psiElements != null && psiElements.length > 0) {
                return new PsiElementsDeleteProvider(((ResourceBundleEditor)this.getFileEditor()).getPropertiesInsertDeleteManager(), psiElements);
            }
        } else if (UsageView.USAGE_TARGETS_KEY.is(dataId)) {
            PsiElement[] chosenElements = (PsiElement[])this.getData(LangDataKeys.PSI_ELEMENT_ARRAY.getName());
            if (chosenElements != null) {
                UsageTarget[] usageTargets = new UsageTarget[chosenElements.length];
                for (int i = 0; i < chosenElements.length; ++i) {
                    usageTargets[i] = new PsiElement2UsageTargetAdapter(chosenElements[i]);
                }
                return usageTargets;
            }
        } else if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return new CopyProvider(){

                public void performCopy(@NotNull DataContext dataContext) {
                    if (dataContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$1", "performCopy"));
                    }
                    PsiElement[] selectedPsiElements = (PsiElement[])ResourceBundleStructureViewComponent.this.getData(LangDataKeys.PSI_ELEMENT_ARRAY.getName());
                    if (selectedPsiElements != null) {
                        ArrayList<String> names = new ArrayList<String>(selectedPsiElements.length);
                        for (PsiElement element : selectedPsiElements) {
                            if (!(element instanceof PsiNamedElement)) continue;
                            names.add(((PsiNamedElement)element).getName());
                        }
                        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(StringUtil.join(names, (String)"\n")));
                    }
                }

                public boolean isCopyEnabled(@NotNull DataContext dataContext) {
                    if (dataContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$1", "isCopyEnabled"));
                    }
                    return true;
                }

                public boolean isCopyVisible(@NotNull DataContext dataContext) {
                    if (dataContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$1", "isCopyVisible"));
                    }
                    return true;
                }
            };
        }
        return super.getData(dataId);
    }

    protected boolean showScrollToFromSourceActions() {
        return false;
    }

    private class PsiElementsDeleteProvider
    implements DeleteProvider {
        private final ResourceBundlePropertiesInsertManager myInsertDeleteManager;
        private final PsiElement[] myElements;

        private PsiElementsDeleteProvider(ResourceBundlePropertiesInsertManager insertDeleteManager, PsiElement[] elements) {
            this.myInsertDeleteManager = insertDeleteManager;
            this.myElements = elements;
        }

        public void deleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$PsiElementsDeleteProvider", "deleteElement"));
            }
            List<PropertiesFile> bundlePropertiesFiles = ResourceBundleStructureViewComponent.this.myResourceBundle.getPropertiesFiles();
            ArrayList<PsiElement> toDelete = new ArrayList<PsiElement>();
            for (PsiElement element : this.myElements) {
                Property property = (Property)element;
                String key = property.getKey();
                if (key == null) {
                    LOG.error("key must be not null " + element);
                    continue;
                }
                for (PropertiesFile propertiesFile : bundlePropertiesFiles) {
                    for (IProperty iProperty : propertiesFile.findPropertiesByKey(key)) {
                        toDelete.add(iProperty.getPsiElement());
                    }
                }
            }
            new SafeDeleteHandler().invoke(this.myElements[0].getProject(), PsiUtilCore.toPsiElementArray(toDelete), dataContext);
            this.myInsertDeleteManager.reload();
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleStructureViewComponent$PsiElementsDeleteProvider", "canDeleteElement"));
            }
            return true;
        }
    }
}

