/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.storage.StorageOwner;

public abstract class AbstractStateStorage<Key, T>
implements StorageOwner {
    private PersistentHashMap<Key, T> myMap;
    private final File myBaseFile;
    private final KeyDescriptor<Key> myKeyDescriptor;
    private final DataExternalizer<T> myStateExternalizer;
    protected final Object myDataLock = new Object();

    public AbstractStateStorage(File storePath, KeyDescriptor<Key> keyDescriptor, DataExternalizer<T> stateExternalizer) throws IOException {
        this.myBaseFile = storePath;
        this.myKeyDescriptor = keyDescriptor;
        this.myStateExternalizer = stateExternalizer;
        this.myMap = this.createMap(storePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void force() {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myMap.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropMemoryCache() {
        Object object = this.myDataLock;
        synchronized (object) {
            if (this.myMap.isDirty()) {
                this.myMap.dropMemoryCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myMap.close();
        }
    }

    @Override
    public void clean() throws IOException {
        this.wipe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wipe() {
        Object object = this.myDataLock;
        synchronized (object) {
            try {
                this.myMap.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            PersistentHashMap.deleteFilesStartingWith((File)this.myBaseFile);
            try {
                this.myMap = this.createMap(this.myBaseFile);
            }
            catch (IOException ignored) {
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Key key, @Nullable T state) throws IOException {
        if (state != null) {
            Object object = this.myDataLock;
            synchronized (object) {
                this.myMap.put(key, state);
            }
        } else {
            this.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendData(Key key, final T data) throws IOException {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myMap.appendData(key, new PersistentHashMap.ValueDataAppender(){

                public void append(DataOutput out) throws IOException {
                    AbstractStateStorage.this.myStateExternalizer.save(out, data);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Key key) throws IOException {
        Object object = this.myDataLock;
        synchronized (object) {
            this.myMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getState(Key key) throws IOException {
        Object object = this.myDataLock;
        synchronized (object) {
            return (T)this.myMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Key> getKeys() throws IOException {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myMap.getAllKeysWithExistingMapping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Key> getKeysIterator() throws IOException {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.myMap.getAllKeysWithExistingMapping().iterator();
        }
    }

    private PersistentHashMap<Key, T> createMap(File file) throws IOException {
        FileUtil.createIfDoesntExist((File)file);
        return new PersistentHashMap(file, this.myKeyDescriptor, this.myStateExternalizer);
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            this.dropMemoryCache();
        } else {
            this.force();
        }
    }
}

