/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.classFilesIndex.indexer.api.storage;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class ClassFilesIndexStorageBase<K, V> {
    private static final String INDEX_FILE_NAME = "index";
    private static final int INITIAL_INDEX_SIZE = 16384;
    private static final int CACHE_QUEUES_SIZE = 16384;
    private final File myIndexFile;
    private final KeyDescriptor<K> myKeyDescriptor;
    private final DataExternalizer<V> myValueExternalizer;
    private PersistentHashMap<K, CompiledDataValueContainer<V>> myMap;
    protected final Lock myWriteLock = new ReentrantLock();
    protected SLRUCache<K, CompiledDataValueContainer<V>> myCache;

    public ClassFilesIndexStorageBase(File indexDir, KeyDescriptor<K> keyDescriptor, DataExternalizer<V> valueExternalizer) throws IOException {
        this.myIndexFile = ClassFilesIndexStorageBase.getIndexFile(indexDir);
        this.myKeyDescriptor = keyDescriptor;
        this.myValueExternalizer = valueExternalizer;
        this.initialize();
    }

    private void initialize() throws IOException {
        this.myMap = new PersistentHashMap(this.myIndexFile, this.myKeyDescriptor, ClassFilesIndexStorageBase.createValueContainerExternalizer(this.myValueExternalizer), 16384);
        this.myCache = new SLRUCache<K, CompiledDataValueContainer<V>>(16384, 16384){

            @NotNull
            public CompiledDataValueContainer<V> createValue(K key) {
                block4: {
                    CompiledDataValueContainer compiledDataValueContainer;
                    try {
                        CompiledDataValueContainer valueContainer = (CompiledDataValueContainer)ClassFilesIndexStorageBase.this.myMap.get(key);
                        if (valueContainer == null) break block4;
                        compiledDataValueContainer = valueContainer;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (compiledDataValueContainer == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/classFilesIndex/indexer/api/storage/ClassFilesIndexStorageBase$1", "createValue"));
                    }
                    return compiledDataValueContainer;
                }
                CompiledDataValueContainer compiledDataValueContainer = new CompiledDataValueContainer();
                if (compiledDataValueContainer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/classFilesIndex/indexer/api/storage/ClassFilesIndexStorageBase$1", "createValue"));
                }
                return compiledDataValueContainer;
            }

            protected void onDropFromCache(K key, CompiledDataValueContainer<V> value) {
                try {
                    ClassFilesIndexStorageBase.this.myMap.put(key, value);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        try {
            this.myWriteLock.lock();
            this.doDelete();
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    private void doDelete() throws IOException {
        this.close();
        PersistentHashMap.deleteFilesStartingWith((File)this.myIndexFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        try {
            this.myWriteLock.lock();
            this.doDelete();
            this.initialize();
        }
        finally {
            this.myWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            this.myWriteLock.lock();
            this.myCache.clear();
        }
        finally {
            this.myWriteLock.unlock();
        }
        this.myMap.force();
    }

    public void close() throws IOException {
        this.flush();
        this.myMap.close();
    }

    public static File getIndexFile(File indexDir) {
        return new File(indexDir, INDEX_FILE_NAME);
    }

    public static File getIndexDir(String indexName, File projectSystemBuildDirectory) {
        return new File(projectSystemBuildDirectory, "compiler.output.data.indices/" + indexName);
    }

    private static <V> DataExternalizer<CompiledDataValueContainer<V>> createValueContainerExternalizer(final DataExternalizer<V> valueExternalizer) {
        return new DataExternalizer<CompiledDataValueContainer<V>>(){

            public void save(final @NotNull DataOutput out, CompiledDataValueContainer<V> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/classFilesIndex/indexer/api/storage/ClassFilesIndexStorageBase$2", "save"));
                }
                TIntObjectHashMap underlying = value.myUnderlying;
                out.writeInt(underlying.size());
                final IOException[] ioException = new IOException[]{null};
                underlying.forEachEntry(new TIntObjectProcedure<V>(){

                    public boolean execute(int k, V v) {
                        try {
                            EnumeratorIntegerDescriptor.INSTANCE.save(out, (Object)k);
                            valueExternalizer.save(out, v);
                            return true;
                        }
                        catch (IOException e) {
                            ioException[0] = e;
                            return false;
                        }
                    }
                });
                if (ioException[0] != null) {
                    throw ioException[0];
                }
            }

            public CompiledDataValueContainer<V> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/jps/classFilesIndex/indexer/api/storage/ClassFilesIndexStorageBase$2", "read"));
                }
                TIntObjectHashMap map = new TIntObjectHashMap();
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    map.put(((Integer)EnumeratorIntegerDescriptor.INSTANCE.read(in)).intValue(), valueExternalizer.read(in));
                }
                return new CompiledDataValueContainer(map);
            }
        };
    }

    public static class CompiledDataValueContainer<V> {
        private final TIntObjectHashMap<V> myUnderlying;

        private CompiledDataValueContainer(TIntObjectHashMap<V> map) {
            this.myUnderlying = map;
        }

        private CompiledDataValueContainer() {
            this(new TIntObjectHashMap());
        }

        public void putValue(Integer inputId, V value) {
            this.myUnderlying.put(inputId.intValue(), value);
        }

        public Collection<V> getValues() {
            return ContainerUtil.list((Object[])this.myUnderlying.getValues());
        }
    }
}

