/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.util;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.command.HgWorkingCopyRevisionsCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.ShellCommand;
import org.zmlx.hg4idea.execution.ShellCommandException;
import org.zmlx.hg4idea.provider.HgChangeProvider;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgReferenceValidator;

public abstract class HgUtil {
    public static final Pattern URL_WITH_PASSWORD = Pattern.compile("(?:.+)://(?:.+)(:.+)@(?:.+)");
    public static final int MANY_FILES = 100;
    private static final Logger LOG = Logger.getInstance(HgUtil.class);
    public static final String DOT_HG = ".hg";
    public static final String TIP_REFERENCE = "tip";
    public static final String HEAD_REFERENCE = "HEAD";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyResourceToTempFile(String basename, String extension) throws IOException {
        InputStream in = HgUtil.class.getClassLoader().getResourceAsStream("python/" + basename + extension);
        File tempFile = FileUtil.createTempFile((String)basename, (String)extension);
        byte[] buffer = new byte[4096];
        OutputStream out = null;
        try {
            int bytesRead;
            out = new FileOutputStream(tempFile, false);
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {}
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static void markDirectoryDirty(Project project, VirtualFile file) throws InvocationTargetException, InterruptedException {
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(file);
    }

    public static void markFileDirty(final Project project, final VirtualFile file) throws InvocationTargetException, InterruptedException {
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
            }
        });
        HgUtil.runWriteActionAndWait(new Runnable(){

            @Override
            public void run() {
                file.refresh(true, false);
            }
        });
    }

    public static void runWriteActionAndWait(final @NotNull Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/zmlx/hg4idea/util/HgUtil", "runWriteActionAndWait"));
        }
        GuiUtils.runOrInvokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        });
    }

    public static void runWriteActionLater(final @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "org/zmlx/hg4idea/util/HgUtil", "runWriteActionLater"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        });
    }

    @Nullable
    public static File getTemporaryPythonFile(String base) {
        try {
            final File file = HgUtil.copyResourceToTempFile(base, ".py");
            final String fileName = file.getName();
            ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                @Override
                public void run() {
                    File[] files = file.getParentFile().listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.startsWith(fileName);
                        }
                    });
                    if (files != null) {
                        for (File file1 : files) {
                            file1.delete();
                        }
                    }
                }
            });
            return file;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static void removeFilesFromVcs(Project project, List<FilePath> files) {
        HgRemoveCommand command = new HgRemoveCommand(project);
        for (FilePath filePath : files) {
            VirtualFile vcsRoot = VcsUtil.getVcsRootFor((Project)project, (FilePath)filePath);
            if (vcsRoot == null) continue;
            command.execute(new HgFile(vcsRoot, filePath));
        }
    }

    @Nullable
    public static VirtualFile getNearestHgRoot(VirtualFile dir) {
        for (VirtualFile currentDir = dir; currentDir != null; currentDir = currentDir.getParent()) {
            if (!HgUtil.isHgRoot(currentDir)) continue;
            return currentDir;
        }
        return null;
    }

    public static boolean isHgRoot(@Nullable VirtualFile dir) {
        return dir != null && dir.findChild(DOT_HG) != null;
    }

    @Nullable
    public static VirtualFile getHgRootOrNull(Project project, FilePath filePath) {
        if (project == null) {
            return HgUtil.getNearestHgRoot(VcsUtil.getVirtualFile((String)filePath.getPath()));
        }
        return HgUtil.getNearestHgRoot(VcsUtil.getVcsRootFor((Project)project, (FilePath)filePath));
    }

    @NotNull
    public static Set<VirtualFile> hgRoots(@NotNull Project project, @NotNull Collection<FilePath> filePaths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "hgRoots"));
        }
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "org/zmlx/hg4idea/util/HgUtil", "hgRoots"));
        }
        HashSet<VirtualFile> roots = new HashSet<VirtualFile>();
        for (FilePath path : filePaths) {
            ContainerUtil.addIfNotNull(roots, (Object)HgUtil.getHgRootOrNull(project, path));
        }
        HashSet<VirtualFile> hashSet = roots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "hgRoots"));
        }
        return hashSet;
    }

    @Nullable
    public static VirtualFile getHgRootOrNull(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/util/HgUtil", "getHgRootOrNull"));
        }
        return HgUtil.getHgRootOrNull(project, VcsUtil.getFilePath((String)file.getPath()));
    }

    @NotNull
    public static VirtualFile getHgRootOrThrow(Project project, FilePath filePath) throws VcsException {
        VirtualFile vf = HgUtil.getHgRootOrNull(project, filePath);
        if (vf == null) {
            throw new VcsException(HgVcsMessages.message("hg4idea.exception.file.not.under.hg", filePath.getPresentableUrl()));
        }
        VirtualFile virtualFile = vf;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getHgRootOrThrow"));
        }
        return virtualFile;
    }

    @NotNull
    public static VirtualFile getHgRootOrThrow(Project project, VirtualFile file) throws VcsException {
        VirtualFile virtualFile = HgUtil.getHgRootOrThrow(project, VcsUtil.getFilePath((String)file.getPath()));
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getHgRootOrThrow"));
        }
        return virtualFile;
    }

    @Nullable
    public static VirtualFile getSelectedFile(@NotNull Project project) {
        Editor editor;
        FileEditorManager manager;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getSelectedFile"));
        }
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor((Project)project, (StatusBar)statusBar);
        VirtualFile result = null;
        if (fileEditor != null && fileEditor instanceof TextEditor) {
            Document document = ((TextEditor)fileEditor).getEditor().getDocument();
            result = FileDocumentManager.getInstance().getFile(document);
        }
        if (result == null && (manager = FileEditorManager.getInstance((Project)project)) != null && (editor = manager.getSelectedTextEditor()) != null) {
            result = FileDocumentManager.getInstance().getFile(editor.getDocument());
        }
        return result;
    }

    @Nullable
    public static VirtualFile getRootForSelectedFile(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getRootForSelectedFile"));
        }
        VirtualFile selectedFile = HgUtil.getSelectedFile(project);
        if (selectedFile != null) {
            return HgUtil.getHgRootOrNull(project, selectedFile);
        }
        return null;
    }

    @Nullable
    public static String getNewBranchNameFromUser(@NotNull HgRepository repository, @NotNull String dialogTitle) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/util/HgUtil", "getNewBranchNameFromUser"));
        }
        if (dialogTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialogTitle", "org/zmlx/hg4idea/util/HgUtil", "getNewBranchNameFromUser"));
        }
        return Messages.showInputDialog((Project)repository.getProject(), (String)"Enter the name of new branch:", (String)dialogTitle, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)HgReferenceValidator.newInstance(repository));
    }

    public static boolean isMergeInProgress(@NotNull Project project, VirtualFile repository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "isMergeInProgress"));
        }
        return new HgWorkingCopyRevisionsCommand(project).parents(repository).size() > 1;
    }

    @NotNull
    public static Map<VirtualFile, List<String>> getRelativePathsByRepository(Collection<HgFile> hgFiles) {
        HashMap<VirtualFile, List<String>> map = new HashMap<VirtualFile, List<String>>();
        if (hgFiles == null) {
            HashMap<VirtualFile, List<String>> hashMap = map;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getRelativePathsByRepository"));
            }
            return hashMap;
        }
        for (HgFile file : hgFiles) {
            VirtualFile repo = file.getRepo();
            ArrayList<String> files = (ArrayList<String>)map.get(repo);
            if (files == null) {
                files = new ArrayList<String>();
                map.put(repo, files);
            }
            files.add(file.getRelativePath());
        }
        HashMap<VirtualFile, List<String>> hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getRelativePathsByRepository"));
        }
        return hashMap;
    }

    @NotNull
    public static HgFile getFileNameInTargetRevision(Project project, HgRevisionNumber vcsRevisionNumber, HgFile localHgFile) {
        HgStatusCommand statCommand = new HgStatusCommand.Builder(false).copySource(true).baseRevision(vcsRevisionNumber).build(project);
        Set<HgChange> changes = statCommand.execute(localHgFile.getRepo(), Collections.singletonList(localHgFile.toFilePath()));
        for (HgChange change : changes) {
            if (!change.afterFile().equals(localHgFile)) continue;
            HgFile hgFile = change.beforeFile();
            if (hgFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getFileNameInTargetRevision"));
            }
            return hgFile;
        }
        HgFile hgFile = localHgFile;
        if (hgFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getFileNameInTargetRevision"));
        }
        return hgFile;
    }

    @NotNull
    public static FilePath getOriginalFileName(@NotNull FilePath filePath, ChangeListManager changeListManager) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/zmlx/hg4idea/util/HgUtil", "getOriginalFileName"));
        }
        Change change = changeListManager.getChange(filePath);
        if (change == null) {
            FilePath filePath2 = filePath;
            if (filePath2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getOriginalFileName"));
            }
            return filePath2;
        }
        FileStatus status = change.getFileStatus();
        if (status == HgChangeProvider.COPIED || status == HgChangeProvider.RENAMED) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            assert (beforeRevision != null) : "If a file's status is copied or renamed, there must be an previous version";
            FilePath filePath3 = beforeRevision.getFile();
            if (filePath3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getOriginalFileName"));
            }
            return filePath3;
        }
        FilePath filePath4 = filePath;
        if (filePath4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getOriginalFileName"));
        }
        return filePath4;
    }

    @NotNull
    public static List<VirtualFile> getHgRepositories(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getHgRepositories"));
        }
        LinkedList<VirtualFile> repos = new LinkedList<VirtualFile>();
        for (VcsRoot root : ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots()) {
            if (!"hg4idea".equals(root.getVcs().getName())) continue;
            repos.add(root.getPath());
        }
        LinkedList<VirtualFile> linkedList = repos;
        if (linkedList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getHgRepositories"));
        }
        return linkedList;
    }

    @NotNull
    public static Map<VirtualFile, Collection<VirtualFile>> sortByHgRoots(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "sortByHgRoots"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/zmlx/hg4idea/util/HgUtil", "sortByHgRoots"));
        }
        HashMap<VirtualFile, Collection<VirtualFile>> sorted = new HashMap<VirtualFile, Collection<VirtualFile>>();
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        for (VirtualFile file : files) {
            HgRepository repo = (HgRepository)repositoryManager.getRepositoryForFile(file);
            if (repo == null) continue;
            HashSet<VirtualFile> filesForRoot = (HashSet<VirtualFile>)sorted.get(repo.getRoot());
            if (filesForRoot == null) {
                filesForRoot = new HashSet<VirtualFile>();
                sorted.put(repo.getRoot(), filesForRoot);
            }
            filesForRoot.add(file);
        }
        HashMap<VirtualFile, Collection<VirtualFile>> hashMap = sorted;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "sortByHgRoots"));
        }
        return hashMap;
    }

    @NotNull
    public static Map<VirtualFile, Collection<FilePath>> groupFilePathsByHgRoots(@NotNull Project project, @NotNull Collection<FilePath> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "groupFilePathsByHgRoots"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/zmlx/hg4idea/util/HgUtil", "groupFilePathsByHgRoots"));
        }
        HashMap<VirtualFile, Collection<FilePath>> sorted = new HashMap<VirtualFile, Collection<FilePath>>();
        if (project.isDisposed()) {
            HashMap<VirtualFile, Collection<FilePath>> hashMap = sorted;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "groupFilePathsByHgRoots"));
            }
            return hashMap;
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        for (FilePath file : files) {
            HgRepository repo = (HgRepository)repositoryManager.getRepositoryForFile(file);
            if (repo == null) continue;
            HashSet<FilePath> filesForRoot = (HashSet<FilePath>)sorted.get(repo.getRoot());
            if (filesForRoot == null) {
                filesForRoot = new HashSet<FilePath>();
                sorted.put(repo.getRoot(), filesForRoot);
            }
            filesForRoot.add(file);
        }
        HashMap<VirtualFile, Collection<FilePath>> hashMap = sorted;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "groupFilePathsByHgRoots"));
        }
        return hashMap;
    }

    public static void executeOnPooledThreadIfNeeded(Runnable runnable) {
        if (EventQueue.isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable);
        } else {
            runnable.run();
        }
    }

    @Nullable
    public static VirtualFile convertToLocalVirtualFile(@Nullable VirtualFile file) {
        if (!(file instanceof AbstractVcsVirtualFile)) {
            return file;
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        VirtualFile resultFile = lfs.findFileByPath(file.getPath());
        if (resultFile == null) {
            resultFile = lfs.refreshAndFindFileByPath(file.getPath());
        }
        return resultFile;
    }

    @NotNull
    public static List<Change> getDiff(@NotNull Project project, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable HgFileRevision rev1, @Nullable HgFileRevision rev2) {
        HgStatusCommand statusCommand;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getDiff"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/util/HgUtil", "getDiff"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/util/HgUtil", "getDiff"));
        }
        HgRevisionNumber revNumber1 = null;
        if (rev1 != null) {
            revNumber1 = rev1.getRevisionNumber();
            statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(false).baseRevision(revNumber1).targetRevision(rev2 != null ? rev2.getRevisionNumber() : null).build(project);
        } else {
            LOG.assertTrue(rev2 != null, (Object)("revision1 and revision2 can't both be null. Path: " + path));
            statusCommand = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(false).baseRevision(rev2.getRevisionNumber()).build(project);
        }
        Set<HgChange> hgChanges = statusCommand.execute(root, Collections.singleton(path));
        ArrayList<Change> changes = new ArrayList<Change>();
        for (HgChange hgChange : hgChanges) {
            FileStatus status = HgUtil.convertHgDiffStatus(hgChange.getStatus());
            if (status == FileStatus.UNKNOWN) continue;
            changes.add(HgUtil.createChange(project, root, hgChange.beforeFile().getRelativePath(), revNumber1, hgChange.afterFile().getRelativePath(), rev2 != null ? rev2.getRevisionNumber() : null, status));
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getDiff"));
        }
        return arrayList;
    }

    @NotNull
    public static Change createChange(@NotNull Project project, VirtualFile root, @NotNull String fileBefore, @Nullable HgRevisionNumber revisionBefore, @NotNull String fileAfter, @Nullable HgRevisionNumber revisionAfter, @NotNull FileStatus aStatus) {
        HgContentRevision beforeRevision;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "createChange"));
        }
        if (fileBefore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBefore", "org/zmlx/hg4idea/util/HgUtil", "createChange"));
        }
        if (fileAfter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileAfter", "org/zmlx/hg4idea/util/HgUtil", "createChange"));
        }
        if (aStatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStatus", "org/zmlx/hg4idea/util/HgUtil", "createChange"));
        }
        HgContentRevision hgContentRevision = beforeRevision = revisionBefore == null ? null : new HgContentRevision(project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        if (revisionAfter == null) {
            ContentRevision currentRevision = CurrentContentRevision.create((FilePath)new HgFile(root, new File(root.getPath(), fileBefore)).toFilePath());
            Change change = new Change((ContentRevision)beforeRevision, currentRevision, aStatus);
            if (change == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "createChange"));
            }
            return change;
        }
        HgContentRevision afterRevision = new HgContentRevision(project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        Change change = new Change((ContentRevision)beforeRevision, (ContentRevision)afterRevision, aStatus);
        if (change == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "createChange"));
        }
        return change;
    }

    @NotNull
    public static FileStatus convertHgDiffStatus(@NotNull HgFileStatusEnum hgstatus) {
        if (hgstatus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgstatus", "org/zmlx/hg4idea/util/HgUtil", "convertHgDiffStatus"));
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.ADDED)) {
            FileStatus fileStatus = FileStatus.ADDED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "convertHgDiffStatus"));
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.DELETED)) {
            FileStatus fileStatus = FileStatus.DELETED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "convertHgDiffStatus"));
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.MODIFIED)) {
            FileStatus fileStatus = FileStatus.MODIFIED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "convertHgDiffStatus"));
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.COPY)) {
            FileStatus fileStatus = HgChangeProvider.COPIED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "convertHgDiffStatus"));
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.UNVERSIONED)) {
            FileStatus fileStatus = FileStatus.UNKNOWN;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "convertHgDiffStatus"));
            }
            return fileStatus;
        }
        if (hgstatus.equals((Object)HgFileStatusEnum.IGNORED)) {
            FileStatus fileStatus = FileStatus.IGNORED;
            if (fileStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "convertHgDiffStatus"));
            }
            return fileStatus;
        }
        FileStatus fileStatus = FileStatus.UNKNOWN;
        if (fileStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "convertHgDiffStatus"));
        }
        return fileStatus;
    }

    public static String removePasswordIfNeeded(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/zmlx/hg4idea/util/HgUtil", "removePasswordIfNeeded"));
        }
        Matcher matcher = URL_WITH_PASSWORD.matcher(path);
        if (matcher.matches()) {
            return path.substring(0, matcher.start(1)) + path.substring(matcher.end(1), path.length());
        }
        return path;
    }

    @NotNull
    public static String getDisplayableBranchOrBookmarkText(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/util/HgUtil", "getDisplayableBranchOrBookmarkText"));
        }
        Repository.State state = repository.getState();
        String branchText = "";
        if (state != Repository.State.NORMAL) {
            branchText = branchText + state.toString() + " ";
        }
        String string = branchText + repository.getCurrentBranchName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getDisplayableBranchOrBookmarkText"));
        }
        return string;
    }

    @NotNull
    public static HgRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryManager"));
        }
        HgRepositoryManager hgRepositoryManager = (HgRepositoryManager)((Object)ServiceManager.getService((Project)project, HgRepositoryManager.class));
        if (hgRepositoryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryManager"));
        }
        return hgRepositoryManager;
    }

    @Nullable
    public static HgRepository getCurrentRepository(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getCurrentRepository"));
        }
        VirtualFile file = DvcsUtil.getSelectedFile((Project)project);
        return HgUtil.getRepositoryForFile(project, file);
    }

    @Nullable
    public static HgRepository getRepositoryForFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryForFile"));
        }
        if (file == null || project.isDisposed()) {
            return null;
        }
        HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
        VirtualFile root = HgUtil.getHgRootOrNull(project, file);
        return (HgRepository)repositoryManager.getRepositoryForRoot(root);
    }

    @Nullable
    public static String getRepositoryDefaultPath(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryDefaultPath"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryDefaultPath"));
        }
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getDefaultPath();
    }

    @Nullable
    public static String getRepositoryDefaultPushPath(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryDefaultPushPath"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryDefaultPushPath"));
        }
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getDefaultPushPath();
    }

    @Nullable
    public static String getRepositoryDefaultPushPath(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryDefaultPushPath"));
        }
        return repository.getRepositoryConfig().getDefaultPushPath();
    }

    @Nullable
    public static String getConfig(@NotNull Project project, @NotNull VirtualFile root, @NotNull String section, @Nullable String configName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getConfig"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/util/HgUtil", "getConfig"));
        }
        if (section == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "section", "org/zmlx/hg4idea/util/HgUtil", "getConfig"));
        }
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        return hgRepository.getRepositoryConfig().getNamedConfig(section, configName);
    }

    @NotNull
    public static Collection<String> getRepositoryPaths(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryPaths"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryPaths"));
        }
        HgRepository hgRepository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        assert (hgRepository != null) : "Repository can't be null for root " + root.getName();
        Collection<String> collection = hgRepository.getRepositoryConfig().getPaths();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getRepositoryPaths"));
        }
        return collection;
    }

    public static boolean isExecutableValid(@Nullable String executable) {
        try {
            if (StringUtil.isEmptyOrSpaces((String)executable)) {
                return false;
            }
            HgCommandResult result = HgUtil.getVersionOutput(executable);
            return result.getExitValue() == 0 && !result.getRawOutput().isEmpty();
        }
        catch (Throwable e) {
            LOG.info("Error during hg executable validation: ", e);
            return false;
        }
    }

    @NotNull
    public static HgCommandResult getVersionOutput(@NotNull String executable) throws ShellCommandException, InterruptedException {
        if (executable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executable", "org/zmlx/hg4idea/util/HgUtil", "getVersionOutput"));
        }
        String hgExecutable = executable.trim();
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(hgExecutable);
        cmdArgs.add("version");
        cmdArgs.add("-q");
        ShellCommand shellCommand = new ShellCommand(cmdArgs, null, CharsetToolkit.getDefaultSystemCharset());
        HgCommandResult hgCommandResult = shellCommand.execute(false);
        if (hgCommandResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getVersionOutput"));
        }
        return hgCommandResult;
    }

    public static List<String> getNamesWithoutHashes(Collection<HgNameWithHashInfo> namesWithHashes) {
        ArrayList<String> names = new ArrayList<String>();
        for (HgNameWithHashInfo hash : namesWithHashes) {
            if (names.contains(hash.getName())) continue;
            names.add(hash.getName());
        }
        Collections.sort(names);
        return names;
    }

    @NotNull
    public static Couple<String> parseUserNameAndEmail(@NotNull String authorString) {
        String userName;
        String email;
        if (authorString == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "authorString", "org/zmlx/hg4idea/util/HgUtil", "parseUserNameAndEmail"));
        }
        int startEmailIndex = authorString.indexOf(60);
        int startDomainIndex = authorString.indexOf(64);
        int endEmailIndex = authorString.indexOf(62);
        if (0 < startEmailIndex && startEmailIndex < startDomainIndex && startDomainIndex < endEmailIndex) {
            email = authorString.substring(startEmailIndex + 1, endEmailIndex);
            userName = authorString.substring(0, startEmailIndex).trim();
        } else if (!authorString.contains(" ") && startDomainIndex > 0) {
            if (startEmailIndex >= 0 && startDomainIndex > startEmailIndex && startDomainIndex < endEmailIndex) {
                userName = authorString.substring(startEmailIndex + 1, startDomainIndex).trim();
                email = authorString.substring(startEmailIndex + 1, endEmailIndex).trim();
            } else {
                userName = authorString.substring(0, startDomainIndex).trim();
                email = authorString;
            }
        } else {
            userName = authorString.trim();
            email = "";
        }
        Couple couple = Couple.of((Object)userName, (Object)email);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "parseUserNameAndEmail"));
        }
        return couple;
    }

    @NotNull
    public static List<String> getTargetNames(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/util/HgUtil", "getTargetNames"));
        }
        List list = ContainerUtil.sorted((Collection)ContainerUtil.map(repository.getRepositoryConfig().getPaths(), (Function)new Function<String, String>(){

            public String fun(String s) {
                return HgUtil.removePasswordIfNeeded(s);
            }
        }));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/util/HgUtil", "getTargetNames"));
        }
        return list;
    }
}

