/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.status.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgUpdater;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.branch.HgBranchPopup;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgStatusWidget
extends EditorBasedWidget
implements StatusBarWidget.MultipleTextValuesPresentation,
StatusBarWidget.Multiframe,
HgUpdater {
    private static final String MAX_STRING = "Hg: Merging default ";
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgProjectSettings myProjectSettings;
    private volatile String myText;
    private volatile String myTooltip;

    public HgStatusWidget(@NotNull HgVcs vcs, @NotNull Project project, @NotNull HgProjectSettings projectSettings) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "<init>"));
        }
        if (projectSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectSettings", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "<init>"));
        }
        super(project);
        this.myText = "";
        this.myTooltip = "";
        this.myVcs = vcs;
        this.myProjectSettings = projectSettings;
    }

    public StatusBarWidget copy() {
        return new HgStatusWidget(this.myVcs, this.getProject(), this.myProjectSettings);
    }

    @NotNull
    public String ID() {
        String string = HgStatusWidget.class.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "ID"));
        }
        return string;
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "getPresentation"));
        }
        return this;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "selectionChanged"));
        }
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "fileOpened"));
        }
        this.update();
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "fileClosed"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "fileClosed"));
        }
        this.update();
    }

    public ListPopup getPopupStep() {
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            return null;
        }
        VirtualFile root = HgUtil.getRootForSelectedFile(project);
        HgRepository repository = (HgRepository)HgUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository != null) {
            return HgBranchPopup.getInstance(project, repository).asListPopup();
        }
        return null;
    }

    public String getSelectedValue() {
        String text = this.myText;
        return StringUtil.isEmpty((String)text) ? "" : "hg: " + text;
    }

    @Deprecated
    @NotNull
    public String getMaxValue() {
        if (MAX_STRING == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/status/ui/HgStatusWidget", "getMaxValue"));
        }
        return MAX_STRING;
    }

    public String getTooltipText() {
        return this.myTooltip;
    }

    public Consumer<MouseEvent> getClickConsumer() {
        return new Consumer<MouseEvent>(){

            public void consume(MouseEvent mouseEvent) {
                HgStatusWidget.this.update();
            }
        };
    }

    @Override
    public void update(Project project, @Nullable VirtualFile root) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                HgStatusWidget.this.update();
            }
        });
    }

    private void update() {
        Project project = this.getProject();
        if (project == null || project.isDisposed()) {
            this.emptyTextAndTooltip();
            return;
        }
        HgRepository repo = HgUtil.getCurrentRepository(project);
        if (repo == null) {
            this.emptyTextAndTooltip();
            return;
        }
        this.myTooltip = HgUtil.getDisplayableBranchOrBookmarkText(repo);
        this.myText = StringUtil.shortenTextWithEllipsis((String)this.myTooltip, (int)MAX_STRING.length(), (int)5);
        if (!this.isDisposed() && this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    public void activate() {
        Project project = this.getProject();
        if (null == project) {
            return;
        }
        MessageBusConnection busConnection = project.getMessageBus().connect();
        busConnection.subscribe(HgVcs.STATUS_TOPIC, (Object)this);
        DvcsUtil.installStatusBarWidget((Project)this.myProject, (StatusBarWidget)this);
    }

    public void deactivate() {
        if (this.isDisposed()) {
            return;
        }
        DvcsUtil.removeStatusBarWidget((Project)this.myProject, (StatusBarWidget)this);
    }

    public void dispose() {
        this.deactivate();
        super.dispose();
    }

    private void emptyTextAndTooltip() {
        this.myText = "";
        this.myTooltip = "";
    }
}

