/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.push;

import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.push.OutgoingCommitsProvider;
import com.intellij.dvcs.push.PushSettings;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTargetPanel;
import com.intellij.dvcs.push.Pusher;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgProjectSettings;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.push.HgOutgoingCommitsProvider;
import org.zmlx.hg4idea.push.HgPushOptionsPanel;
import org.zmlx.hg4idea.push.HgPushSource;
import org.zmlx.hg4idea.push.HgPushTargetPanel;
import org.zmlx.hg4idea.push.HgPusher;
import org.zmlx.hg4idea.push.HgTarget;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.util.HgUtil;

public class HgPushSupport
extends PushSupport<HgRepository, HgPushSource, HgTarget> {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgVcs myVcs;
    @NotNull
    private final HgProjectSettings mySettings;
    @NotNull
    private final PushSettings myCommonPushSettings;

    public HgPushSupport(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/zmlx/hg4idea/push/HgPushSupport", "<init>"));
        }
        this.myProject = project;
        this.myVcs = (HgVcs)((Object)ObjectUtils.assertNotNull((Object)((Object)HgVcs.getInstance(this.myProject))));
        this.mySettings = this.myVcs.getProjectSettings();
        this.myCommonPushSettings = (PushSettings)ServiceManager.getService((Project)project, PushSettings.class);
    }

    @NotNull
    public AbstractVcs getVcs() {
        HgVcs hgVcs = this.myVcs;
        if (hgVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/push/HgPushSupport", "getVcs"));
        }
        return hgVcs;
    }

    @NotNull
    public Pusher<HgRepository, HgPushSource, HgTarget> getPusher() {
        HgPusher hgPusher = new HgPusher();
        if (hgPusher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/push/HgPushSupport", "getPusher"));
        }
        return hgPusher;
    }

    @NotNull
    public OutgoingCommitsProvider<HgRepository, HgPushSource, HgTarget> getOutgoingCommitsProvider() {
        HgOutgoingCommitsProvider hgOutgoingCommitsProvider = new HgOutgoingCommitsProvider();
        if (hgOutgoingCommitsProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/push/HgPushSupport", "getOutgoingCommitsProvider"));
        }
        return hgOutgoingCommitsProvider;
    }

    @Nullable
    public HgTarget getDefaultTarget(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/push/HgPushSupport", "getDefaultTarget"));
        }
        String defaultPushPath = repository.getRepositoryConfig().getDefaultPushPath();
        return defaultPushPath == null ? null : new HgTarget(defaultPushPath, repository.getCurrentBranchName());
    }

    @NotNull
    public HgPushSource getSource(@NotNull HgRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/push/HgPushSupport", "getSource"));
        }
        String localBranch = repository.getCurrentBranchName();
        HgPushSource hgPushSource = new HgPushSource(localBranch);
        if (hgPushSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/push/HgPushSupport", "getSource"));
        }
        return hgPushSource;
    }

    @NotNull
    public RepositoryManager<HgRepository> getRepositoryManager() {
        HgRepositoryManager hgRepositoryManager = HgUtil.getRepositoryManager(this.myProject);
        if (hgRepositoryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/push/HgPushSupport", "getRepositoryManager"));
        }
        return hgRepositoryManager;
    }

    @Nullable
    public VcsPushOptionsPanel createOptionsPanel() {
        return new HgPushOptionsPanel();
    }

    @NotNull
    public PushTargetPanel<HgTarget> createTargetPanel(@NotNull HgRepository repository, @Nullable HgTarget defaultTarget) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "org/zmlx/hg4idea/push/HgPushSupport", "createTargetPanel"));
        }
        HgPushTargetPanel hgPushTargetPanel = new HgPushTargetPanel(repository, defaultTarget);
        if (hgPushTargetPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/push/HgPushSupport", "createTargetPanel"));
        }
        return hgPushTargetPanel;
    }

    public boolean isForcePushAllowed(@NotNull HgRepository repo, @NotNull HgTarget target) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "org/zmlx/hg4idea/push/HgPushSupport", "isForcePushAllowed"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/zmlx/hg4idea/push/HgPushSupport", "isForcePushAllowed"));
        }
        return true;
    }

    public boolean isForcePushEnabled() {
        return true;
    }

    public boolean shouldRequestIncomingChangesForNotCheckedRepositories() {
        return this.mySettings.getSyncSetting() == DvcsSyncSettings.Value.SYNC;
    }

    public void saveSilentForcePushTarget(@NotNull HgTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/zmlx/hg4idea/push/HgPushSupport", "saveSilentForcePushTarget"));
        }
        this.myCommonPushSettings.addForcePushTarget(target.getPresentation(), target.getBranchName());
    }

    public boolean isSilentForcePushAllowed(@NotNull HgTarget target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/zmlx/hg4idea/push/HgPushSupport", "isSilentForcePushAllowed"));
        }
        return this.myCommonPushSettings.containsForcePushTarget(target.getPresentation(), target.getBranchName());
    }
}

