/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.google.common.base.Objects;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.command.HgCatCommand;
import org.zmlx.hg4idea.util.HgUtil;

public class HgContentRevision
implements ContentRevision {
    private final Project myProject;
    @NotNull
    private final HgFile myHgFile;
    @NotNull
    private final HgRevisionNumber myRevisionNumber;
    private FilePath filePath;
    private String content;

    public HgContentRevision(Project project, @NotNull HgFile hgFile, @NotNull HgRevisionNumber revisionNumber) {
        if (hgFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFile", "org/zmlx/hg4idea/HgContentRevision", "<init>"));
        }
        if (revisionNumber == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionNumber", "org/zmlx/hg4idea/HgContentRevision", "<init>"));
        }
        this.myProject = project;
        this.myHgFile = hgFile;
        this.myRevisionNumber = revisionNumber;
    }

    @Nullable
    public String getContent() throws VcsException {
        if (StringUtil.isEmptyOrSpaces((String)this.content)) {
            if (this.myRevisionNumber.isWorkingVersion()) {
                this.content = VcsUtil.getFileContent((String)this.myHgFile.getFile().getPath());
            } else {
                HgFile fileToCat = HgUtil.getFileNameInTargetRevision(this.myProject, this.myRevisionNumber, this.myHgFile);
                this.content = new HgCatCommand(this.myProject).execute(fileToCat, this.myRevisionNumber, this.getFile().getCharset());
            }
        }
        return this.content;
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        String content = this.getContent();
        if (content == null) {
            return null;
        }
        try {
            VirtualFile vf = VcsUtil.getVirtualFile((File)this.myHgFile.getFile());
            if (vf == null) {
                return null;
            }
            return content.getBytes(vf.getCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new VcsException("Couldn't retrieve file content due to a UnsupportedEncodingException", (Throwable)e);
        }
    }

    @NotNull
    public FilePath getFile() {
        if (this.filePath == null) {
            this.filePath = this.myHgFile.toFilePath();
        }
        FilePath filePath = this.filePath;
        if (filePath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgContentRevision", "getFile"));
        }
        return filePath;
    }

    @NotNull
    public HgRevisionNumber getRevisionNumber() {
        HgRevisionNumber hgRevisionNumber = this.myRevisionNumber;
        if (hgRevisionNumber == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/HgContentRevision", "getRevisionNumber"));
        }
        return hgRevisionNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HgContentRevision revision = (HgContentRevision)o;
        if (!this.myHgFile.equals(revision.myHgFile)) {
            return false;
        }
        return this.myRevisionNumber.equals(revision.myRevisionNumber);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myHgFile, this.myRevisionNumber});
    }
}

