/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.serialize.kryo;

import com.esotericsoftware.kryo.io.Output;
import java.io.Closeable;
import java.io.OutputStream;
import org.gradle.api.Nullable;
import org.gradle.messaging.serialize.AbstractEncoder;
import org.gradle.messaging.serialize.FlushableEncoder;

public class KryoBackedEncoder
extends AbstractEncoder
implements FlushableEncoder,
Closeable {
    private final Output output;

    public KryoBackedEncoder(OutputStream outputStream) {
        this(outputStream, 4096);
    }

    public KryoBackedEncoder(OutputStream outputStream, int bufferSize) {
        this.output = new Output(outputStream, bufferSize);
    }

    public void writeByte(byte value) {
        this.output.writeByte(value);
    }

    public void writeBytes(byte[] bytes, int offset, int count) {
        this.output.writeBytes(bytes, offset, count);
    }

    public void writeLong(long value) {
        this.output.writeLong(value);
    }

    public void writeSmallLong(long value) {
        this.output.writeLong(value, true);
    }

    public void writeInt(int value) {
        this.output.writeInt(value);
    }

    public void writeSmallInt(int value) {
        this.output.writeInt(value, true);
    }

    public void writeBoolean(boolean value) {
        this.output.writeBoolean(value);
    }

    public void writeString(CharSequence value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot encode a null string.");
        }
        this.output.writeString(value);
    }

    public void writeNullableString(@Nullable CharSequence value) {
        this.output.writeString(value);
    }

    public int getWritePosition() {
        return this.output.total();
    }

    public void flush() {
        this.output.flush();
    }

    public void close() {
        this.output.close();
    }
}

