/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.hub;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.serialize.Decoder;
import org.gradle.messaging.serialize.Encoder;
import org.gradle.messaging.serialize.ObjectReader;
import org.gradle.messaging.serialize.ObjectWriter;
import org.gradle.messaging.serialize.kryo.StatefulSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocationSerializer
implements StatefulSerializer<MethodInvocation> {
    private final ClassLoader classLoader;
    private final StatefulSerializer<Object[]> argsSerializer;

    public MethodInvocationSerializer(ClassLoader classLoader, StatefulSerializer<Object[]> argsSerializer) {
        this.classLoader = classLoader;
        this.argsSerializer = argsSerializer;
    }

    @Override
    public ObjectReader<MethodInvocation> newReader(Decoder decoder) {
        return new MethodInvocationReader(decoder, this.classLoader, this.argsSerializer.newReader(decoder));
    }

    @Override
    public ObjectWriter<MethodInvocation> newWriter(Encoder encoder) {
        return new MethodInvocationWriter(encoder, this.argsSerializer.newWriter(encoder));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInvocationReader
    implements ObjectReader<MethodInvocation> {
        private static final Map<String, Class<?>> PRIMITIVE_TYPES = new HashMap();
        private final Decoder decoder;
        private final ClassLoader classLoader;
        private final ObjectReader<Object[]> argsReader;
        private final Map<Integer, Method> methods = new HashMap<Integer, Method>();

        public MethodInvocationReader(Decoder decoder, ClassLoader classLoader, ObjectReader<Object[]> argsReader) {
            this.decoder = decoder;
            this.classLoader = classLoader;
            this.argsReader = argsReader;
        }

        @Override
        public MethodInvocation read() throws Exception {
            Method method = this.readMethod();
            Object[] args = this.readArguments();
            return new MethodInvocation(method, args);
        }

        private Object[] readArguments() throws Exception {
            return this.argsReader.read();
        }

        private Method readMethod() throws ClassNotFoundException, NoSuchMethodException, IOException {
            int methodId = this.decoder.readSmallInt();
            Method method = this.methods.get(methodId);
            if (method == null) {
                Class<?> declaringClass = this.readType();
                String methodName = this.decoder.readString();
                int paramCount = this.decoder.readSmallInt();
                Class[] paramTypes = new Class[paramCount];
                for (int i = 0; i < paramTypes.length; ++i) {
                    paramTypes[i] = this.readType();
                }
                method = declaringClass.getDeclaredMethod(methodName, paramTypes);
                this.methods.put(methodId, method);
            }
            return method;
        }

        private Class<?> readType() throws ClassNotFoundException, IOException {
            String typeName = this.decoder.readString();
            Class<?> paramType = PRIMITIVE_TYPES.get(typeName);
            if (paramType == null) {
                paramType = this.classLoader.loadClass(typeName);
            }
            return paramType;
        }

        static {
            PRIMITIVE_TYPES.put(Integer.TYPE.getName(), Integer.TYPE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInvocationWriter
    implements ObjectWriter<MethodInvocation> {
        private final Encoder encoder;
        private final ObjectWriter<Object[]> argsWriter;
        private final Map<Method, Integer> methods = new HashMap<Method, Integer>();

        public MethodInvocationWriter(Encoder encoder, ObjectWriter<Object[]> argsWriter) {
            this.encoder = encoder;
            this.argsWriter = argsWriter;
        }

        @Override
        public void write(MethodInvocation value) throws Exception {
            if (value.getArguments().length != value.getMethod().getParameterTypes().length) {
                throw new IllegalArgumentException(String.format("Mismatched number of parameters to method %s.", value.getMethod()));
            }
            this.writeMethod(value.getMethod());
            this.writeArguments(value);
        }

        private void writeArguments(MethodInvocation value) throws Exception {
            this.argsWriter.write(value.getArguments());
        }

        private void writeMethod(Method method) throws IOException {
            Integer methodId = this.methods.get(method);
            if (methodId == null) {
                methodId = this.methods.size();
                this.methods.put(method, methodId);
                this.encoder.writeSmallInt(methodId);
                this.encoder.writeString(method.getDeclaringClass().getName());
                this.encoder.writeString(method.getName());
                this.encoder.writeSmallInt(method.getParameterTypes().length);
                for (Class<?> paramType : method.getParameterTypes()) {
                    this.encoder.writeString(paramType.getName());
                }
            } else {
                this.encoder.writeSmallInt(methodId);
            }
        }
    }
}

