/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.inject.AbstractLanguageInjectionSupport;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemporaryPlacesRegistry {
    private final Project myProject;
    private final List<TempPlace> myTempPlaces = ContainerUtil.createLockFreeCopyOnWriteList();
    private final PsiModificationTracker myModificationTracker;
    private volatile long myPsiModificationCounter;
    private final LanguageInjectionSupport myInjectorSupport = new AbstractLanguageInjectionSupport(){

        @Override
        @NotNull
        public String getId() {
            if ("temp" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/TemporaryPlacesRegistry$1", "getId"));
            }
            return "temp";
        }

        @Override
        public boolean isApplicableTo(PsiLanguageInjectionHost host) {
            return true;
        }

        @Override
        @NotNull
        public Class[] getPatternClasses() {
            if (ArrayUtil.EMPTY_CLASS_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/intelliLang/inject/TemporaryPlacesRegistry$1", "getPatternClasses"));
            }
            return ArrayUtil.EMPTY_CLASS_ARRAY;
        }

        @Override
        public boolean addInjectionInPlace(Language language, PsiLanguageInjectionHost host) {
            TemporaryPlacesRegistry.this.addHostWithUndo(host, InjectedLanguage.create(language.getID()));
            return true;
        }

        @Override
        public boolean removeInjectionInPlace(PsiLanguageInjectionHost psiElement) {
            return TemporaryPlacesRegistry.this.removeHostWithUndo(TemporaryPlacesRegistry.this.myProject, psiElement);
        }
    };

    public static TemporaryPlacesRegistry getInstance(Project project) {
        return (TemporaryPlacesRegistry)ServiceManager.getService((Project)project, TemporaryPlacesRegistry.class);
    }

    public TemporaryPlacesRegistry(Project project, PsiModificationTracker modificationTracker) {
        this.myProject = project;
        this.myModificationTracker = modificationTracker;
    }

    private List<TempPlace> getInjectionPlacesSafe() {
        long modificationCount = this.myModificationTracker.getModificationCount();
        if (this.myPsiModificationCounter == modificationCount) {
            return this.myTempPlaces;
        }
        this.myPsiModificationCounter = modificationCount;
        List placesToRemove = ContainerUtil.findAll(this.myTempPlaces, (Condition)new Condition<TempPlace>(){

            public boolean value(TempPlace place) {
                PsiLanguageInjectionHost element = (PsiLanguageInjectionHost)place.elementPointer.getElement();
                if (element == null) {
                    return true;
                }
                element.putUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, (Object)place.language);
                return false;
            }
        });
        if (!placesToRemove.isEmpty()) {
            this.myTempPlaces.removeAll(placesToRemove);
        }
        return this.myTempPlaces;
    }

    private void addInjectionPlace(TempPlace place) {
        PsiLanguageInjectionHost element = (PsiLanguageInjectionHost)place.elementPointer.getElement();
        if (element == null) {
            return;
        }
        List<TempPlace> injectionPoints = this.getInjectionPlacesSafe();
        element.putUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE, (Object)place.language);
        for (TempPlace tempPlace : injectionPoints) {
            if (tempPlace.elementPointer.getElement() != element) continue;
            injectionPoints.remove(tempPlace);
            break;
        }
        if (place.language != null) {
            injectionPoints.add(place);
        }
    }

    public boolean removeHostWithUndo(Project project, PsiLanguageInjectionHost host) {
        InjectedLanguage prevLanguage = (InjectedLanguage)host.getUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE);
        if (prevLanguage == null) {
            return false;
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myProject);
        SmartPsiElementPointer pointer = manager.createSmartPsiElementPointer((PsiElement)host);
        TempPlace place = new TempPlace(prevLanguage, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        TempPlace nextPlace = new TempPlace(null, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        Configuration.replaceInjectionsWithUndo(project, nextPlace, place, Collections.emptyList(), new PairProcessor<TempPlace, TempPlace>(){

            public boolean process(TempPlace add, TempPlace remove) {
                TemporaryPlacesRegistry.this.addInjectionPlace(add);
                return true;
            }
        });
        return true;
    }

    public void addHostWithUndo(PsiLanguageInjectionHost host, InjectedLanguage language) {
        InjectedLanguage prevLanguage = (InjectedLanguage)host.getUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE);
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.myProject);
        SmartPsiElementPointer pointer = manager.createSmartPsiElementPointer((PsiElement)host);
        TempPlace prevPlace = new TempPlace(prevLanguage, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        TempPlace place = new TempPlace(language, (SmartPsiElementPointer<PsiLanguageInjectionHost>)pointer);
        Configuration.replaceInjectionsWithUndo(this.myProject, place, prevPlace, Collections.emptyList(), new PairProcessor<TempPlace, TempPlace>(){

            public boolean process(TempPlace add, TempPlace remove) {
                TemporaryPlacesRegistry.this.addInjectionPlace(add);
                return true;
            }
        });
    }

    public LanguageInjectionSupport getLanguageInjectionSupport() {
        return this.myInjectorSupport;
    }

    @Nullable
    public InjectedLanguage getLanguageFor(@NotNull PsiLanguageInjectionHost host, PsiFile containingFile) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/intellij/plugins/intelliLang/inject/TemporaryPlacesRegistry", "getLanguageFor"));
        }
        PsiLanguageInjectionHost originalHost = (PsiLanguageInjectionHost)CompletionUtilCoreImpl.getOriginalElement((PsiElement)host, (PsiFile)containingFile);
        PsiLanguageInjectionHost injectionHost = originalHost == null ? host : originalHost;
        this.getInjectionPlacesSafe();
        return (InjectedLanguage)injectionHost.getUserData(LanguageInjectionSupport.TEMPORARY_INJECTED_LANGUAGE);
    }

    private static class TempPlace {
        public final InjectedLanguage language;
        public final SmartPsiElementPointer<PsiLanguageInjectionHost> elementPointer;

        public TempPlace(InjectedLanguage language, SmartPsiElementPointer<PsiLanguageInjectionHost> elementPointer) {
            this.language = language;
            this.elementPointer = elementPointer;
        }
    }
}

