/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.io.FileUtil;
import javax.swing.JComponent;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkAdditionalData;
import org.jetbrains.android.sdk.AndroidSdkConfigurableForm;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidSdkConfigurable
implements AdditionalDataConfigurable {
    private final AndroidSdkConfigurableForm myForm;
    private Sdk mySdk;
    private final SdkModel.Listener myListener;
    private final SdkModel mySdkModel;

    public AndroidSdkConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModel", "org/jetbrains/android/sdk/AndroidSdkConfigurable", "<init>"));
        }
        if (sdkModificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkModificator", "org/jetbrains/android/sdk/AndroidSdkConfigurable", "<init>"));
        }
        this.mySdkModel = sdkModel;
        this.myForm = new AndroidSdkConfigurableForm(sdkModel, sdkModificator);
        this.myListener = new SdkModel.Listener(){

            public void sdkAdded(Sdk sdk) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    AndroidSdkConfigurable.this.myForm.addJavaSdk(sdk);
                }
            }

            public void beforeSdkRemove(Sdk sdk) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    AndroidSdkConfigurable.this.myForm.removeJavaSdk(sdk);
                }
            }

            public void sdkChanged(Sdk sdk, String previousName) {
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    AndroidSdkConfigurable.this.myForm.updateJdks(sdk, previousName);
                }
            }

            public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
                if (sdk != null && AndroidSdkUtils.isAndroidSdk(sdk)) {
                    AndroidSdkConfigurable.this.myForm.internalJdkUpdate(sdk);
                }
            }
        };
        this.mySdkModel.addListener(this.myListener);
    }

    public void setSdk(Sdk sdk) {
        this.mySdk = sdk;
    }

    public JComponent createComponent() {
        return this.myForm.getContentPanel();
    }

    public boolean isModified() {
        AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)this.mySdk.getSdkAdditionalData();
        Sdk javaSdk = data != null ? data.getJavaSdk() : null;
        String javaSdkHomePath = javaSdk != null ? javaSdk.getHomePath() : null;
        Sdk selectedSdk = this.myForm.getSelectedSdk();
        String selectedSdkHomePath = selectedSdk != null ? selectedSdk.getHomePath() : null;
        return !FileUtil.pathsEqual((String)javaSdkHomePath, (String)selectedSdkHomePath);
    }

    public void apply() throws ConfigurationException {
        Sdk javaSdk = this.myForm.getSelectedSdk();
        AndroidSdkAdditionalData newData = new AndroidSdkAdditionalData(this.mySdk, javaSdk);
        newData.setBuildTarget(this.myForm.getSelectedBuildTarget());
        final SdkModificator modificator = this.mySdk.getSdkModificator();
        modificator.setVersionString(javaSdk != null ? javaSdk.getVersionString() : null);
        modificator.setSdkAdditionalData((SdkAdditionalData)newData);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                modificator.commitChanges();
            }
        });
    }

    public void reset() {
        if (this.mySdk == null) {
            return;
        }
        SdkAdditionalData data = this.mySdk.getSdkAdditionalData();
        if (!(data instanceof AndroidSdkAdditionalData)) {
            return;
        }
        AndroidSdkAdditionalData androidData = (AndroidSdkAdditionalData)data;
        AndroidPlatform platform = androidData.getAndroidPlatform();
        this.myForm.init(androidData.getJavaSdk(), this.mySdk, platform != null ? androidData.getBuildTarget(platform.getSdkData()) : null);
    }

    public void disposeUIResources() {
        this.mySdkModel.removeListener(this.myListener);
    }
}

