/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.sdk.Jdks;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.ValidatableSdkAdditionalData;
import org.jdom.Element;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkAdditionalData
implements ValidatableSdkAdditionalData {
    @NonNls
    private static final String JDK = "jdk";
    @NonNls
    private static final String BUILD_TARGET = "sdk";
    private String myJavaSdkName;
    private final Sdk myAndroidSdk;
    private Sdk myJavaSdk;
    private String myBuildTarget;
    private AndroidPlatform myAndroidPlatform;

    public AndroidSdkAdditionalData(@NotNull Sdk androidSdk, @Nullable Sdk javaSdk) {
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdk", "org/jetbrains/android/sdk/AndroidSdkAdditionalData", "<init>"));
        }
        this.myAndroidPlatform = null;
        this.myJavaSdk = javaSdk;
        this.myAndroidSdk = androidSdk;
    }

    public AndroidSdkAdditionalData(@NotNull Sdk androidSdk, @NotNull Element element) {
        if (androidSdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidSdk", "org/jetbrains/android/sdk/AndroidSdkAdditionalData", "<init>"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/android/sdk/AndroidSdkAdditionalData", "<init>"));
        }
        this.myAndroidPlatform = null;
        this.myAndroidSdk = androidSdk;
        this.myJavaSdkName = element.getAttributeValue(JDK);
        this.myBuildTarget = element.getAttributeValue(BUILD_TARGET);
    }

    public AndroidSdkAdditionalData(Sdk androidSdk) {
        this.myAndroidPlatform = null;
        this.myAndroidSdk = androidSdk;
    }

    public void checkValid(SdkModel sdkModel) throws ConfigurationException {
        if (this.getJavaSdk() == null) {
            throw new ConfigurationException(AndroidBundle.message("android.sdk.configure.jdk.error", new Object[0]));
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AndroidSdkAdditionalData data = (AndroidSdkAdditionalData)super.clone();
        Sdk jdk = this.getJavaSdk();
        assert (jdk != null);
        data.setJavaSdk(jdk);
        data.myBuildTarget = this.myBuildTarget;
        return data;
    }

    @Nullable
    public Sdk getJavaSdk() {
        ProjectJdkTable jdkTable = ProjectJdkTable.getInstance();
        if (this.myJavaSdk == null) {
            if (this.myJavaSdkName != null) {
                this.myJavaSdk = jdkTable.findJdk(this.myJavaSdkName);
                this.myJavaSdkName = null;
            } else {
                for (Sdk jdk : jdkTable.getAllJdks()) {
                    if (!Jdks.isApplicableJdk(jdk)) continue;
                    this.myJavaSdk = jdk;
                    break;
                }
            }
        }
        return this.myJavaSdk;
    }

    public void setJavaSdk(Sdk javaSdk) {
        this.myJavaSdk = javaSdk;
    }

    public void setBuildTargetHashString(String targetHashString) {
        this.myBuildTarget = targetHashString;
        this.myAndroidPlatform = null;
    }

    public void setBuildTarget(IAndroidTarget target) {
        this.myBuildTarget = target != null ? target.hashString() : null;
        this.myAndroidPlatform = null;
    }

    public void save(Element element) {
        Sdk sdk = this.getJavaSdk();
        if (sdk != null) {
            element.setAttribute(JDK, sdk.getName());
        }
        if (this.myBuildTarget != null) {
            element.setAttribute(BUILD_TARGET, this.myBuildTarget);
        }
    }

    @Nullable
    public IAndroidTarget getBuildTarget(@NotNull AndroidSdkData sdkData) {
        if (sdkData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkData", "org/jetbrains/android/sdk/AndroidSdkAdditionalData", "getBuildTarget"));
        }
        return this.myBuildTarget != null ? sdkData.findTargetByHashString(this.myBuildTarget) : null;
    }

    @Nullable
    public String getBuildTargetHashString() {
        return this.myBuildTarget;
    }

    @Nullable
    public AndroidPlatform getAndroidPlatform() {
        if (this.myAndroidPlatform == null) {
            this.myAndroidPlatform = AndroidPlatform.parse(this.myAndroidSdk);
        }
        return this.myAndroidPlatform;
    }
}

