/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.run;

import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.Variant;
import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.gradle.IdeaAndroidProject;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.run.AndroidApplicationLauncher;
import org.jetbrains.android.run.AndroidRunningState;
import org.jetbrains.android.run.DeviceStateAtLaunch;
import org.jetbrains.android.run.EmulatorTargetChooser;
import org.jetbrains.android.run.ManualTargetChooser;
import org.jetbrains.android.run.TargetChooser;
import org.jetbrains.android.run.TargetSelectionMode;
import org.jetbrains.android.run.UsbDeviceTargetChooser;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<JavaRunConfigurationModule> {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.run.AndroidRunConfigurationBase");
    private static final String GRADLE_SYNC_FAILED_ERR_MSG = "Gradle project sync failed. Please fix your project and try again.";
    private static Map<String, DeviceStateAtLaunch> ourLastUsedDevices = ContainerUtil.newConcurrentMap();
    public String TARGET_SELECTION_MODE = TargetSelectionMode.EMULATOR.name();
    public boolean USE_LAST_SELECTED_DEVICE = false;
    public String PREFERRED_AVD = "";
    public boolean USE_COMMAND_LINE = true;
    public String COMMAND_LINE = "";
    public boolean WIPE_USER_DATA = false;
    public boolean DISABLE_BOOT_ANIMATION = false;
    public String NETWORK_SPEED = "full";
    public String NETWORK_LATENCY = "none";
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = true;
    public boolean FILTER_LOGCAT_AUTOMATICALLY = true;

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory) {
        super((RunConfigurationModule)new JavaRunConfigurationModule(project, false), factory);
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        Pair<Boolean, String> result;
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        configurationModule.checkForWarning();
        Module module = configurationModule.getModule();
        if (module == null) {
            return;
        }
        Project project = module.getProject();
        if (Projects.isGradleProjectWithoutModel(project)) {
            throw new RuntimeConfigurationException(GRADLE_SYNC_FAILED_ERR_MSG);
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            throw new RuntimeConfigurationError(AndroidBundle.message("android.no.facet.error", new Object[0]));
        }
        if (facet.isLibraryProject() && !((Boolean)(result = this.supportsRunningLibraryProjects(facet)).getFirst()).booleanValue()) {
            throw new RuntimeConfigurationError((String)result.getSecond());
        }
        if (((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform() == null) {
            throw new RuntimeConfigurationError(AndroidBundle.message("select.platform.error", new Object[0]));
        }
        if (facet.getManifest() == null) {
            throw new RuntimeConfigurationError(AndroidBundle.message("android.manifest.not.found.error", new Object[0]));
        }
        if (this.PREFERRED_AVD.length() > 0) {
            AvdManager avdManager = facet.getAvdManagerSilently();
            if (avdManager == null) {
                throw new RuntimeConfigurationError(AndroidBundle.message("avd.cannot.be.loaded.error", new Object[0]));
            }
            AvdInfo avdInfo = avdManager.getAvd(this.PREFERRED_AVD, false);
            if (avdInfo == null) {
                throw new RuntimeConfigurationError(AndroidBundle.message("avd.not.found.error", this.PREFERRED_AVD));
            }
            if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
                String message = avdInfo.getErrorMessage();
                message = AndroidBundle.message("avd.not.valid.error", this.PREFERRED_AVD) + (message != null ? ": " + message : "") + ". Try to repair it through AVD manager";
                throw new RuntimeConfigurationError(message);
            }
        }
        this.checkConfiguration(facet);
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet var1);

    protected abstract void checkConfiguration(@NotNull AndroidFacet var1) throws RuntimeConfigurationException;

    public Collection<Module> getValidModules() {
        Module[] modules;
        ArrayList<Module> result = new ArrayList<Module>();
        for (Module module : modules = ModuleManager.getInstance((Project)this.getProject()).getModules()) {
            if (AndroidFacet.getInstance(module) == null) continue;
            result.add(module);
        }
        return result;
    }

    @NotNull
    public TargetSelectionMode getTargetSelectionMode() {
        TargetSelectionMode targetSelectionMode;
        try {
            targetSelectionMode = TargetSelectionMode.valueOf(this.TARGET_SELECTION_MODE);
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            TargetSelectionMode targetSelectionMode2 = TargetSelectionMode.EMULATOR;
            if (targetSelectionMode2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfigurationBase", "getTargetSelectionMode"));
            }
            return targetSelectionMode2;
        }
        if (targetSelectionMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/run/AndroidRunConfigurationBase", "getTargetSelectionMode"));
        }
        return targetSelectionMode;
    }

    public void setTargetSelectionMode(@NotNull TargetSelectionMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/run/AndroidRunConfigurationBase", "setTargetSelectionMode"));
        }
        this.TARGET_SELECTION_MODE = mode.name();
    }

    public void setDevicesUsedInLaunch(@NotNull Set<IDevice> usedDevices, @NotNull Set<IDevice> availableDevices) {
        if (usedDevices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usedDevices", "org/jetbrains/android/run/AndroidRunConfigurationBase", "setDevicesUsedInLaunch"));
        }
        if (availableDevices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "availableDevices", "org/jetbrains/android/run/AndroidRunConfigurationBase", "setDevicesUsedInLaunch"));
        }
        ourLastUsedDevices.put(this.getName(), new DeviceStateAtLaunch(usedDevices, availableDevices));
    }

    @Nullable
    public DeviceStateAtLaunch getDevicesUsedInLastLaunch() {
        return ourLastUsedDevices.get(this.getName());
    }

    public AndroidRunningState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Variant variant;
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/android/run/AndroidRunConfigurationBase", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/android/run/AndroidRunConfigurationBase", "getState"));
        }
        Module module = ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
        if (module == null) {
            throw new ExecutionException("Module is not found");
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            throw new ExecutionException(AndroidBundle.message("no.facet.error", module.getName()));
        }
        Project project = env.getProject();
        if (Projects.isGradleProjectWithoutModel(project)) {
            throw new ExecutionException(GRADLE_SYNC_FAILED_ERR_MSG);
        }
        IdeaAndroidProject ideaAndroidProject = facet.getIdeaAndroidProject();
        if (ideaAndroidProject != null && !(variant = ideaAndroidProject.getSelectedVariant()).getMainArtifact().isSigned()) {
            AndroidArtifactOutput output = GradleUtil.getOutput(variant.getMainArtifact());
            String message = AndroidBundle.message("run.error.apk.not.signed", output.getMainOutputFile().getOutputFile().getName());
            Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
            return null;
        }
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
        AndroidPlatform platform = configuration.getAndroidPlatform();
        if (platform == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("specify.platform.error", new Object[0]), (String)CommonBundle.getErrorTitle());
            ModulesConfigurator.showDialog((Project)project, (String)module.getName(), (String)ClasspathEditor.NAME);
            return null;
        }
        boolean debug = DefaultDebugExecutor.EXECUTOR_ID.equals(executor.getId());
        boolean nonDebuggableOnDevice = false;
        if (debug) {
            Boolean isDebuggable = AndroidModuleInfo.get(facet).isDebuggable();
            boolean bl = nonDebuggableOnDevice = isDebuggable != null && isDebuggable == false;
            if (!AndroidSdkUtils.activateDdmsIfNecessary(facet.getModule().getProject())) {
                return null;
            }
        }
        if (AndroidSdkUtils.getDebugBridge(this.getProject()) == null) {
            return null;
        }
        TargetChooser targetChooser = null;
        switch (this.getTargetSelectionMode()) {
            case SHOW_DIALOG: {
                targetChooser = new ManualTargetChooser();
                break;
            }
            case EMULATOR: {
                targetChooser = new EmulatorTargetChooser(this.PREFERRED_AVD.length() > 0 ? this.PREFERRED_AVD : null);
                break;
            }
            case USB_DEVICE: {
                targetChooser = new UsbDeviceTargetChooser();
                break;
            }
            default: {
                assert (false) : "Unknown target selection mode " + this.TARGET_SELECTION_MODE;
                break;
            }
        }
        AndroidApplicationLauncher applicationLauncher = this.getApplicationLauncher(facet);
        if (applicationLauncher != null) {
            boolean supportMultipleDevices = this.supportMultipleDevices() && executor.getId().equals(DefaultRunExecutor.EXECUTOR_ID);
            return new AndroidRunningState(env, facet, targetChooser, this.computeCommandLine(), applicationLauncher, supportMultipleDevices, this.CLEAR_LOGCAT, this, nonDebuggableOnDevice);
        }
        return null;
    }

    @Nullable
    protected static Pair<File, String> getCopyOfCompilerManifestFile(@NotNull AndroidFacet facet, @Nullable ProcessHandler processHandler) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/run/AndroidRunConfigurationBase", "getCopyOfCompilerManifestFile"));
        }
        VirtualFile manifestFile = AndroidRootUtil.getCustomManifestFileForCompiler(facet);
        if (manifestFile == null) {
            return null;
        }
        File tmpDir = null;
        try {
            tmpDir = FileUtil.createTempDirectory((String)"android_manifest_file_for_execution", (String)"tmp");
            File manifestCopy = new File(tmpDir, manifestFile.getName());
            FileUtil.copy((File)new File(manifestFile.getPath()), (File)manifestCopy);
            return Pair.create((Object)manifestCopy, (Object)PathUtil.getLocalPath((VirtualFile)manifestFile));
        }
        catch (IOException e) {
            if (processHandler != null) {
                processHandler.notifyTextAvailable("I/O error: " + e.getMessage(), ProcessOutputTypes.STDERR);
            }
            LOG.info((Throwable)e);
            if (tmpDir != null) {
                FileUtil.delete((File)tmpDir);
            }
            return null;
        }
    }

    private String computeCommandLine() {
        int last;
        StringBuilder result = new StringBuilder();
        result.append("-netspeed ").append(this.NETWORK_SPEED).append(' ');
        result.append("-netdelay ").append(this.NETWORK_LATENCY).append(' ');
        if (this.WIPE_USER_DATA) {
            result.append("-wipe-data ");
        }
        if (this.DISABLE_BOOT_ANIMATION) {
            result.append("-no-boot-anim ");
        }
        if (this.USE_COMMAND_LINE) {
            result.append(this.COMMAND_LINE);
        }
        if (result.charAt(last = result.length() - 1) == ' ') {
            result.deleteCharAt(last);
        }
        return result.toString();
    }

    @NotNull
    protected abstract ConsoleView attachConsole(AndroidRunningState var1, Executor var2) throws ExecutionException;

    @Nullable
    protected abstract AndroidApplicationLauncher getApplicationLauncher(AndroidFacet var1);

    protected abstract boolean supportMultipleDevices();

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.readModule(element);
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.writeModule(element);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
    }
}

