/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemResourceManager
extends ResourceManager {
    private final AndroidPlatform myPlatform;
    private final boolean myPublicOnly;

    public SystemResourceManager(@NotNull Project project, @NotNull AndroidPlatform androidPlatform, boolean publicOnly) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/resourceManagers/SystemResourceManager", "<init>"));
        }
        if (androidPlatform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidPlatform", "org/jetbrains/android/resourceManagers/SystemResourceManager", "<init>"));
        }
        super(project);
        this.myPlatform = androidPlatform;
        this.myPublicOnly = publicOnly;
    }

    @Override
    protected boolean isResourcePublic(@NotNull String type, @NotNull String name) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/android/resourceManagers/SystemResourceManager", "isResourcePublic"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/resourceManagers/SystemResourceManager", "isResourcePublic"));
        }
        return !this.myPublicOnly || this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).isResourcePublic(type, name);
    }

    @Override
    @NotNull
    public VirtualFile[] getAllResourceDirs() {
        VirtualFile[] virtualFileArray;
        VirtualFile resDir = this.getResourceDir();
        if (resDir != null) {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = resDir;
        } else {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/SystemResourceManager", "getAllResourceDirs"));
        }
        return virtualFileArray;
    }

    @Nullable
    private VirtualFile getResourceDir() {
        String resPath = this.myPlatform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        return LocalFileSystem.getInstance().findFileByPath(resPath);
    }

    @Override
    public boolean isResourceDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "org/jetbrains/android/resourceManagers/SystemResourceManager", "isResourceDir"));
        }
        return dir.equals(this.getResourceDir());
    }

    @Override
    @NotNull
    public List<VirtualFile> getResourceDirs() {
        String resPath = this.myPlatform.getTarget().getPath(11);
        resPath = FileUtil.toSystemIndependentName((String)resPath);
        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(resPath);
        List<Object> list = dir != null ? Collections.singletonList(dir) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/resourceManagers/SystemResourceManager", "getResourceDirs"));
        }
        return list;
    }

    @Nullable
    public static SystemResourceManager getInstance(@NotNull ConvertContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/resourceManagers/SystemResourceManager", "getInstance"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(context);
        return facet != null ? facet.getSystemResourceManager() : null;
    }

    @Override
    @Nullable
    public synchronized AttributeDefinitions getAttributeDefinitions() {
        return this.myPlatform.getSdkData().getTargetData(this.myPlatform.getTarget()).getAttrDefs(this.myProject);
    }
}

