/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.newProject;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFrameworkDetector;
import org.jetbrains.android.importDependencies.ImportDependenciesUtil;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.importWizard.EclipseNatureImporter;

public class AndroidEclipseNatureImporter
extends EclipseNatureImporter {
    private static final Set<String> ADT_INTERNAL_LIBS = new HashSet(Arrays.asList("com.android.ide.eclipse.adt.ANDROID_FRAMEWORK", "com.android.ide.eclipse.adt.LIBRARIES"));

    @NotNull
    public String getNatureName() {
        if ("com.android.ide.eclipse.adt.AndroidNature" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/newProject/AndroidEclipseNatureImporter", "getNatureName"));
        }
        return "com.android.ide.eclipse.adt.AndroidNature";
    }

    public Set<String> getProvidedCons() {
        return ADT_INTERNAL_LIBS;
    }

    public void doImport(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/newProject/AndroidEclipseNatureImporter", "doImport"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/android/newProject/AndroidEclipseNatureImporter", "doImport"));
        }
        for (Module module : modules) {
            VirtualFile contentRoot = AndroidEclipseNatureImporter.chooseMainContentRoot(module);
            if (contentRoot == null) {
                AndroidUtils.reportImportErrorToEventLog("Cannot find content root containing AndroidManifest.xml file", module.getName(), project);
                continue;
            }
            AndroidFacet facet = AndroidUtils.addAndroidFacetInWriteAction(module, contentRoot, false);
            final ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            AndroidFrameworkDetector.doImportSdkAndFacetConfiguration(facet, modifiableModel);
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    modifiableModel.commit();
                }
            });
        }
        ImportDependenciesUtil.doImportDependencies(project, modules, true);
    }

    @Nullable
    private static VirtualFile chooseMainContentRoot(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/newProject/AndroidEclipseNatureImporter", "chooseMainContentRoot"));
        }
        VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (roots.length == 0) {
            return null;
        }
        if (roots.length == 1) {
            return roots[0];
        }
        for (VirtualFile root : roots) {
            if (root.findChild("AndroidManifest.xml") == null) continue;
            return root;
        }
        return null;
    }
}

