/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.logcat;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogConsoleListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import icons.AndroidIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.logcat.AndroidConfiguredLogFilters;
import org.jetbrains.android.logcat.AndroidLogFilterModel;
import org.jetbrains.android.logcat.AndroidLogcatFiltersPreferences;
import org.jetbrains.android.logcat.AndroidLogcatUtil;
import org.jetbrains.android.logcat.AndroidLoggingReader;
import org.jetbrains.android.logcat.ConfiguredFilter;
import org.jetbrains.android.logcat.EditLogFilterDialog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidLogcatView
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.logcat.AndroidLogcatView");
    public static final Key<AndroidLogcatView> ANDROID_LOGCAT_VIEW_KEY = Key.create((String)"ANDROID_LOGCAT_VIEW_KEY");
    public static final String NO_FILTERS = AndroidBundle.message("android.logcat.filters.none", new Object[0]);
    public static final String EDIT_FILTER_CONFIGURATION = AndroidBundle.message("android.logcat.filters.edit", new Object[0]);
    @NonNls
    private static final String FILTER_LOGCAT_WHEN_SELECTION_CHANGES = "android.logcat.filter.apply.if.client.selection.changes";
    private final Project myProject;
    private final DeviceContext myDeviceContext;
    private JPanel myPanel;
    private DefaultComboBoxModel myFilterComboBoxModel;
    private String myCurrentFilterName;
    private volatile IDevice myDevice;
    private final Object myLock;
    private final LogConsoleBase myLogConsole;
    private final AndroidLogFilterModel myLogFilterModel;
    private volatile Reader myCurrentReader;
    private volatile Writer myCurrentWriter;
    private final IDevice myPreselectedDevice;

    private void updateInUIThread() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AndroidLogcatView.this.myProject.isDisposed()) {
                    return;
                }
                AndroidLogcatView.this.updateLogConsole();
            }
        });
    }

    Project getProject() {
        return this.myProject;
    }

    @NotNull
    public LogConsoleBase getLogConsole() {
        LogConsoleBase logConsoleBase = this.myLogConsole;
        if (logConsoleBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/AndroidLogcatView", "getLogConsole"));
        }
        return logConsoleBase;
    }

    public AndroidLogcatView(@NotNull Project project, @NotNull IDevice preselectedDevice) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/logcat/AndroidLogcatView", "<init>"));
        }
        if (preselectedDevice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectedDevice", "org/jetbrains/android/logcat/AndroidLogcatView", "<init>"));
        }
        this(project, preselectedDevice, null);
    }

    public AndroidLogcatView(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/logcat/AndroidLogcatView", "<init>"));
        }
        if (deviceContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deviceContext", "org/jetbrains/android/logcat/AndroidLogcatView", "<init>"));
        }
        this(project, null, deviceContext);
    }

    private AndroidLogcatView(final Project project, @Nullable IDevice preselectedDevice, @Nullable DeviceContext deviceContext) {
        this.myLock = new Object();
        this.myDeviceContext = deviceContext;
        this.myProject = project;
        this.myPreselectedDevice = preselectedDevice;
        this.$$$setupUI$$$();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.myLogFilterModel = new AndroidLogFilterModel(){
            @Nullable
            private ConfiguredFilter myConfiguredFilter;

            @Override
            protected void setCustomFilter(String filter) {
                AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_CUSTOM_FILTER = filter;
            }

            @Override
            protected void saveLogLevel(String logLevelName) {
                AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_LOG_LEVEL = logLevelName;
            }

            @Override
            public String getSelectedLogLevelName() {
                return AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_LOG_LEVEL;
            }

            public String getCustomFilter() {
                return AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_CUSTOM_FILTER;
            }

            @Override
            protected void setConfiguredFilter(@Nullable ConfiguredFilter filter) {
                AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_CONFIGURED_FILTER = filter != null ? filter.getName() : "";
                this.myConfiguredFilter = filter;
            }

            @Override
            @Nullable
            protected ConfiguredFilter getConfiguredFilter() {
                if (this.myConfiguredFilter == null) {
                    String name = AndroidLogcatFiltersPreferences.getInstance((Project)project).TOOL_WINDOW_CONFIGURED_FILTER;
                    this.myConfiguredFilter = AndroidLogcatView.this.compileConfiguredFilter(name);
                }
                return this.myConfiguredFilter;
            }
        };
        this.myLogConsole = new AndroidLogConsole(project, this.myLogFilterModel);
        this.myLogConsole.addListener(new LogConsoleListener(){

            public void loggingWillBeStopped() {
                if (AndroidLogcatView.this.myCurrentWriter != null) {
                    try {
                        AndroidLogcatView.this.myCurrentWriter.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
        if (preselectedDevice == null && deviceContext != null) {
            DeviceContext.DeviceSelectionListener deviceSelectionListener = new DeviceContext.DeviceSelectionListener(){

                @Override
                public void deviceSelected(@Nullable IDevice device) {
                    AndroidLogcatView.this.updateInUIThread();
                }

                @Override
                public void deviceChanged(@NotNull IDevice device, int changeMask) {
                    if (device == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "org/jetbrains/android/logcat/AndroidLogcatView$4", "deviceChanged"));
                    }
                    if (device == AndroidLogcatView.this.myDevice && (changeMask & 1) == 1) {
                        AndroidLogcatView.this.myDevice = null;
                        AndroidLogcatView.this.updateInUIThread();
                    }
                }

                @Override
                public void clientSelected(final @Nullable Client c) {
                    if (PropertiesComponent.getInstance().getBoolean(AndroidLogcatView.FILTER_LOGCAT_WHEN_SELECTION_CHANGES, true)) {
                        if (ApplicationManager.getApplication().isDispatchThread()) {
                            AndroidLogcatView.this.createAndSelectFilterForClient(c);
                        } else {
                            ApplicationManager.getApplication().invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    AndroidLogcatView.this.createAndSelectFilterForClient(c);
                                }
                            });
                        }
                    }
                }
            };
            deviceContext.addListener(deviceSelectionListener, this);
        }
        JComponent consoleComponent = this.myLogConsole.getComponent();
        ConsoleView console = this.myLogConsole.getConsole();
        if (console != null) {
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", this.myLogConsole.getOrCreateActions(), false);
            toolbar.setTargetComponent(console.getComponent());
            JComponent tbComp1 = toolbar.getComponent();
            this.myPanel.add((Component)tbComp1, "West");
        }
        this.myPanel.add((Component)consoleComponent, "Center");
        Disposer.register((Disposable)this, (Disposable)this.myLogConsole);
        this.updateLogConsole();
        this.selectFilter(AndroidLogcatFiltersPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER);
    }

    @NotNull
    public ActionGroup getToolbarActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new MyFilterSelectedClientAction());
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/AndroidLogcatView", "getToolbarActions"));
        }
        return defaultActionGroup;
    }

    @NotNull
    public JPanel createSearchComponent(Project project) {
        JPanel panel = new JPanel();
        final JComboBox editFiltersCombo = new JComboBox();
        this.myFilterComboBoxModel = new DefaultComboBoxModel();
        editFiltersCombo.setModel(this.myFilterComboBoxModel);
        String configuredFilter = AndroidLogcatFiltersPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER;
        this.updateConfiguredFilters(configuredFilter != null && configuredFilter.length() > 0 ? configuredFilter : NO_FILTERS);
        editFiltersCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String prev = AndroidLogcatView.this.myCurrentFilterName;
                AndroidLogcatView.this.myCurrentFilterName = (String)editFiltersCombo.getSelectedItem();
                if (AndroidLogcatView.this.myCurrentFilterName == null || AndroidLogcatView.this.myCurrentFilterName.equals(prev)) {
                    return;
                }
                if (EDIT_FILTER_CONFIGURATION.equals(AndroidLogcatView.this.myCurrentFilterName)) {
                    EditLogFilterDialog dialog = new EditLogFilterDialog(AndroidLogcatView.this, prev);
                    dialog.setTitle(AndroidBundle.message("android.logcat.new.filter.dialog.title", new Object[0]));
                    if (dialog.showAndGet()) {
                        AndroidConfiguredLogFilters.MyFilterEntry newEntry = dialog.getCustomLogFiltersEntry();
                        AndroidLogcatView.this.updateConfiguredFilters(newEntry != null ? newEntry.getName() : NO_FILTERS);
                    } else {
                        AndroidLogcatView.this.myCurrentFilterName = prev;
                        editFiltersCombo.setSelectedItem(AndroidLogcatView.this.myCurrentFilterName);
                    }
                } else {
                    AndroidLogcatView.this.selectFilter(AndroidLogcatView.this.myCurrentFilterName);
                }
                PropertiesComponent.getInstance().setValue(AndroidLogcatView.FILTER_LOGCAT_WHEN_SELECTION_CHANGES, Boolean.FALSE.toString());
            }
        });
        panel.add(editFiltersCombo);
        JPanel searchComponent = new JPanel();
        searchComponent.setLayout(new BoxLayout(searchComponent, 0));
        searchComponent.add(this.myLogConsole.getSearchComponent());
        searchComponent.add(panel);
        JPanel jPanel = searchComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/AndroidLogcatView", "createSearchComponent"));
        }
        return jPanel;
    }

    protected abstract boolean isActive();

    public void activate() {
        if (this.isActive()) {
            this.updateLogConsole();
            this.selectFilter(AndroidLogcatFiltersPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER);
        }
        if (this.myLogConsole != null) {
            this.myLogConsole.activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLogConsole() {
        IDevice device = this.getSelectedDevice();
        if (this.myDevice != device) {
            Object object = this.myLock;
            synchronized (object) {
                this.myDevice = device;
                if (this.myCurrentWriter != null) {
                    try {
                        this.myCurrentWriter.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                if (this.myCurrentReader != null) {
                    try {
                        this.myCurrentReader.close();
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                if (device != null) {
                    Pair<Reader, Writer> pair;
                    ConsoleView console = this.myLogConsole.getConsole();
                    if (console != null) {
                        console.clear();
                    }
                    if ((pair = AndroidLogcatUtil.startLoggingThread(this.myProject, device, false, this.myLogConsole)) != null) {
                        this.myCurrentReader = (Reader)pair.first;
                        this.myCurrentWriter = (Writer)pair.second;
                    } else {
                        this.myCurrentReader = null;
                        this.myCurrentWriter = null;
                    }
                }
            }
        }
    }

    @Nullable
    public IDevice getSelectedDevice() {
        if (this.myPreselectedDevice != null) {
            return this.myPreselectedDevice;
        }
        if (this.myDeviceContext != null) {
            return this.myDeviceContext.getSelectedDevice();
        }
        return null;
    }

    @Nullable
    private ConfiguredFilter compileConfiguredFilter(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/android/logcat/AndroidLogcatView", "compileConfiguredFilter"));
        }
        if (NO_FILTERS.equals(name)) {
            return null;
        }
        AndroidConfiguredLogFilters.MyFilterEntry entry = AndroidConfiguredLogFilters.getInstance(this.myProject).findFilterEntryByName(name);
        return ConfiguredFilter.compile(entry, name);
    }

    private void selectFilter(@NotNull String filterName) {
        if (filterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterName", "org/jetbrains/android/logcat/AndroidLogcatView", "selectFilter"));
        }
        ConfiguredFilter filter = this.compileConfiguredFilter(filterName);
        this.selectFilter(filter, filterName);
    }

    private void selectFilter(final @Nullable ConfiguredFilter filter, final @NotNull String filterName) {
        if (filterName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterName", "org/jetbrains/android/logcat/AndroidLogcatView", "selectFilter"));
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Applying filter..."){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/android/logcat/AndroidLogcatView$6", "run"));
                }
                AndroidLogcatView.this.myLogFilterModel.updateConfiguredFilter(filter);
                AndroidLogcatView.this.myCurrentFilterName = filterName;
            }
        });
    }

    private void createAndSelectFilterForClient(@Nullable Client client) {
        ConfiguredFilter filter;
        String name;
        if (client != null) {
            AndroidConfiguredLogFilters.MyFilterEntry f = AndroidConfiguredLogFilters.getInstance(this.myProject).createFilterForProcess(client.getClientData().getPid());
            name = f.getName();
            filter = ConfiguredFilter.compile(f, name);
        } else {
            filter = null;
            name = NO_FILTERS;
        }
        this.selectFilter(filter, name);
        this.myFilterComboBoxModel.setSelectedItem(NO_FILTERS.equals(name) ? NO_FILTERS : null);
    }

    public boolean isFiltered() {
        return StringUtil.isNotEmpty((String)this.myCurrentFilterName) && !NO_FILTERS.equals(this.myCurrentFilterName);
    }

    public void createAndSelectFilterByPackage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/android/logcat/AndroidLogcatView", "createAndSelectFilterByPackage"));
        }
        AndroidConfiguredLogFilters.MyFilterEntry f = AndroidConfiguredLogFilters.getInstance(this.myProject).getFilterForPackage(packageName, true);
        this.updateConfiguredFilters(f.getName());
    }

    private void updateConfiguredFilters(@NotNull String defaultSelection) {
        if (defaultSelection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultSelection", "org/jetbrains/android/logcat/AndroidLogcatView", "updateConfiguredFilters"));
        }
        AndroidConfiguredLogFilters filters = AndroidConfiguredLogFilters.getInstance(this.myProject);
        List<AndroidConfiguredLogFilters.MyFilterEntry> entries = filters.getFilterEntries();
        this.myFilterComboBoxModel.removeAllElements();
        this.myFilterComboBoxModel.addElement(NO_FILTERS);
        this.myFilterComboBoxModel.addElement(EDIT_FILTER_CONFIGURATION);
        for (AndroidConfiguredLogFilters.MyFilterEntry entry : entries) {
            String name = entry.getName();
            this.myFilterComboBoxModel.addElement(name);
            if (!name.equals(defaultSelection)) continue;
            this.myFilterComboBoxModel.setSelectedItem(name);
        }
        this.selectFilter(defaultSelection);
    }

    public JPanel getContentPanel() {
        return this.myPanel;
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        ((Component)jPanel).setBackground(new Color(-1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyFilterSelectedClientAction
    extends ToggleAction {
        public MyFilterSelectedClientAction() {
            super("Only Show Logcat From Selected Process", "", AndroidIcons.Ddms.LogcatAutoFilterSelectedPid);
        }

        public boolean isSelected(AnActionEvent e) {
            return PropertiesComponent.getInstance().getBoolean(AndroidLogcatView.FILTER_LOGCAT_WHEN_SELECTION_CHANGES, true);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            PropertiesComponent.getInstance().setValue(AndroidLogcatView.FILTER_LOGCAT_WHEN_SELECTION_CHANGES, Boolean.valueOf(state).toString());
            if (AndroidLogcatView.this.myDeviceContext != null) {
                AndroidLogcatView.this.createAndSelectFilterForClient(state ? AndroidLogcatView.this.myDeviceContext.getSelectedClient() : null);
            }
        }
    }

    public class AndroidLogConsole
    extends LogConsoleBase {
        public AndroidLogConsole(Project project, AndroidLogFilterModel logFilterModel) {
            super(project, (Reader)new MyLoggingReader(), "", false, (LogFilterModel)logFilterModel);
            ConsoleView console = this.getConsole();
            if (console instanceof ConsoleViewImpl) {
                ConsoleViewImpl c = (ConsoleViewImpl)console;
                c.addCustomConsoleAction((AnAction)new Separator());
                c.addCustomConsoleAction((AnAction)new MyRestartAction());
            }
        }

        public boolean isActive() {
            return AndroidLogcatView.this.isActive();
        }

        public void clearLogcat() {
            IDevice device = AndroidLogcatView.this.getSelectedDevice();
            if (device != null) {
                AndroidLogcatUtil.clearLogcat(AndroidLogcatView.this.myProject, device);
            }
            AndroidLogcatView.this.myLogConsole.clear();
        }
    }

    private class MyRestartAction
    extends AnAction {
        public MyRestartAction() {
            super(AndroidBundle.message("android.restart.logcat.action.text", new Object[0]), AndroidBundle.message("android.restart.logcat.action.description", new Object[0]), AllIcons.Actions.Restart);
        }

        public void actionPerformed(AnActionEvent e) {
            AndroidLogcatView.this.myDevice = null;
            AndroidLogcatView.this.updateLogConsole();
        }
    }

    private class MyLoggingReader
    extends AndroidLoggingReader {
        private MyLoggingReader() {
        }

        @Override
        @NotNull
        protected Object getLock() {
            Object object = AndroidLogcatView.this.myLock;
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/logcat/AndroidLogcatView$MyLoggingReader", "getLock"));
            }
            return object;
        }

        @Override
        protected Reader getReader() {
            return AndroidLogcatView.this.myCurrentReader;
        }
    }
}

