/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.animation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ClassMapConstructor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AndroidAnimationUtils {
    @NonNls
    public static final String ANIMATION_PACKAGE = "android.view.animation";
    @NonNls
    private static final String INTERPOLATOR_CLASS_NAME = "android.view.animation.Interpolator";
    private static final String[] TAG_NAMES = new String[]{"set", "alpha", "scale", "translate", "rotate", "layoutAnimation", "gridLayoutAnimation", "animation-list"};

    private AndroidAnimationUtils() {
    }

    public static String getStyleableNameByTagName(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "org/jetbrains/android/dom/animation/AndroidAnimationUtils", "getStyleableNameByTagName"));
        }
        if (tagName.equals("set")) {
            return "AnimationSet";
        }
        String capitalizedTagName = StringUtil.capitalize((String)tagName);
        String suffix = "Animation";
        if (ArrayUtil.find((Object[])TAG_NAMES, (Object)tagName) >= 0 && !tagName.endsWith(suffix)) {
            return capitalizedTagName + suffix;
        }
        return capitalizedTagName;
    }

    public static List<String> getPossibleChildren(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/dom/animation/AndroidAnimationUtils", "getPossibleChildren"));
        }
        ArrayList<String> children = new ArrayList<String>();
        Collections.addAll(children, TAG_NAMES);
        children.addAll(facet.getClassMap(INTERPOLATOR_CLASS_NAME, new ClassMapConstructor(){

            @Override
            @NotNull
            public String[] getTagNamesByClass(@NotNull PsiClass c) {
                String[] stringArray;
                if (c == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/android/dom/animation/AndroidAnimationUtils$1", "getTagNamesByClass"));
                }
                String name = c.getName();
                if (name != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = StringUtil.decapitalize((String)name);
                } else {
                    stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
                }
                if (stringArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/dom/animation/AndroidAnimationUtils$1", "getTagNamesByClass"));
                }
                return stringArray;
            }
        }).keySet());
        return children;
    }
}

