/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.fileTypes.AndroidRenderscriptFileType;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.compiler.AndroidCompileUtil;
import org.jetbrains.android.compiler.tools.AndroidIdl;
import org.jetbrains.android.compiler.tools.AndroidRenderscript;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.fileTypes.AndroidIdlFileType;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidAutogenerator {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.compiler.AndroidAutogenerator");

    private AndroidAutogenerator() {
    }

    private static boolean toRun(@NotNull AndroidAutogeneratorMode mode, @NotNull AndroidFacet facet, boolean force) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/compiler/AndroidAutogenerator", "toRun"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/compiler/AndroidAutogenerator", "toRun"));
        }
        if (!AndroidAutogenerator.supportsAutogeneration(facet)) {
            return false;
        }
        if (!force && !facet.getProperties().ENABLE_SOURCES_AUTOGENERATION) {
            return false;
        }
        switch (mode) {
            case AAPT: 
            case AIDL: 
            case RENDERSCRIPT: 
            case BUILDCONFIG: {
                return true;
            }
        }
        LOG.error("Unknown autogenerator mode " + (Object)((Object)mode));
        return false;
    }

    public static boolean supportsAutogeneration(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/compiler/AndroidAutogenerator", "supportsAutogeneration"));
        }
        return !facet.isGradleProject();
    }

    public static void run(@NotNull AndroidAutogeneratorMode mode, @NotNull AndroidFacet facet, @NotNull CompileContext context, boolean force) {
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/compiler/AndroidAutogenerator", "run"));
        }
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/compiler/AndroidAutogenerator", "run"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/AndroidAutogenerator", "run"));
        }
        if (!AndroidAutogenerator.toRun(mode, facet, force)) {
            return;
        }
        HashSet obsoleteFiles = new HashSet(facet.getAutogeneratedFiles(mode));
        switch (mode) {
            case AAPT: {
                AndroidAutogenerator.runAapt(facet, context, force);
                break;
            }
            case AIDL: {
                AndroidAutogenerator.runAidl(facet, context);
                break;
            }
            case RENDERSCRIPT: {
                AndroidAutogenerator.runRenderscript(facet, context);
                break;
            }
            case BUILDCONFIG: {
                AndroidAutogenerator.runBuildConfigGenerator(facet, context);
                break;
            }
            default: {
                LOG.error("Unknown mode" + (Object)((Object)mode));
            }
        }
        obsoleteFiles.removeAll(facet.getAutogeneratedFiles(mode));
        for (String path : obsoleteFiles) {
            File file = new File(path);
            if (!file.isFile()) continue;
            FileUtil.delete((File)file);
            CompilerUtil.refreshIOFile((File)file);
        }
    }

    private static void runBuildConfigGenerator(final @NotNull AndroidFacet facet, final @NotNull CompileContext context) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/compiler/AndroidAutogenerator", "runBuildConfigGenerator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/AndroidAutogenerator", "runBuildConfigGenerator"));
        }
        final Module module = facet.getModule();
        BuildconfigAutogenerationItem item = (BuildconfigAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<BuildconfigAutogenerationItem>(){

            @Nullable
            public BuildconfigAutogenerationItem compute() {
                if (module.isDisposed() || module.getProject().isDisposed()) {
                    return null;
                }
                String sourceRootPath = AndroidRootUtil.getBuildconfigGenSourceRootPath(facet);
                if (sourceRootPath == null) {
                    return null;
                }
                VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet);
                if (manifestFile == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.manifest.not.found", module.getName()), null, -1, -1);
                    return null;
                }
                Manifest manifest = AndroidUtils.loadDomElement(module, manifestFile, Manifest.class);
                if (manifest == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, "Cannot parse file", manifestFile.getUrl(), -1, -1);
                    return null;
                }
                String packageName = (String)manifest.getPackage().getValue();
                if (packageName != null) {
                    packageName = packageName.trim();
                }
                if (packageName == null || packageName.length() <= 0) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("package.not.found.error", new Object[0]), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                if (!AndroidUtils.isValidAndroidPackageName(packageName)) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("not.valid.package.name.error", packageName), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                return new BuildconfigAutogenerationItem(packageName, FileUtil.toSystemDependentName((String)sourceRootPath));
            }
        });
        if (item == null) {
            return;
        }
        try {
            AndroidAutogenerator.generateStubClass(item.myPackage, new File(item.mySourceRootOsPath), "BuildConfig", "  public final static boolean DEBUG = Boolean.parseBoolean(null);\n");
            VirtualFile genSourceRoot = LocalFileSystem.getInstance().findFileByPath(item.mySourceRootOsPath);
            if (genSourceRoot != null) {
                genSourceRoot.refresh(false, true);
            }
            facet.clearAutogeneratedFiles(AndroidAutogeneratorMode.BUILDCONFIG);
            VirtualFile genFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(item.mySourceRootOsPath + '/' + item.myPackage.replace('.', '/') + '/' + "BuildConfig.java");
            if (genFile != null && genFile.exists()) {
                facet.markFileAutogenerated(AndroidAutogeneratorMode.BUILDCONFIG, genFile);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (module.getProject().isDisposed()) {
                        return;
                    }
                    context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runAapt(final @NotNull AndroidFacet facet, final @NotNull CompileContext context, boolean force) {
        VirtualFile genFile;
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/compiler/AndroidAutogenerator", "runAapt"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/AndroidAutogenerator", "runAapt"));
        }
        final Module module = facet.getModule();
        AptAutogenerationItem item = (AptAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<AptAutogenerationItem>(){

            @Nullable
            public AptAutogenerationItem compute() {
                if (module.isDisposed() || module.getProject().isDisposed()) {
                    return null;
                }
                VirtualFile manifestFile = AndroidRootUtil.getManifestFileForCompiler(facet);
                if (manifestFile == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.manifest.not.found", module.getName()), null, -1, -1);
                    return null;
                }
                Manifest manifest = AndroidUtils.loadDomElement(module, manifestFile, Manifest.class);
                if (manifest == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, "Cannot parse file", manifestFile.getUrl(), -1, -1);
                    return null;
                }
                String packageName = (String)manifest.getPackage().getValue();
                if (packageName != null) {
                    packageName = packageName.trim();
                }
                if (packageName == null || packageName.length() <= 0) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("package.not.found.error", new Object[0]), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                if (!AndroidUtils.isValidAndroidPackageName(packageName)) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("not.valid.package.name.error", packageName), manifestFile.getUrl(), -1, -1);
                    return null;
                }
                String sourceRootPath = AndroidRootUtil.getAptGenSourceRootPath(facet);
                if (sourceRootPath == null) {
                    context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.apt.gen.not.specified", module.getName()), null, -1, -1);
                    return null;
                }
                HashMap genFilePath2Package = new HashMap();
                String packageDir = packageName.replace('.', '/') + '/';
                genFilePath2Package.put(packageDir + "Manifest.java", packageName);
                genFilePath2Package.put(packageDir + "R.java", packageName);
                return new AptAutogenerationItem(packageName, sourceRootPath, (Map)genFilePath2Package);
            }
        });
        if (item == null) {
            return;
        }
        if (force) {
            HashSet filesToCheck = new HashSet();
            for (String string : item.myGenFileRelPath2package.keySet()) {
                String genFileFullPath = item.myOutputDirOsPath + '/' + string;
                if (!new File(genFileFullPath).exists() || (genFile = LocalFileSystem.getInstance().findFileByPath(genFileFullPath)) == null) continue;
                filesToCheck.add(genFile);
            }
            if (!AndroidAutogenerator.ensureFilesWritable(module.getProject(), (Collection<VirtualFile>)filesToCheck)) {
                return;
            }
        }
        File tempOutDir = null;
        try {
            tempOutDir = FileUtil.createTempDirectory((String)"android_apt_autogeneration", (String)"tmp");
            AndroidAutogenerator.generateStubClasses(item.myPackage, tempOutDir, "R", "Manifest");
            for (String string : item.myGenFileRelPath2package.keySet()) {
                File srcFile = new File(tempOutDir.getPath() + '/' + string);
                if (!srcFile.isFile()) continue;
                final File dstFile = new File(item.myOutputDirOsPath + '/' + string);
                if (dstFile.exists()) {
                    if (!force) continue;
                    if (!FileUtil.delete((File)dstFile)) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                if (module.isDisposed() || module.getProject().isDisposed()) {
                                    return;
                                }
                                context.addMessage(CompilerMessageCategory.ERROR, "Cannot delete " + FileUtil.toSystemDependentName((String)dstFile.getPath()), null, -1, -1);
                            }
                        });
                    }
                }
                FileUtil.rename((File)srcFile, (File)dstFile);
            }
            for (Map.Entry entry : item.myGenFileRelPath2package.entrySet()) {
                String path = item.myOutputDirOsPath + '/' + (String)entry.getKey();
                String aPackage = (String)entry.getValue();
                File file = new File(path);
                CompilerUtil.refreshIOFile((File)file);
                AndroidAutogenerator.removeAllFilesWithSameName(module, file, item.myOutputDirOsPath);
                AndroidAutogenerator.removeDuplicateClasses(module, aPackage, file, item.myOutputDirOsPath);
            }
            VirtualFile genSourceRoot = LocalFileSystem.getInstance().findFileByPath(item.myOutputDirOsPath);
            if (genSourceRoot != null) {
                genSourceRoot.refresh(false, true);
            }
            facet.clearAutogeneratedFiles(AndroidAutogeneratorMode.AAPT);
            for (String relPath : item.myGenFileRelPath2package.keySet()) {
                genFile = LocalFileSystem.getInstance().findFileByPath(item.myOutputDirOsPath + '/' + relPath);
                if (genFile == null || !genFile.exists()) continue;
                facet.markFileAutogenerated(AndroidAutogeneratorMode.AAPT, genFile);
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (module.getProject().isDisposed()) {
                        return;
                    }
                    context.addMessage(CompilerMessageCategory.ERROR, "I/O error: " + e.getMessage(), null, -1, -1);
                }
            });
        }
        finally {
            if (tempOutDir != null) {
                FileUtil.delete((File)tempOutDir);
            }
        }
    }

    private static void generateStubClasses(@NotNull String aPackage, @NotNull File outputDir, String ... classNames) throws IOException {
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/android/compiler/AndroidAutogenerator", "generateStubClasses"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "org/jetbrains/android/compiler/AndroidAutogenerator", "generateStubClasses"));
        }
        if (classNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classNames", "org/jetbrains/android/compiler/AndroidAutogenerator", "generateStubClasses"));
        }
        assert (aPackage.length() > 0);
        for (String className : classNames) {
            AndroidAutogenerator.generateStubClass(aPackage, outputDir, className, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateStubClass(String aPackage, File outputDir, String className, String content) throws IOException {
        File packageDir = new File(outputDir.getPath() + '/' + aPackage.replace('.', '/'));
        if (!packageDir.exists() && !packageDir.mkdirs()) {
            throw new IOException("Cannot create directory " + FileUtil.toSystemDependentName((String)packageDir.getPath()));
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(packageDir, className + ".java")));
        try {
            writer.write("/*___Generated_by_IDEA___*/\n\npackage " + aPackage + ";\n\n" + "/* This stub is only used by the IDE. It is NOT the " + className + " class actually packed into the APK */\n" + "public final class " + className + " {\n" + content + "}");
        }
        finally {
            writer.close();
        }
    }

    private static void patchAndMarkGeneratedFile(@NotNull AndroidFacet facet, @NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile vFile) throws IOException {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/compiler/AndroidAutogenerator", "patchAndMarkGeneratedFile"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/android/compiler/AndroidAutogenerator", "patchAndMarkGeneratedFile"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "org/jetbrains/android/compiler/AndroidAutogenerator", "patchAndMarkGeneratedFile"));
        }
        File file = new File(vFile.getPath());
        String fileText = FileUtil.loadFile((File)file);
        FileUtil.writeToFile((File)file, (String)("/*___Generated_by_IDEA___*/\n\n" + fileText));
        facet.markFileAutogenerated(mode, vFile);
    }

    private static void removeAllFilesWithSameName(final @NotNull Module module, final @NotNull File file, @NotNull String directoryPath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/compiler/AndroidAutogenerator", "removeAllFilesWithSameName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/compiler/AndroidAutogenerator", "removeAllFilesWithSameName"));
        }
        if (directoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryPath", "org/jetbrains/android/compiler/AndroidAutogenerator", "removeAllFilesWithSameName"));
        }
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByIoFile(file);
        VirtualFile genDir = LocalFileSystem.getInstance().findFileByPath(directoryPath);
        if (vFile == null || genDir == null) {
            return;
        }
        Collection files = (Collection)DumbService.getInstance((Project)module.getProject()).runReadActionInSmartMode((Computable)new Computable<Collection<VirtualFile>>(){

            @Nullable
            public Collection<VirtualFile> compute() {
                if (module.isDisposed() || module.getProject().isDisposed()) {
                    return null;
                }
                return FilenameIndex.getVirtualFilesByName((Project)module.getProject(), (String)file.getName(), (GlobalSearchScope)module.getModuleScope(false));
            }
        });
        if (files == null) {
            return;
        }
        final ArrayList<VirtualFile> filesToDelete = new ArrayList<VirtualFile>();
        for (VirtualFile f : files) {
            if (Comparing.equal((Object)f, (Object)vFile) || !VfsUtilCore.isAncestor((VirtualFile)genDir, (VirtualFile)f, (boolean)true)) continue;
            filesToDelete.add(f);
        }
        if (filesToDelete.size() == 0) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        for (VirtualFile f : filesToDelete) {
                            if (!f.isValid() || !f.exists()) continue;
                            try {
                                f.delete((Object)module.getProject());
                            }
                            catch (IOException e) {
                                LOG.debug((Throwable)e);
                            }
                        }
                    }
                });
            }
        });
    }

    private static void runAidl(final @NotNull AndroidFacet facet, final @NotNull CompileContext context) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/compiler/AndroidAutogenerator", "runAidl"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/AndroidAutogenerator", "runAidl"));
        }
        final Module module = facet.getModule();
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(module, false);
        VirtualFile[] files = moduleCompileScope.getFiles((FileType)AndroidIdlFileType.ourFileType, true);
        ArrayList<IdlAutogenerationItem> items = new ArrayList<IdlAutogenerationItem>();
        for (final VirtualFile file : files) {
            IdlAutogenerationItem item = (IdlAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<IdlAutogenerationItem>(){

                @Nullable
                public IdlAutogenerationItem compute() {
                    if (module.isDisposed() || module.getProject().isDisposed()) {
                        return null;
                    }
                    IAndroidTarget target = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidTarget();
                    if (target == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                        return null;
                    }
                    String packageName = AndroidUtils.computePackageName(module, file);
                    if (packageName == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot compute package for file", file.getUrl(), -1, -1);
                        return null;
                    }
                    String sourceRootPath = AndroidRootUtil.getAidlGenSourceRootPath(facet);
                    if (sourceRootPath == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.apt.gen.not.specified", module.getName()), null, -1, -1);
                        return null;
                    }
                    VirtualFile[] sourceRoots = AndroidAutogenerator.getSourceRootsForModuleAndDependencies(module, false);
                    String[] sourceRootOsPaths = AndroidCompileUtil.toOsPaths(sourceRoots);
                    String outFileOsPath = FileUtil.toSystemDependentName((String)(sourceRootPath + '/' + packageName.replace('.', '/') + '/' + file.getNameWithoutExtension() + ".java"));
                    return new IdlAutogenerationItem(file, target, outFileOsPath, sourceRootOsPaths, sourceRootPath, packageName);
                }
            });
            if (item == null) continue;
            items.add(item);
        }
        HashSet filesToCheck = new HashSet();
        for (IdlAutogenerationItem item : items) {
            if (!new File(FileUtil.toSystemDependentName((String)item.myFile.getPath())).exists()) continue;
            filesToCheck.add(item.myFile);
        }
        if (!AndroidAutogenerator.ensureFilesWritable(module.getProject(), (Collection<VirtualFile>)filesToCheck)) {
            return;
        }
        facet.clearAutogeneratedFiles(AndroidAutogeneratorMode.AIDL);
        for (IdlAutogenerationItem item : items) {
            VirtualFile file;
            file = item.myFile;
            String fileOsPath = FileUtil.toSystemDependentName((String)file.getPath());
            try {
                VirtualFile outFile;
                final Map messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidIdl.execute((IAndroidTarget)item.myTarget, (String)fileOsPath, (String)item.myOutFileOsPath, (String[])item.mySourceRootOsPaths));
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module.getProject().isDisposed()) {
                            return;
                        }
                        for (CompilerMessageCategory category : messages.keySet()) {
                            List messageList = (List)messages.get(category);
                            for (String message : messageList) {
                                context.addMessage(category, message, file.getUrl(), -1, -1);
                            }
                        }
                    }
                });
                AndroidAutogenerator.removeDuplicateClasses(module, item.myPackage, new File(item.myOutFileOsPath), item.myOutDirOsPath);
                VirtualFile genDir = LocalFileSystem.getInstance().findFileByPath(item.myOutDirOsPath);
                if (genDir != null) {
                    genDir.refresh(false, true);
                }
                if ((outFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(item.myOutFileOsPath)) == null || !outFile.exists()) continue;
                AndroidAutogenerator.patchAndMarkGeneratedFile(facet, AndroidAutogeneratorMode.AIDL, outFile);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module.getProject().isDisposed()) {
                            return;
                        }
                        context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), file.getUrl(), -1, -1);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runRenderscript(final @NotNull AndroidFacet facet, final @NotNull CompileContext context) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/jetbrains/android/compiler/AndroidAutogenerator", "runRenderscript"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/android/compiler/AndroidAutogenerator", "runRenderscript"));
        }
        final Module module = facet.getModule();
        ModuleCompileScope moduleCompileScope = new ModuleCompileScope(module, false);
        VirtualFile[] files = moduleCompileScope.getFiles((FileType)AndroidRenderscriptFileType.INSTANCE, true);
        facet.clearAutogeneratedFiles(AndroidAutogeneratorMode.RENDERSCRIPT);
        for (final VirtualFile file : files) {
            RenderscriptAutogenerationItem item = (RenderscriptAutogenerationItem)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RenderscriptAutogenerationItem>(){

                @Nullable
                public RenderscriptAutogenerationItem compute() {
                    AndroidPlatform platform = ((AndroidFacetConfiguration)facet.getConfiguration()).getAndroidPlatform();
                    if (platform == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, AndroidBundle.message("android.compilation.error.specify.platform", module.getName()), null, -1, -1);
                        return null;
                    }
                    IAndroidTarget target = platform.getTarget();
                    String sdkLocation = platform.getSdkData().getPath();
                    String packageName = AndroidUtils.computePackageName(module, file);
                    if (packageName == null) {
                        context.addMessage(CompilerMessageCategory.ERROR, "Cannot compute package for file", file.getUrl(), -1, -1);
                        return null;
                    }
                    String resourceDirPath = AndroidRootUtil.getResourceDirPath(facet);
                    assert (resourceDirPath != null);
                    String sourceRootPath = AndroidRootUtil.getRenderscriptGenSourceRootPath(facet);
                    if (sourceRootPath == null) {
                        return null;
                    }
                    String rawDirPath = resourceDirPath + '/' + "raw";
                    return new RenderscriptAutogenerationItem(sdkLocation, target, sourceRootPath, rawDirPath);
                }
            });
            if (item == null) continue;
            File tempOutDir = null;
            try {
                tempOutDir = FileUtil.createTempDirectory((String)"android_renderscript_autogeneration", (String)"tmp");
                VirtualFile vTempOutDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempOutDir);
                String depFolderPath = vTempOutDir != null ? AndroidAutogenerator.getDependencyFolder(context.getProject(), file, vTempOutDir) : null;
                final Map messages = AndroidCompileUtil.toCompilerMessageCategoryKeys(AndroidRenderscript.execute((String)item.mySdkLocation, (IAndroidTarget)item.myTarget, (String)file.getPath(), (String)tempOutDir.getPath(), (String)depFolderPath, (String)item.myRawDirPath));
                if (((List)messages.get(CompilerMessageCategory.ERROR)).size() == 0) {
                    ArrayList newFiles = new ArrayList();
                    AndroidCommonUtils.moveAllFiles((File)tempOutDir, (File)new File(item.myGenDirPath), newFiles);
                    for (File newFile : newFiles) {
                        VirtualFile newVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(newFile);
                        if (newVFile == null) continue;
                        AndroidAutogenerator.patchAndMarkGeneratedFile(facet, AndroidAutogeneratorMode.RENDERSCRIPT, newVFile);
                    }
                    File bcFile = new File(item.myRawDirPath, FileUtil.getNameWithoutExtension((String)file.getName()) + ".bc");
                    VirtualFile vBcFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(bcFile);
                    if (vBcFile != null) {
                        facet.markFileAutogenerated(AndroidAutogeneratorMode.RENDERSCRIPT, vBcFile);
                    }
                }
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module.getProject().isDisposed()) {
                            return;
                        }
                        for (CompilerMessageCategory category : messages.keySet()) {
                            List messageList = (List)messages.get(category);
                            for (String message : messageList) {
                                context.addMessage(category, message, file.getUrl(), -1, -1);
                            }
                        }
                    }
                });
                VirtualFile genDir = LocalFileSystem.getInstance().findFileByPath(item.myGenDirPath);
                if (genDir == null) continue;
                genDir.refresh(false, true);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        if (module.getProject().isDisposed()) {
                            return;
                        }
                        context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), file.getUrl(), -1, -1);
                    }
                });
            }
            finally {
                if (tempOutDir != null) {
                    FileUtil.delete((File)tempOutDir);
                }
            }
        }
    }

    private static boolean ensureFilesWritable(final @NotNull Project project, final @NotNull Collection<VirtualFile> filesToCheck) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/compiler/AndroidAutogenerator", "ensureFilesWritable"));
        }
        if (filesToCheck == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesToCheck", "org/jetbrains/android/compiler/AndroidAutogenerator", "ensureFilesWritable"));
        }
        if (filesToCheck.size() == 0) {
            return true;
        }
        final boolean[] run = new boolean[]{false};
        ApplicationManager.getApplication().invokeAndWait(new Runnable(){

            @Override
            public void run() {
                run[0] = !project.isDisposed() && ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])filesToCheck.toArray(new VirtualFile[filesToCheck.size()]));
            }
        }, ModalityState.defaultModalityState());
        return run[0];
    }

    private static void removeDuplicateClasses(final @NotNull Module module, final @NotNull String aPackage, final @NotNull File generatedFile, final @NotNull String sourceRootPath) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/compiler/AndroidAutogenerator", "removeDuplicateClasses"));
        }
        if (aPackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/android/compiler/AndroidAutogenerator", "removeDuplicateClasses"));
        }
        if (generatedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedFile", "org/jetbrains/android/compiler/AndroidAutogenerator", "removeDuplicateClasses"));
        }
        if (sourceRootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRootPath", "org/jetbrains/android/compiler/AndroidAutogenerator", "removeDuplicateClasses"));
        }
        if (generatedFile.exists()) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (module.getProject().isDisposed() || module.isDisposed()) {
                        return;
                    }
                    String className = FileUtil.getNameWithoutExtension((File)generatedFile);
                    AndroidCompileUtil.removeDuplicatingClasses(module, aPackage, className, generatedFile, sourceRootPath);
                }
            });
        }
    }

    private static void fillSourceRoots(@NotNull Module module, @NotNull Set<Module> visited, @NotNull Set<VirtualFile> result, boolean includingTests) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/compiler/AndroidAutogenerator", "fillSourceRoots"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "org/jetbrains/android/compiler/AndroidAutogenerator", "fillSourceRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/android/compiler/AndroidAutogenerator", "fillSourceRoots"));
        }
        visited.add(module);
        AndroidFacet facet = AndroidFacet.getInstance(module);
        VirtualFile resDir = facet != null ? AndroidRootUtil.getResourceDir(facet) : null;
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        for (VirtualFile virtualFile : manager.getSourceRoots(includingTests)) {
            if (Comparing.equal((Object)resDir, (Object)virtualFile)) continue;
            result.add(virtualFile);
        }
        for (VirtualFile virtualFile : manager.getOrderEntries()) {
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            DependencyScope scope;
            if (!(virtualFile instanceof ModuleOrderEntry) || (scope = (moduleOrderEntry = (ModuleOrderEntry)virtualFile).getScope()) != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || visited.contains(depModule)) continue;
            AndroidAutogenerator.fillSourceRoots(depModule, visited, result, false);
        }
    }

    @NotNull
    public static VirtualFile[] getSourceRootsForModuleAndDependencies(@NotNull Module module, boolean includingTests) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/android/compiler/AndroidAutogenerator", "getSourceRootsForModuleAndDependencies"));
        }
        HashSet result = new HashSet();
        AndroidAutogenerator.fillSourceRoots(module, (Set<Module>)new HashSet(), (Set<VirtualFile>)result, includingTests);
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)result);
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/android/compiler/AndroidAutogenerator", "getSourceRootsForModuleAndDependencies"));
        }
        return virtualFileArray;
    }

    @Nullable
    static String getDependencyFolder(@NotNull Project project, @NotNull VirtualFile sourceFile, @NotNull VirtualFile genFolder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/android/compiler/AndroidAutogenerator", "getDependencyFolder"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/android/compiler/AndroidAutogenerator", "getDependencyFolder"));
        }
        if (genFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genFolder", "org/jetbrains/android/compiler/AndroidAutogenerator", "getDependencyFolder"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = index.getSourceRootForFile(sourceFile);
        if (sourceRoot == null) {
            return null;
        }
        VirtualFile parent = sourceFile.getParent();
        if (Comparing.equal((Object)parent, (Object)sourceRoot)) {
            return genFolder.getPath();
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)sourceFile.getParent(), (VirtualFile)sourceRoot, (char)'/');
        assert (relativePath != null);
        return genFolder.getPath() + '/' + relativePath;
    }

    private static class BuildconfigAutogenerationItem {
        final String myPackage;
        final String mySourceRootOsPath;

        private BuildconfigAutogenerationItem(@NotNull String aPackage, @NotNull String sourceRootOsPath) {
            if (aPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/android/compiler/AndroidAutogenerator$BuildconfigAutogenerationItem", "<init>"));
            }
            if (sourceRootOsPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRootOsPath", "org/jetbrains/android/compiler/AndroidAutogenerator$BuildconfigAutogenerationItem", "<init>"));
            }
            this.myPackage = aPackage;
            this.mySourceRootOsPath = sourceRootOsPath;
        }
    }

    private static class RenderscriptAutogenerationItem {
        final String mySdkLocation;
        final IAndroidTarget myTarget;
        final String myGenDirPath;
        final String myRawDirPath;

        private RenderscriptAutogenerationItem(@NotNull String sdkLocation, @NotNull IAndroidTarget target, @NotNull String genDirPath, @NotNull String rawDirPath) {
            if (sdkLocation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkLocation", "org/jetbrains/android/compiler/AndroidAutogenerator$RenderscriptAutogenerationItem", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/compiler/AndroidAutogenerator$RenderscriptAutogenerationItem", "<init>"));
            }
            if (genDirPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genDirPath", "org/jetbrains/android/compiler/AndroidAutogenerator$RenderscriptAutogenerationItem", "<init>"));
            }
            if (rawDirPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rawDirPath", "org/jetbrains/android/compiler/AndroidAutogenerator$RenderscriptAutogenerationItem", "<init>"));
            }
            this.mySdkLocation = sdkLocation;
            this.myTarget = target;
            this.myGenDirPath = genDirPath;
            this.myRawDirPath = rawDirPath;
        }
    }

    private static class IdlAutogenerationItem {
        final VirtualFile myFile;
        final IAndroidTarget myTarget;
        final String myOutFileOsPath;
        final String[] mySourceRootOsPaths;
        final String myOutDirOsPath;
        final String myPackage;

        private IdlAutogenerationItem(@NotNull VirtualFile file, @NotNull IAndroidTarget target, @NotNull String outFileOsPath, @NotNull String[] sourceRootOsPaths, @NotNull String outDirOsPath, @NotNull String aPackage) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/android/compiler/AndroidAutogenerator$IdlAutogenerationItem", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/android/compiler/AndroidAutogenerator$IdlAutogenerationItem", "<init>"));
            }
            if (outFileOsPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outFileOsPath", "org/jetbrains/android/compiler/AndroidAutogenerator$IdlAutogenerationItem", "<init>"));
            }
            if (sourceRootOsPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRootOsPaths", "org/jetbrains/android/compiler/AndroidAutogenerator$IdlAutogenerationItem", "<init>"));
            }
            if (outDirOsPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outDirOsPath", "org/jetbrains/android/compiler/AndroidAutogenerator$IdlAutogenerationItem", "<init>"));
            }
            if (aPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/android/compiler/AndroidAutogenerator$IdlAutogenerationItem", "<init>"));
            }
            this.myFile = file;
            this.myTarget = target;
            this.myOutFileOsPath = outFileOsPath;
            this.mySourceRootOsPaths = sourceRootOsPaths;
            this.myOutDirOsPath = outDirOsPath;
            this.myPackage = aPackage;
        }
    }

    private static class AptAutogenerationItem {
        final String myPackage;
        final String myOutputDirOsPath;
        final Map<String, String> myGenFileRelPath2package;

        private AptAutogenerationItem(@NotNull String aPackage, @NotNull String outputDirOsPath, @NotNull Map<String, String> genFileRelPath2package) {
            if (aPackage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aPackage", "org/jetbrains/android/compiler/AndroidAutogenerator$AptAutogenerationItem", "<init>"));
            }
            if (outputDirOsPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDirOsPath", "org/jetbrains/android/compiler/AndroidAutogenerator$AptAutogenerationItem", "<init>"));
            }
            if (genFileRelPath2package == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "genFileRelPath2package", "org/jetbrains/android/compiler/AndroidAutogenerator$AptAutogenerationItem", "<init>"));
            }
            this.myPackage = aPackage;
            this.myOutputDirOsPath = outputDirOsPath;
            this.myGenFileRelPath2package = genFileRelPath2package;
        }
    }
}

