/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.Nullable;

public class AndroidResourceFileSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    @Nullable
    public Collection<? extends PsiElement> getElementsToSearch(PsiElement element, @Nullable Module module, Collection<PsiElement> allElementsToDelete) {
        return Collections.singletonList(element);
    }

    public boolean handlesElement(PsiElement element) {
        if (!(element instanceof PsiFile)) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        if (facet == null) {
            return false;
        }
        VirtualFile vFile = ((PsiFile)element).getVirtualFile();
        VirtualFile parent = vFile != null ? vFile.getParent() : null;
        VirtualFile resDir = parent != null ? parent.getParent() : null;
        return resDir != null && facet.getLocalResourceManager().isResourceDir(resDir);
    }

    @Nullable
    public NonCodeUsageSearchInfo findUsages(PsiElement element, PsiElement[] allElementsToDelete, List<UsageInfo> result) {
        SafeDeleteProcessor.findGenericElementUsages((PsiElement)element, result, (PsiElement[])allElementsToDelete);
        if (element instanceof PsiFile) {
            PsiField[] fields;
            for (PsiField field : fields = AndroidResourceUtil.findResourceFieldsForFileResource((PsiFile)element, true)) {
                SafeDeleteProcessor.findGenericElementUsages((PsiElement)field, result, (PsiElement[])allElementsToDelete);
            }
        }
        return new NonCodeUsageSearchInfo(SafeDeleteProcessor.getDefaultInsideDeletedCondition((PsiElement[])allElementsToDelete), element);
    }

    @Nullable
    public Collection<PsiElement> getAdditionalElementsToDelete(PsiElement element, Collection<PsiElement> allElementsToDelete, boolean askUser) {
        int r;
        if (allElementsToDelete.size() > 1) {
            return Collections.emptyList();
        }
        AndroidFacet facet = AndroidFacet.getInstance(element);
        assert (facet != null);
        PsiFile file = (PsiFile)element;
        VirtualFile vFile = file.getVirtualFile();
        assert (vFile != null);
        VirtualFile dir = vFile.getParent();
        assert (dir != null);
        String type = AndroidCommonUtils.getResourceTypeByDirName((String)dir.getName());
        if (type == null) {
            return Collections.emptyList();
        }
        String name = vFile.getName();
        List<PsiFile> resourceFiles = facet.getLocalResourceManager().findResourceFiles(type, AndroidCommonUtils.getResourceName((String)type, (String)name), true, false, new String[0]);
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiFile resourceFile : resourceFiles) {
            if (resourceFile.getManager().areElementsEquivalent((PsiElement)file, (PsiElement)resourceFile) || !resourceFile.getName().equals(name)) continue;
            result.add((PsiElement)resourceFile);
        }
        if (result.size() > 0 && askUser && (r = Messages.showDialog((Project)element.getProject(), (String)"Delete alternative resource files for other configurations?", (String)"Delete", (String[])new String[]{Messages.YES_BUTTON, Messages.NO_BUTTON}, (int)1, (Icon)Messages.getQuestionIcon())) != 0) {
            return Collections.emptyList();
        }
        return result;
    }

    @Nullable
    public Collection<String> findConflicts(PsiElement element, PsiElement[] allElementsToDelete) {
        return null;
    }

    @Nullable
    public UsageInfo[] preprocessUsages(Project project, UsageInfo[] usages) {
        return usages;
    }

    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
    }

    public boolean isToSearchInComments(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS;
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        return RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_COMMENTS = enabled;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        RefactoringSettings.getInstance().SAFE_DELETE_SEARCH_IN_NON_JAVA = enabled;
    }
}

