/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.maven.AndroidMavenUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidJavaCompletionContributor
extends CompletionContributor {
    private static final String[] EXCLUDED_PACKAGES = new String[]{"javax.swing", "javafx"};

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, final @NotNull CompletionResultSet resultSet) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/android/AndroidJavaCompletionContributor", "fillCompletionVariants"));
        }
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "org/jetbrains/android/AndroidJavaCompletionContributor", "fillCompletionVariants"));
        }
        super.fillCompletionVariants(parameters, resultSet);
        PsiElement position = parameters.getPosition();
        AndroidFacet facet = AndroidFacet.getInstance(position);
        if (facet == null || !AndroidMavenUtil.isMavenizedModule(facet.getModule())) {
            return;
        }
        resultSet.runRemainingContributors(parameters, (Consumer)new Consumer<CompletionResult>(){

            public void consume(CompletionResult result) {
                String qName;
                Object obj = result.getLookupElement().getObject();
                if (obj instanceof PsiClass && (qName = ((PsiClass)obj).getQualifiedName()) != null && !AndroidJavaCompletionContributor.isAllowedInAndroid(qName)) {
                    return;
                }
                resultSet.passResult(result);
            }
        });
    }

    private static boolean isAllowedInAndroid(@NotNull String qName) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "org/jetbrains/android/AndroidJavaCompletionContributor", "isAllowedInAndroid"));
        }
        for (String aPackage : EXCLUDED_PACKAGES) {
            if (!qName.startsWith(aPackage + ".")) continue;
            return false;
        }
        return true;
    }
}

