/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.propertyTable.renderers;

import com.android.tools.idea.rendering.ResourceHelper;
import com.intellij.android.designer.model.RadModelBuilder;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.renderers.AbstractResourceRenderer;
import com.intellij.designer.propertyTable.renderers.BooleanRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.dom.resources.ResourceElement;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceRenderer
extends AbstractResourceRenderer<String> {
    public static final String[] DIMENSIONS = new String[]{"dp", "sp", "pt", "px", "mm", "in"};
    private static final String ANDROID_PREFIX = "@android:";
    private BooleanRenderer myBooleanRenderer;
    private final Set<AttributeFormat> myFormats;

    public ResourceRenderer(Set<AttributeFormat> formats) {
        if (formats.contains((Object)AttributeFormat.Boolean)) {
            this.myBooleanRenderer = new BooleanRenderer();
        }
        this.myFormats = formats;
    }

    @NotNull
    public JComponent getComponent(@Nullable PropertiesContainer container, PropertyContext context, @Nullable Object object, boolean selected, boolean hasFocus) {
        String value = (String)object;
        if (this.myBooleanRenderer != null && (StringUtil.isEmpty((String)value) || "false".equals(value) || "true".equals(value))) {
            JComponent jComponent = this.myBooleanRenderer.getComponent(container, context, (Object)"true".equals(value), selected, hasFocus);
            if (jComponent == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/renderers/ResourceRenderer", "getComponent"));
            }
            return jComponent;
        }
        JComponent jComponent = super.getComponent(container, context, object, selected, hasFocus);
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/propertyTable/renderers/ResourceRenderer", "getComponent"));
        }
        return jComponent;
    }

    protected void formatValue(RadComponent component, String value) {
        if (!StringUtil.isEmpty((String)value)) {
            StringBuilder colorValue = new StringBuilder();
            boolean system = false;
            int prefix = -1;
            if (value.startsWith("#")) {
                prefix = 1;
            } else if (value.startsWith(ANDROID_PREFIX)) {
                prefix = ANDROID_PREFIX.length();
                system = true;
            } else if (value.startsWith("@")) {
                prefix = 1;
            }
            if (prefix != -1) {
                this.myColoredComponent.append(value.substring(0, prefix), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                this.myColoredComponent.append(value.substring(prefix), ResourceRenderer.textStyle(component, value, system, colorValue));
            } else if (this.myFormats.contains((Object)AttributeFormat.Dimension)) {
                if (value.length() > 3 && value.endsWith("dip")) {
                    this.myColoredComponent.append(value.substring(0, value.length() - 3));
                    this.myColoredComponent.append("dip", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                } else if (value.length() > 2) {
                    int index = value.length() - 2;
                    String dimension = value.substring(index);
                    if (ArrayUtil.indexOf((Object[])DIMENSIONS, (Object)dimension) != -1) {
                        this.myColoredComponent.append(value.substring(0, index));
                        this.myColoredComponent.append(dimension, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else {
                        this.myColoredComponent.append(value);
                    }
                } else {
                    this.myColoredComponent.append(value);
                }
            } else {
                this.myColoredComponent.append(value);
            }
            if (colorValue.length() > 0) {
                value = colorValue.toString();
            }
            if (this.myFormats.contains((Object)AttributeFormat.Color) && value.startsWith("#")) {
                try {
                    Color color = ResourceHelper.parseColor(value);
                    if (color != null) {
                        this.myColorIcon.setColor(color);
                        this.myColoredComponent.setIcon((Icon)this.myColorIcon);
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
    }

    private static SimpleTextAttributes textStyle(RadComponent component, String value, boolean system, StringBuilder colorValue) {
        if (value.startsWith("@") && !value.startsWith("@id/") && !value.startsWith("@+id/") && !value.startsWith("@android:id/")) {
            try {
                ResourceManager manager;
                AndroidFacet facet;
                int start = system ? ANDROID_PREFIX.length() : 1;
                int index = value.indexOf(47, start + 1);
                String type = value.substring(start, index);
                String name = value.substring(index + 1);
                Module module = RadModelBuilder.getModule(component);
                if (module != null && (facet = AndroidFacet.getInstance(module)) != null && (manager = facet.getResourceManager(system ? "android" : null)) != null) {
                    List<ResourceElement> resources = manager.findValueResources(type, name, false);
                    if ("color".equalsIgnoreCase(type) && !resources.isEmpty()) {
                        colorValue.append(resources.get(0).getRawText());
                    }
                    if (resources.isEmpty() && manager.findResourceFiles(type, name, false, new String[0]).isEmpty()) {
                        return SimpleTextAttributes.ERROR_ATTRIBUTES;
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return SimpleTextAttributes.REGULAR_ATTRIBUTES;
    }

    public void updateUI() {
        if (this.myBooleanRenderer != null) {
            SwingUtilities.updateComponentTreeUI((Component)this.myBooleanRenderer);
        }
        super.updateUI();
    }
}

