/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.android.designer.model;

import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.rendering.RenderResult;
import com.google.common.collect.Maps;
import com.intellij.android.designer.AndroidDesignerEditor;
import com.intellij.android.designer.designSurface.AndroidDesignerEditorPanel;
import com.intellij.android.designer.designSurface.RootView;
import com.intellij.android.designer.model.PropertyParser;
import com.intellij.android.designer.model.RadComponentOperations;
import com.intellij.android.designer.model.RadViewComponent;
import com.intellij.android.designer.model.ViewsMetaManager;
import com.intellij.designer.ModuleProvider;
import com.intellij.designer.componentTree.TreeComponentDecorator;
import com.intellij.designer.model.EmptyXmlTag;
import com.intellij.designer.model.MetaManager;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadModelBuilder {
    private static final String DESIGNER_KEY = "DESIGNER";
    public static final String ROOT_NODE_TAG = "<root>";
    private final MetaManager myMetaManager;
    private final PropertyParser myPropertyParser;
    private final Map<XmlTag, RadViewComponent> myTagToComponentMap;
    private final Map<XmlTag, RadViewComponent> myMergeComponentMap;
    private RootView myNativeComponent;
    private AndroidDesignerEditorPanel myDesigner;

    public RadModelBuilder(@NotNull AndroidDesignerEditorPanel designer, @NotNull PropertyParser propertyParser) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/android/designer/model/RadModelBuilder", "<init>"));
        }
        if (propertyParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyParser", "com/intellij/android/designer/model/RadModelBuilder", "<init>"));
        }
        this.myTagToComponentMap = Maps.newIdentityHashMap();
        this.myMergeComponentMap = Maps.newHashMap();
        this.myDesigner = designer;
        this.myMetaManager = ViewsMetaManager.getInstance(designer.getProject());
        this.myPropertyParser = propertyParser;
    }

    @Nullable
    public static RadViewComponent update(@NotNull AndroidDesignerEditorPanel designer, @NotNull RenderResult result, @Nullable RadViewComponent prevRoot, @NotNull RootView nativeComponent) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/android/designer/model/RadModelBuilder", "update"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/android/designer/model/RadModelBuilder", "update"));
        }
        if (nativeComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeComponent", "com/intellij/android/designer/model/RadModelBuilder", "update"));
        }
        PropertyParser propertyParser = designer.getPropertyParser(result);
        RadModelBuilder builder = new RadModelBuilder(designer, propertyParser);
        return builder.build(prevRoot, result, nativeComponent);
    }

    @NotNull
    public static AndroidDesignerEditorPanel getDesigner(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/RadModelBuilder", "getDesigner"));
        }
        AndroidDesignerEditorPanel designer = (AndroidDesignerEditorPanel)component.getRoot().getClientProperty(DESIGNER_KEY);
        if (designer == null) {
            if (component instanceof RadViewComponent) {
                Project project = ((RadViewComponent)component).getTag().getProject();
                for (FileEditor editor : FileEditorManager.getInstance((Project)project).getSelectedEditors()) {
                    if (!(editor instanceof AndroidDesignerEditor)) continue;
                    AndroidDesignerEditorPanel androidDesignerEditorPanel = (AndroidDesignerEditorPanel)((AndroidDesignerEditor)editor).getDesignerPanel();
                    if (androidDesignerEditorPanel == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/RadModelBuilder", "getDesigner"));
                    }
                    return androidDesignerEditorPanel;
                }
            }
            assert (false);
        }
        AndroidDesignerEditorPanel androidDesignerEditorPanel = designer;
        if (androidDesignerEditorPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/RadModelBuilder", "getDesigner"));
        }
        return androidDesignerEditorPanel;
    }

    @Nullable
    public static ModuleProvider getModuleProvider(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/RadModelBuilder", "getModuleProvider"));
        }
        return RadModelBuilder.getDesigner(component);
    }

    @Nullable
    public static Module getModule(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/RadModelBuilder", "getModule"));
        }
        ModuleProvider provider = RadModelBuilder.getModuleProvider(component);
        return provider != null ? provider.getModule() : null;
    }

    @Nullable
    public static Project getProject(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/RadModelBuilder", "getProject"));
        }
        ModuleProvider provider = RadModelBuilder.getModuleProvider(component);
        return provider != null ? provider.getProject() : null;
    }

    @NotNull
    public static XmlFile getXmlFile(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/RadModelBuilder", "getXmlFile"));
        }
        XmlFile xmlFile = RadModelBuilder.getDesigner(component).getXmlFile();
        if (xmlFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/android/designer/model/RadModelBuilder", "getXmlFile"));
        }
        return xmlFile;
    }

    @Nullable
    public static TreeComponentDecorator getTreeDecorator(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/RadModelBuilder", "getTreeDecorator"));
        }
        return RadModelBuilder.getDesigner(component).getTreeDecorator();
    }

    @Nullable
    public static PropertyParser getPropertyParser(@NotNull RadComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/android/designer/model/RadModelBuilder", "getPropertyParser"));
        }
        return RadModelBuilder.getDesigner(component).getPropertyParser(null);
    }

    @Nullable
    public RadViewComponent build(@Nullable RadViewComponent prevRoot, @NotNull RenderResult result, @NotNull RootView nativeComponent) {
        boolean isMerge;
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/android/designer/model/RadModelBuilder", "build"));
        }
        if (nativeComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nativeComponent", "com/intellij/android/designer/model/RadModelBuilder", "build"));
        }
        this.myNativeComponent = nativeComponent;
        RadViewComponent root = prevRoot;
        XmlTag rootTag = this.myDesigner.getXmlFile().getRootTag();
        boolean bl = isMerge = rootTag != null && "merge".equals(rootTag.getName());
        if (root == null || isMerge != (root.getMetaModel() == this.myMetaManager.getModelByTag("merge"))) {
            try {
                root = this.createRoot(isMerge, rootTag);
                if (root == null) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        RenderSession session = result.getSession();
        assert (session != null);
        this.updateClientProperties(result, nativeComponent, root);
        this.initTagMap(root);
        root.getChildren().clear();
        this.updateHierarchy(root, session);
        this.updateRootBounds(root, session);
        return root;
    }

    protected void updateClientProperties(@NotNull RenderResult result, RootView nativeComponent, RadViewComponent root) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/android/designer/model/RadModelBuilder", "updateClientProperties"));
        }
        root.setNativeComponent(nativeComponent);
        root.setClientProperty("showIn", result.getIncludedWithin());
    }

    protected void updateRootBounds(RadViewComponent root, RenderSession session) {
        BufferedImage image = session.getImage();
        Rectangle bounds = new Rectangle(0, 0, image != null ? image.getWidth() : 0, image != null ? image.getHeight() : 0);
        for (RadComponent radComponent : root.getChildren()) {
            bounds = bounds.union(radComponent.getBounds());
        }
        root.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    protected void updateHierarchy(RadViewComponent root, RenderSession session) {
        this.myNativeComponent.clearEmptyRegions();
        List rootViews = session.getRootViews();
        if (rootViews != null) {
            for (ViewInfo info : rootViews) {
                this.updateHierarchy(root, info, 0, 0);
            }
        }
    }

    protected void initTagMap(@NotNull RadViewComponent root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/android/designer/model/RadModelBuilder", "initTagMap"));
        }
        this.myTagToComponentMap.clear();
        for (RadViewComponent component : RadViewComponent.getViewComponents(root.getChildren())) {
            RadModelBuilder.gatherTags(this.myTagToComponentMap, component);
        }
    }

    @Nullable
    protected RadViewComponent createRoot(boolean isMerge, @Nullable XmlTag rootTag) throws Exception {
        MetaModel rootModel = this.myMetaManager.getModelByTag(isMerge ? "merge" : ROOT_NODE_TAG);
        assert (rootModel != null);
        RadViewComponent root = RadComponentOperations.createComponent(rootTag, rootModel);
        root.setClientProperty(DESIGNER_KEY, this.myDesigner);
        this.myPropertyParser.load(root);
        return root;
    }

    private static void gatherTags(Map<XmlTag, RadViewComponent> map, RadViewComponent component) {
        XmlTag tag = component.getTag();
        if (tag != EmptyXmlTag.INSTANCE) {
            map.put(tag, component);
        }
        for (RadComponent child : component.getChildren()) {
            if (!(child instanceof RadViewComponent)) continue;
            RadModelBuilder.gatherTags(map, (RadViewComponent)child);
        }
    }

    @Nullable
    public RadViewComponent updateHierarchy(@Nullable RadViewComponent parent, ViewInfo view, int parentX, int parentY) {
        Object cookie = view.getCookie();
        RadViewComponent component = null;
        XmlTag tag = null;
        boolean isMerge = false;
        if (cookie instanceof XmlTag) {
            tag = (XmlTag)cookie;
        } else if (cookie instanceof MergeCookie) {
            isMerge = true;
            if ((cookie = ((MergeCookie)cookie).getCookie()) instanceof XmlTag && this.myMergeComponentMap.containsKey(tag = (XmlTag)cookie)) {
                int left = parentX + view.getLeft();
                int top = parentY + view.getTop();
                int width = view.getRight() - view.getLeft();
                int height = view.getBottom() - view.getTop();
                RadViewComponent radViewComponent = this.myMergeComponentMap.get(tag);
                radViewComponent.getBounds().add(new Rectangle(left, top, width, height));
                return null;
            }
        }
        if (tag != null) {
            boolean loadProperties;
            component = this.myTagToComponentMap.get(tag);
            if (component != null) {
                if (!tag.isValid()) {
                    component = null;
                } else {
                    ApplicationManager.getApplication().assertReadAccessAllowed();
                    MetaModel modelByTag = this.myMetaManager.getModelByTag(tag.getName());
                    if (modelByTag != null && modelByTag != component.getMetaModel()) {
                        component = null;
                    }
                }
            }
            if (component == null) {
                String tagName = tag.isValid() ? tag.getName() : "view";
                try {
                    MetaModel metaModel = this.myMetaManager.getModelByTag(tagName);
                    if (metaModel == null) {
                        metaModel = this.myMetaManager.getModelByTag("view");
                        assert (metaModel != null);
                    }
                    component = RadComponentOperations.createComponent(tag, metaModel);
                    loadProperties = true;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            } else {
                component.getChildren().clear();
                this.myTagToComponentMap.remove(tag);
                loadProperties = component.getParent() != parent;
            }
            component.setViewInfo(view);
            component.setNativeComponent(this.myNativeComponent);
            int left = parentX + view.getLeft();
            int top = parentY + view.getTop();
            int width = view.getRight() - view.getLeft();
            int height = view.getBottom() - view.getTop();
            if (width < 5 && height < 5) {
                this.myNativeComponent.addEmptyRegion(left, top, 14, 14);
            }
            component.setBounds(left, top, Math.max(width, 14), Math.max(height, 14));
            if (parent != null && parent != component) {
                parent.add((RadComponent)component, null);
                if (loadProperties) {
                    try {
                        this.myPropertyParser.load(component);
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
                if (isMerge) {
                    this.myMergeComponentMap.put(tag, component);
                }
            }
        }
        if (component != null) {
            parent = component;
        }
        parentX += view.getLeft();
        parentY += view.getTop();
        for (ViewInfo child : view.getChildren()) {
            this.updateHierarchy(parent, child, parentX, parentY);
        }
        return component;
    }
}

