/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.swing.layoutlib;

import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.DomPullParser;
import com.android.tools.idea.rendering.LayoutPullParserFactory;
import com.android.tools.swing.layoutlib.GraphicsLayoutRenderer;
import com.android.tools.swing.layoutlib.InitializationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class AndroidThemePreviewPanel
extends JComponent {
    private static final Logger LOG = Logger.getInstance((String)AndroidThemePreviewPanel.class.getName());
    private static final String THEME_PREVIEW_LAYOUT = "/themeEditor/sample_layout.xml";
    private final AndroidFacet myFacet;
    private final PsiFile myPsiFile;
    private GraphicsLayoutRenderer myGraphicsLayoutRenderer;
    private ILayoutPullParser myParser;

    public AndroidThemePreviewPanel(PsiFile psiFile, Configuration configuration) throws IOException, SAXException {
        this.myPsiFile = psiFile;
        this.myFacet = AndroidFacet.getInstance((PsiElement)this.myPsiFile);
        Document document = DomPullParser.createNewDocumentBuilder().parse(LayoutPullParserFactory.class.getResourceAsStream(THEME_PREVIEW_LAYOUT));
        this.myParser = new DomPullParser(document.getDocumentElement());
        this.updateConfiguration(configuration);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.myGraphicsLayoutRenderer != null) {
            this.myGraphicsLayoutRenderer.setSize(this.getSize());
        }
    }

    public void updateConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/swing/layoutlib/AndroidThemePreviewPanel", "updateConfiguration"));
        }
        try {
            this.myGraphicsLayoutRenderer = GraphicsLayoutRenderer.create(this.myPsiFile, configuration, this.myParser);
        }
        catch (InitializationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.myGraphicsLayoutRenderer != null) {
            this.myGraphicsLayoutRenderer.render((Graphics2D)graphics);
        }
    }
}

