/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.wizard.DynamicWizard;
import com.android.tools.idea.wizard.DynamicWizardPath;
import com.android.tools.idea.wizard.ScopedDataBinder;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.WizardStepHeaderPanel;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicWizardStep
extends ScopedDataBinder
implements Step {
    private static final Logger LOG = Logger.getInstance(DynamicWizardStep.class);
    protected DynamicWizardPath myPath;
    private JPanel myRootPane;
    private boolean myUpdateInProgress;
    private boolean myIsValid;
    private boolean myInitialized;
    protected WizardStepHeaderPanel myHeader;
    @Nullable
    MergingUpdateQueue myUpdateQueue;

    public DynamicWizardStep() {
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, null, this);
    }

    @Deprecated
    @Nullable
    public static JPanel createWizardStepHeader(JBColor headerColor, Icon icon, String title) {
        return null;
    }

    public final void attachToPath(@NotNull DynamicWizardPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/wizard/DynamicWizardStep", "attachToPath"));
        }
        this.myPath = path;
        Map<String, Object> myCurrentValues = this.myState.flatten();
        this.myState = new ScopedStateStore(ScopedStateStore.Scope.STEP, this.myPath.getState(), this);
        for (String keyName : myCurrentValues.keySet()) {
            this.myState.put(this.myState.createKey(keyName, Object.class), myCurrentValues.get(keyName));
        }
        this.myUpdateQueue = path.getUpdateQueue();
    }

    public abstract void init();

    @Nullable
    protected final Project getProject() {
        return this.myPath != null ? this.myPath.getProject() : null;
    }

    @Nullable
    protected final Module getModule() {
        return this.myPath != null ? this.myPath.getModule() : null;
    }

    @Nullable
    protected final DynamicWizard getWizard() {
        if (this.myPath != null) {
            return this.myPath.getWizard();
        }
        return null;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Deprecated
    public final void _init() {
        this.onEnterStep();
    }

    @Deprecated
    public final void _commit(boolean finishChosen) throws CommitStepException {
        this.commitStep();
    }

    public void onEnterStep() {
        if (!this.myInitialized) {
            this.init();
            this.myInitialized = true;
        }
        this.invokeUpdate(null);
    }

    public boolean commitStep() {
        return true;
    }

    public boolean isStepVisible() {
        return true;
    }

    @Override
    public <T> void invokeUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (this.myUpdateQueue != null) {
            this.myUpdateQueue.queue((Update)new StepUpdate(changedKey));
        } else {
            this.performUpdate(changedKey);
        }
    }

    private <T> void performUpdate(@Nullable ScopedStateStore.Key<T> changedKey) {
        if (!this.myInitialized) {
            return;
        }
        super.invokeUpdate(changedKey);
        this.update();
        if (this.myPath != null) {
            this.myPath.updateButtons();
        }
    }

    private void update() {
        if (!this.myUpdateInProgress) {
            this.myUpdateInProgress = true;
            this.updateModelFromUI();
            this.deriveValues(this.myState.getRecentUpdates());
            this.myIsValid = this.validate();
            this.myState.clearRecentUpdates();
            this.myUpdateInProgress = false;
        }
    }

    public void updateModelFromUI() {
    }

    public void deriveValues(Set<ScopedStateStore.Key> modified) {
    }

    public boolean validate() {
        return true;
    }

    public boolean canGoNext() {
        return this.myIsValid;
    }

    public boolean canGoPrevious() {
        return true;
    }

    public final void setErrorHtml(@Nullable String errorMessage) {
        JLabel label;
        if (errorMessage != null && !errorMessage.startsWith("<html>")) {
            errorMessage = "<html>" + errorMessage + "</html>";
        }
        if ((label = this.getMessageLabel()) != null) {
            label.setText(errorMessage);
        } else {
            LOG.debug("Message was displayed on a step without error label", (Throwable)new Exception());
        }
    }

    public String toString() {
        return this.getStepName();
    }

    @NotNull
    public final JComponent getComponent() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myRootPane == null) {
            this.myRootPane = new JPanel(new BorderLayout());
            this.myHeader = WizardStepHeaderPanel.create(this.getHeaderColor(), this.getWizardIcon(), this.getStepIcon(), this.getStepTitle(), this.getStepDescription());
            this.myRootPane.add((Component)this.myHeader, "North");
            this.myRootPane.add(this.createStepBody(), "Center");
        }
        JPanel jPanel = this.myRootPane;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStep", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    protected Color getHeaderColor() {
        JBColor jBColor = WizardConstants.ANDROID_NPW_HEADER_COLOR;
        if (jBColor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStep", "getHeaderColor"));
        }
        return jBColor;
    }

    @Nullable
    protected Icon getStepIcon() {
        return null;
    }

    @NotNull
    protected abstract Component createStepBody();

    @Nullable
    protected Icon getWizardIcon() {
        DynamicWizard wizard = this.getWizard();
        return wizard == null ? null : wizard.getIcon();
    }

    @Nullable
    public abstract JLabel getMessageLabel();

    @NotNull
    public abstract String getStepName();

    @NotNull
    protected abstract String getStepTitle();

    @Nullable
    protected abstract String getStepDescription();

    private class StepUpdate
    extends Update {
        private final ScopedStateStore.Key<?> myChangedKey;

        public StepUpdate(ScopedStateStore.Key<?> changedKey) {
            super((Object)DynamicWizardStep.this);
            this.myChangedKey = changedKey;
        }

        @NotNull
        public Object[] getEqualityObjects() {
            Object[] objectArray = new Object[]{DynamicWizardStep.this, this.myChangedKey};
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/DynamicWizardStep$StepUpdate", "getEqualityObjects"));
            }
            return objectArray;
        }

        public void run() {
            DynamicWizardStep.this.performUpdate(this.myChangedKey);
        }
    }
}

