/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard;

import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.wizard.CreateModuleTemplate;
import com.android.tools.idea.wizard.FormFactorUtils;
import com.android.tools.idea.wizard.ModuleTemplate;
import com.android.tools.idea.wizard.ModuleTemplateProvider;
import com.android.tools.idea.wizard.WizardConstants;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class AndroidModuleTemplatesProvider
implements ModuleTemplateProvider {
    @Override
    @NotNull
    public Iterable<ModuleTemplate> getModuleTemplates() {
        TemplateManager manager = TemplateManager.getInstance();
        List<File> applicationTemplates = manager.getTemplatesInCategory("Application");
        ArrayList moduleTemplates = Lists.newArrayList();
        for (File templateFile : applicationTemplates) {
            FormFactorUtils.FormFactor formFactor;
            TemplateMetadata metadata = manager.getTemplate(templateFile);
            if (metadata == null || metadata.getFormFactor() == null || (formFactor = FormFactorUtils.FormFactor.get(metadata.getFormFactor())) == null) continue;
            moduleTemplates.addAll(AndroidModuleTemplatesProvider.getModuleTypes(metadata, formFactor));
        }
        ArrayList arrayList = moduleTemplates;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AndroidModuleTemplatesProvider", "getModuleTemplates"));
        }
        return arrayList;
    }

    @NotNull
    private static Collection<ModuleTemplate> getModuleTypes(@NotNull TemplateMetadata metadata, @NotNull FormFactorUtils.FormFactor formFactor) {
        if (metadata == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metadata", "com/android/tools/idea/wizard/AndroidModuleTemplatesProvider", "getModuleTypes"));
        }
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/wizard/AndroidModuleTemplatesProvider", "getModuleTypes"));
        }
        if (formFactor.equals(FormFactorUtils.FormFactor.MOBILE)) {
            CreateModuleTemplate androidApplication = new CreateModuleTemplate(metadata, formFactor, formFactor.toString() + " Application", true, true);
            androidApplication.setCustomValue(WizardConstants.IS_LIBRARY_KEY, false);
            CreateModuleTemplate androidLibrary = new CreateModuleTemplate(metadata, formFactor, "Android Library", true, false);
            androidLibrary.setCustomValue(WizardConstants.IS_LIBRARY_KEY, true);
            ImmutableSet immutableSet = ImmutableSet.of((Object)androidApplication, (Object)androidLibrary);
            if (immutableSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AndroidModuleTemplatesProvider", "getModuleTypes"));
            }
            return immutableSet;
        }
        ImmutableSet immutableSet = ImmutableSet.of((Object)new CreateModuleTemplate(metadata, formFactor, metadata.getTitle(), true, true));
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/wizard/AndroidModuleTemplatesProvider", "getModuleTypes"));
        }
        return immutableSet;
    }
}

