/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.tools.idea.welcome.FirstRunWizardHost;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.ref.WeakReference;
import javax.swing.JFrame;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WelcomeScreenWindowListener {
    public static WindowListener install(@NotNull JFrame frame, @NotNull FirstRunWizardHost host) {
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/android/tools/idea/welcome/WelcomeScreenWindowListener", "install"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/welcome/WelcomeScreenWindowListener", "install"));
        }
        WindowListener ideaListener = WelcomeScreenWindowListener.removeCloseListener(frame);
        DirectListener ourListener = ideaListener != null ? new DelegatingListener(host, ideaListener) : new DirectListener(host);
        frame.addWindowListener(ourListener);
        return ourListener;
    }

    @Nullable
    private static WindowListener removeCloseListener(@NotNull JFrame frame) {
        WindowListener[] listeners;
        if (frame == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/android/tools/idea/welcome/WelcomeScreenWindowListener", "removeCloseListener"));
        }
        for (WindowListener listener : listeners = (WindowListener[])frame.getListeners(WindowListener.class)) {
            if (!listener.getClass().getName().startsWith(WelcomeFrame.class.getName())) continue;
            frame.removeWindowListener(listener);
            return listener;
        }
        return null;
    }

    @Contract(value="null->false")
    private static boolean handleClose(@Nullable FirstRunWizardHost host) {
        if (host != null && host.isActive()) {
            host.cancel();
            return true;
        }
        return false;
    }

    private static class DirectListener
    extends WindowAdapter {
        private final WeakReference<FirstRunWizardHost> myHostReference;

        public DirectListener(@NotNull FirstRunWizardHost host) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/welcome/WelcomeScreenWindowListener$DirectListener", "<init>"));
            }
            this.myHostReference = new WeakReference<FirstRunWizardHost>(host);
        }

        @Nullable
        protected final FirstRunWizardHost getHost() {
            return (FirstRunWizardHost)this.myHostReference.get();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (!WelcomeScreenWindowListener.handleClose(this.getHost())) {
                e.getWindow().removeWindowListener(this);
            }
        }
    }

    private static class DelegatingListener
    extends DirectListener {
        @NotNull
        private final WindowListener myIdeaListener;

        public DelegatingListener(@NotNull FirstRunWizardHost host, @NotNull WindowListener ideaListener) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/android/tools/idea/welcome/WelcomeScreenWindowListener$DelegatingListener", "<init>"));
            }
            if (ideaListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideaListener", "com/android/tools/idea/welcome/WelcomeScreenWindowListener$DelegatingListener", "<init>"));
            }
            super(host);
            this.myIdeaListener = ideaListener;
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.myIdeaListener.windowOpened(e);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.myIdeaListener.windowClosed(e);
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.myIdeaListener.windowIconified(e);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (!WelcomeScreenWindowListener.handleClose(this.getHost())) {
                Window window = e.getWindow();
                window.removeWindowListener(this);
                window.addWindowListener(this.myIdeaListener);
                this.myIdeaListener.windowClosing(e);
            }
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.myIdeaListener.windowDeiconified(e);
        }

        @Override
        public void windowActivated(WindowEvent e) {
            this.myIdeaListener.windowActivated(e);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.myIdeaListener.windowDeactivated(e);
        }
    }
}

