/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.ProgressStep;
import com.android.tools.idea.welcome.WelcomeUIUtils;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InstallableComponent {
    @NotNull
    private final String myName;
    private final long mySize;
    private final String myDescription;
    private final ScopedStateStore.Key<Boolean> myKey;

    /*
     * WARNING - void declaration
     */
    public InstallableComponent(@NotNull String name, long size, @NotNull String description, ScopedStateStore.Key<Boolean> key) {
        void key2;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/welcome/InstallableComponent", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/android/tools/idea/welcome/InstallableComponent", "<init>"));
        }
        this.myName = name;
        this.mySize = size;
        this.myDescription = description;
        this.myKey = key2;
    }

    public boolean isOptional() {
        return true;
    }

    public long getSize() {
        return this.mySize;
    }

    public String getDescription() {
        return this.myDescription;
    }

    @Nullable
    public InstallableComponent getParent() {
        return null;
    }

    public ScopedStateStore.Key<Boolean> getKey() {
        return this.myKey;
    }

    public String toString() {
        return this.myName;
    }

    public String getLabel() {
        if (this.mySize == 0L) {
            return this.myName;
        }
        String sizeLabel = WelcomeUIUtils.getSizeLabel(this.mySize);
        return String.format("%s \u2013 (%s)", this.myName, sizeLabel);
    }

    @NotNull
    public abstract Collection<IPkgDesc> getRequiredSdkPackages(@Nullable Multimap<PkgType, RemotePkgInfo> var1);

    public abstract void init(@NotNull ScopedStateStore var1, @NotNull ProgressStep var2);

    public abstract DynamicWizardStep[] createSteps();

    public abstract void configure(@NotNull InstallContext var1, @NotNull File var2);
}

