/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.sdklib.SdkManager;
import com.android.sdklib.internal.repository.updater.SdkUpdaterNoWindow;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.sdklib.repository.local.Update;
import com.android.sdklib.repository.local.UpdateResult;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.InstallableComponent;
import com.android.tools.idea.welcome.WizardException;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComponentInstaller {
    private final Collection<? extends InstallableComponent> myComponents;
    @Nullable
    private final Multimap<PkgType, RemotePkgInfo> myRemotePackages;

    public ComponentInstaller(@NotNull Collection<? extends InstallableComponent> components, @Nullable Multimap<PkgType, RemotePkgInfo> remotePackages) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "com/android/tools/idea/welcome/ComponentInstaller", "<init>"));
        }
        this.myComponents = components;
        this.myRemotePackages = remotePackages;
    }

    private static Set<String> getPackageIds(Collection<LocalPkgInfo> pkgs) {
        HashSet toUpdate = Sets.newHashSet();
        for (LocalPkgInfo localPkgInfo : pkgs) {
            toUpdate.add(localPkgInfo.getDesc().getInstallId());
        }
        return toUpdate;
    }

    private static List<LocalPkgInfo> getInstalledPackages(@NotNull SdkManager manager, @NotNull Set<String> toInstall) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/welcome/ComponentInstaller", "getInstalledPackages"));
        }
        if (toInstall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toInstall", "com/android/tools/idea/welcome/ComponentInstaller", "getInstalledPackages"));
        }
        LocalSdk localSdk = manager.getLocalSdk();
        LocalPkgInfo[] installed = localSdk.getPkgsInfos(EnumSet.allOf(PkgType.class));
        ArrayList toCheckForUpdate = Lists.newArrayListWithCapacity((int)installed.length);
        for (LocalPkgInfo info : installed) {
            if (!toInstall.contains(info.getDesc().getInstallId())) continue;
            toCheckForUpdate.add(info);
        }
        return toCheckForUpdate;
    }

    private Collection<LocalPkgInfo> getOldPackages(Collection<LocalPkgInfo> installed) {
        if (this.myRemotePackages != null) {
            LocalPkgInfo[] packagesArray = (LocalPkgInfo[])ArrayUtil.toObjectArray(installed, LocalPkgInfo.class);
            UpdateResult result = Update.computeUpdates((LocalPkgInfo[])packagesArray, this.myRemotePackages);
            return result.getUpdatedPkgs();
        }
        return installed;
    }

    private Set<String> getRequiredPackages() {
        HashSet packages = Sets.newHashSet();
        for (InstallableComponent installableComponent : this.myComponents) {
            for (IPkgDesc pkg : installableComponent.getRequiredSdkPackages(this.myRemotePackages)) {
                if (pkg == null) continue;
                packages.add(pkg.getInstallId());
            }
        }
        return packages;
    }

    public ArrayList<String> getPackagesToInstall(@Nullable SdkManager manager) {
        Set<String> toInstall = this.getRequiredPackages();
        if (manager == null) {
            return Lists.newArrayList(toInstall);
        }
        List<LocalPkgInfo> installed = ComponentInstaller.getInstalledPackages(manager, toInstall);
        if (!installed.isEmpty()) {
            toInstall.removeAll(ComponentInstaller.getPackageIds(installed));
            toInstall.addAll(ComponentInstaller.getPackageIds(this.getOldPackages(installed)));
        }
        return Lists.newArrayList(toInstall);
    }

    public void installPackages(@NotNull SdkManager manager, @NotNull ArrayList<String> packages, ILogger logger) throws WizardException {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/welcome/ComponentInstaller", "installPackages"));
        }
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/welcome/ComponentInstaller", "installPackages"));
        }
        SdkUpdaterNoWindow updater = new SdkUpdaterNoWindow(manager.getLocation(), manager, logger, false, true, null, null);
        updater.updateAll(packages, true, false, null, false);
    }
}

