/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome;

import com.android.ide.common.repository.SdkMavenRepository;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.welcome.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.InstallComponentsPath;
import com.android.tools.idea.welcome.InstallContext;
import com.android.tools.idea.welcome.InstallableComponent;
import com.android.tools.idea.welcome.ProgressStep;
import com.android.tools.idea.wizard.DynamicWizardStep;
import com.android.tools.idea.wizard.ScopedStateStore;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidSdk
extends InstallableComponent {
    public static final long SIZE = 2300L * Storage.Unit.MiB.getNumberOfBytes();
    private static final ScopedStateStore.Key<Boolean> KEY_INSTALL_SDK = ScopedStateStore.createKey("download.sdk", ScopedStateStore.Scope.PATH, Boolean.class);

    public AndroidSdk() {
        super("Android SDK", SIZE, "The collection of Android platform APIs, tools and utilities that enables you to debug, profile, and compile your apps.\n\nThe setup wizard will update your current Android SDK installation (if necessary) or install a new version.", KEY_INSTALL_SDK);
    }

    private static Collection<IPkgDesc> createAll(PkgDesc.Builder ... builders) {
        ArrayList list = Lists.newArrayListWithCapacity((int)(builders.length + SdkMavenRepository.values().length));
        for (PkgDesc.Builder builder : builders) {
            list.add(builder.create());
        }
        return list;
    }

    @NotNull
    private static FullRevision getLatestCompatibleBuildToolsRevision(@Nullable Multimap<PkgType, RemotePkgInfo> packages) {
        FullRevision revision = FirstRunWizardDefaults.MIN_BUILD_TOOLS_REVSION;
        if (packages != null) {
            Collection tools = packages.get((Object)PkgType.PKG_BUILD_TOOLS);
            for (RemotePkgInfo tool : tools) {
                FullRevision fullRevision = tool.getDesc().getFullRevision();
                if (fullRevision == null || fullRevision.getMajor() != FirstRunWizardDefaults.MIN_BUILD_TOOLS_REVSION.getMajor() || fullRevision.compareTo(revision) <= 0) continue;
                revision = fullRevision;
            }
        }
        FullRevision fullRevision = revision;
        if (fullRevision == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/AndroidSdk", "getLatestCompatibleBuildToolsRevision"));
        }
        return fullRevision;
    }

    @Override
    @NotNull
    public Collection<IPkgDesc> getRequiredSdkPackages(@Nullable Multimap<PkgType, RemotePkgInfo> remotePackages) {
        MajorRevision unspecifiedRevision = new MajorRevision(FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder androidSdkTools = PkgDesc.Builder.newTool((FullRevision)FullRevision.NOT_SPECIFIED, (FullRevision)FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder androidSdkPlatformTools = PkgDesc.Builder.newPlatformTool((FullRevision)FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder androidSdkBuildTools = PkgDesc.Builder.newBuildTool((FullRevision)AndroidSdk.getLatestCompatibleBuildToolsRevision(remotePackages));
        PkgDesc.Builder platform = PkgDesc.Builder.newPlatform((AndroidVersion)InstallComponentsPath.LATEST_ANDROID_VERSION, (MajorRevision)unspecifiedRevision, (FullRevision)FullRevision.NOT_SPECIFIED);
        PkgDesc.Builder platformSources = PkgDesc.Builder.newSource((AndroidVersion)InstallComponentsPath.LATEST_ANDROID_VERSION, (MajorRevision)unspecifiedRevision);
        Collection<IPkgDesc> packages = AndroidSdk.createAll(androidSdkTools, androidSdkPlatformTools, androidSdkBuildTools, platform, platformSources);
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            packages.add(repository.getPackageDescription());
        }
        Collection<IPkgDesc> collection = packages;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/AndroidSdk", "getRequiredSdkPackages"));
        }
        return collection;
    }

    @Override
    public void init(@NotNull ScopedStateStore state, @NotNull ProgressStep progressStep) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/welcome/AndroidSdk", "init"));
        }
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/AndroidSdk", "init"));
        }
        state.put(KEY_INSTALL_SDK, true);
    }

    @Override
    public DynamicWizardStep[] createSteps() {
        return new DynamicWizardStep[0];
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull File sdk) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/AndroidSdk", "configure"));
        }
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/android/tools/idea/welcome/AndroidSdk", "configure"));
        }
    }

    @Override
    public boolean isOptional() {
        return false;
    }
}

