/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapsAwareTextHelper {
    private static final Graphics2D ourGraphics = new BufferedImage(1, 1, 2).createGraphics();
    private static final String LINE_BREAK_MARKER = "___LINE_BREAK___";
    @NotNull
    private final DimensionCalculator myDimensionCalculator;

    public WrapsAwareTextHelper(final @NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/ui/WrapsAwareTextHelper", "<init>"));
        }
        this(new DimensionCalculator(){

            @Override
            public void calculate(@NotNull String inText, @NotNull Font inFont, @NotNull Dimension outDimension) {
                if (inText == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inText", "com/android/tools/idea/ui/WrapsAwareTextHelper$1", "calculate"));
                }
                if (inFont == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inFont", "com/android/tools/idea/ui/WrapsAwareTextHelper$1", "calculate"));
                }
                if (outDimension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outDimension", "com/android/tools/idea/ui/WrapsAwareTextHelper$1", "calculate"));
                }
                FontMetrics metrics = component.getFontMetrics(inFont);
                if (UIUtil.isRetina() && SystemInfo.isOracleJvm) {
                    this.stringDimension(inText, inFont, outDimension);
                } else {
                    outDimension.width = metrics.stringWidth(inText);
                    outDimension.height = metrics.getHeight();
                }
            }

            private void stringDimension(@NotNull String text, @NotNull Font font, @NotNull Dimension resultHolder) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/ui/WrapsAwareTextHelper$1", "stringDimension"));
                }
                if (font == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/idea/ui/WrapsAwareTextHelper$1", "stringDimension"));
                }
                if (resultHolder == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultHolder", "com/android/tools/idea/ui/WrapsAwareTextHelper$1", "stringDimension"));
                }
                GraphicsUtil.setupAntialiasing((Graphics)ourGraphics, (boolean)true, (boolean)true);
                FontMetrics metrics = ourGraphics.getFontMetrics(font);
                Rectangle2D bounds = metrics.getStringBounds(text, 0, text.length(), (Graphics)ourGraphics);
                resultHolder.width = (int)bounds.getWidth();
                resultHolder.height = (int)bounds.getHeight();
            }
        });
    }

    public WrapsAwareTextHelper(@NotNull DimensionCalculator dimensionCalculator) {
        if (dimensionCalculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dimensionCalculator", "com/android/tools/idea/ui/WrapsAwareTextHelper", "<init>"));
        }
        this.myDimensionCalculator = dimensionCalculator;
    }

    public static void appendLineBreak(@NotNull List<String> textFragments) {
        if (textFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFragments", "com/android/tools/idea/ui/WrapsAwareTextHelper", "appendLineBreak"));
        }
        textFragments.add(LINE_BREAK_MARKER);
    }

    public void wrap(@NotNull List<String> inTextFragments, @NotNull List<SimpleTextAttributes> inTextAttributes, @NotNull Font font, @NotNull TIntIntHashMap inMinimumWidths, int inWidthLimit, @NotNull Dimension outTextDimension, @NotNull TIntObjectHashMap<TIntArrayList> outBreakOffsets, @NotNull TIntIntHashMap outLineHeights) {
        if (inTextFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inTextFragments", "com/android/tools/idea/ui/WrapsAwareTextHelper", "wrap"));
        }
        if (inTextAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inTextAttributes", "com/android/tools/idea/ui/WrapsAwareTextHelper", "wrap"));
        }
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/idea/ui/WrapsAwareTextHelper", "wrap"));
        }
        if (inMinimumWidths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inMinimumWidths", "com/android/tools/idea/ui/WrapsAwareTextHelper", "wrap"));
        }
        if (outTextDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outTextDimension", "com/android/tools/idea/ui/WrapsAwareTextHelper", "wrap"));
        }
        if (outBreakOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outBreakOffsets", "com/android/tools/idea/ui/WrapsAwareTextHelper", "wrap"));
        }
        if (outLineHeights == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outLineHeights", "com/android/tools/idea/ui/WrapsAwareTextHelper", "wrap"));
        }
        WrapContext context = new WrapContext(inTextFragments, outBreakOffsets, outLineHeights, font, inWidthLimit);
        for (int i = 0; i < inTextAttributes.size(); ++i) {
            String text = inTextFragments.get(i);
            if (LINE_BREAK_MARKER.equals(text)) {
                context.processTextLineBreak();
                continue;
            }
            context.apply(inTextAttributes.get(i));
            this.myDimensionCalculator.calculate(text, context.font, context.tmp);
            int minWidth = inMinimumWidths.get(i);
            if (minWidth > 0 && minWidth > context.tmp.width) {
                context.processFixedFragmentWidth(minWidth, i);
                continue;
            }
            context.processRegularFragment(i, 0);
        }
        outTextDimension.width = Math.max(context.textDimension.width, context.currentLineDimension.width);
        outTextDimension.height = context.textDimension.height + context.currentLineDimension.height;
        outLineHeights.put(context.line, context.currentLineDimension.height);
    }

    public int mapFragment(@NotNull List<String> textFragments, @NotNull List<SimpleTextAttributes> textAttributes, @NotNull TIntIntHashMap minimumWidths, @NotNull TIntObjectHashMap<TIntArrayList> breakOffsets, @NotNull TIntIntHashMap lineHeights, @NotNull Font font, int x, int y) {
        if (textFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFragments", "com/android/tools/idea/ui/WrapsAwareTextHelper", "mapFragment"));
        }
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributes", "com/android/tools/idea/ui/WrapsAwareTextHelper", "mapFragment"));
        }
        if (minimumWidths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumWidths", "com/android/tools/idea/ui/WrapsAwareTextHelper", "mapFragment"));
        }
        if (breakOffsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakOffsets", "com/android/tools/idea/ui/WrapsAwareTextHelper", "mapFragment"));
        }
        if (lineHeights == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineHeights", "com/android/tools/idea/ui/WrapsAwareTextHelper", "mapFragment"));
        }
        if (font == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/idea/ui/WrapsAwareTextHelper", "mapFragment"));
        }
        if (lineHeights.isEmpty()) {
            return -1;
        }
        MapContext context = new MapContext(textFragments, breakOffsets, lineHeights, font, minimumWidths, x, y);
        for (int i = 0; i < textFragments.size(); ++i) {
            String text = textFragments.get(i);
            if (LINE_BREAK_MARKER.equals(text)) {
                boolean canContinue = context.onLineBreak();
                if (canContinue) continue;
                return -1;
            }
            context.apply(textAttributes.get(i));
            Boolean match = context.processTextFragment(i, 0);
            if (match == Boolean.TRUE) {
                return i;
            }
            if (match != Boolean.FALSE) continue;
            return -1;
        }
        return -1;
    }

    static {
        GraphicsUtil.setupFractionalMetrics((Graphics)ourGraphics);
        GraphicsUtil.setupAntialiasing((Graphics)ourGraphics, (boolean)true, (boolean)true);
    }

    private class MapContext
    extends CommonContext {
        @NotNull
        private final TIntIntHashMap myMinimumWidths;
        private final int myTargetX;
        private final int myTargetY;
        private int myLineStartY;
        private int myLineEndY;
        private int myLineX;

        MapContext(@NotNull List<String> textFragments, @NotNull TIntObjectHashMap<TIntArrayList> breakOffsets, @NotNull TIntIntHashMap lineHeights, @NotNull Font font, TIntIntHashMap minimumWidths, int targetX, int targetY) {
            if (textFragments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFragments", "com/android/tools/idea/ui/WrapsAwareTextHelper$MapContext", "<init>"));
            }
            if (breakOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakOffsets", "com/android/tools/idea/ui/WrapsAwareTextHelper$MapContext", "<init>"));
            }
            if (lineHeights == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineHeights", "com/android/tools/idea/ui/WrapsAwareTextHelper$MapContext", "<init>"));
            }
            if (font == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/idea/ui/WrapsAwareTextHelper$MapContext", "<init>"));
            }
            if (minimumWidths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumWidths", "com/android/tools/idea/ui/WrapsAwareTextHelper$MapContext", "<init>"));
            }
            super(textFragments, breakOffsets, lineHeights, font);
            this.myMinimumWidths = minimumWidths;
            this.myTargetX = targetX;
            this.myTargetY = targetY;
            this.myLineEndY = lineHeights.get(0);
        }

        public boolean onLineBreak() {
            int lineHeight;
            if ((lineHeight = this.myLineHeights.get(++this.line)) <= 0) {
                return false;
            }
            this.myLineStartY = this.myLineEndY;
            this.myLineEndY += lineHeight;
            this.myLineX = 0;
            return this.myTargetY >= this.myLineStartY;
        }

        @Nullable
        public Boolean processTextFragment(int textFragmentIndex, int fragmentStartOffset) {
            String wholeFragmentText = (String)this.myTextFragments.get(textFragmentIndex);
            if (this.myTargetY >= this.myLineStartY && this.myTargetY <= this.myLineEndY) {
                int endOffset = this.findFragmentPartEndOffset(textFragmentIndex, fragmentStartOffset);
                if (endOffset < 0) {
                    return null;
                }
                String textToProcess = wholeFragmentText.substring(fragmentStartOffset, endOffset);
                WrapsAwareTextHelper.this.myDimensionCalculator.calculate(textToProcess, this.font, this.tmp);
                int minimumWidth = this.myMinimumWidths.get(textFragmentIndex);
                if (minimumWidth <= 0 || minimumWidth <= this.tmp.width || fragmentStartOffset > 0 || endOffset < wholeFragmentText.length()) {
                    minimumWidth = -1;
                }
                if (this.myTargetX < this.myLineX + Math.max(this.tmp.width, minimumWidth)) {
                    return this.myTargetX < this.myLineX + this.tmp.width;
                }
                if (endOffset == wholeFragmentText.length()) {
                    this.myLineX += Math.max(this.tmp.width, minimumWidth);
                    return null;
                }
                return false;
            }
            int endOffset = this.findFragmentPartEndOffset(textFragmentIndex, fragmentStartOffset);
            if (endOffset < 0) {
                return null;
            }
            if (endOffset == wholeFragmentText.length()) {
                return null;
            }
            this.onLineBreak();
            return this.processTextFragment(textFragmentIndex, endOffset);
        }

        private int findFragmentPartEndOffset(int fragmentIndex, int fragmentPartStartOffset) {
            String fragmentText = (String)this.myTextFragments.get(fragmentIndex);
            if (fragmentPartStartOffset >= fragmentText.length()) {
                return -1;
            }
            TIntArrayList breakOffsets = (TIntArrayList)this.myBreakOffsets.get(fragmentIndex);
            if (breakOffsets == null || breakOffsets.isEmpty()) {
                return fragmentText.length();
            }
            if (fragmentPartStartOffset == 0) {
                return breakOffsets.get(0);
            }
            for (int i = 0; i < breakOffsets.size(); ++i) {
                if (fragmentPartStartOffset != breakOffsets.get(i)) continue;
                return i < breakOffsets.size() - 1 ? breakOffsets.get(i + 1) : fragmentText.length();
            }
            return -1;
        }
    }

    private class WrapContext
    extends CommonContext {
        @NotNull
        final Dimension textDimension;
        @NotNull
        final Dimension currentLineDimension;
        private final int myWidthLimit;
        private final int mySampleWidth;

        WrapContext(@NotNull List<String> textFragments, @NotNull TIntObjectHashMap<TIntArrayList> breakOffsets, @NotNull TIntIntHashMap lineHeights, Font font, int widthLimit) {
            if (textFragments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFragments", "com/android/tools/idea/ui/WrapsAwareTextHelper$WrapContext", "<init>"));
            }
            if (breakOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakOffsets", "com/android/tools/idea/ui/WrapsAwareTextHelper$WrapContext", "<init>"));
            }
            if (lineHeights == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineHeights", "com/android/tools/idea/ui/WrapsAwareTextHelper$WrapContext", "<init>"));
            }
            if (font == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/idea/ui/WrapsAwareTextHelper$WrapContext", "<init>"));
            }
            super(textFragments, breakOffsets, lineHeights, font);
            this.textDimension = new Dimension();
            this.currentLineDimension = new Dimension();
            this.myWidthLimit = widthLimit;
            WrapsAwareTextHelper.this.myDimensionCalculator.calculate("W", font, this.tmp);
            this.mySampleWidth = this.tmp.width;
        }

        void processTextLineBreak() {
            if (this.currentLineDimension.height <= 0) {
                WrapsAwareTextHelper.this.myDimensionCalculator.calculate("A", this.font, this.tmp);
                this.currentLineDimension.height = this.tmp.height;
            }
            this.onNewLine();
        }

        void processFixedFragmentWidth(int fixedWidth, int textFragmentIndex) {
            if (this.myWidthLimit > 0 && this.currentLineDimension.width + fixedWidth >= this.myWidthLimit) {
                if (this.currentLineDimension.width > 0) {
                    this.onNewLine();
                    this.storeBreakOffset(textFragmentIndex, 0);
                    this.currentLineDimension.width = fixedWidth;
                    this.currentLineDimension.height = this.tmp.height;
                } else {
                    this.currentLineDimension.width += fixedWidth;
                    this.currentLineDimension.height = Math.max(this.currentLineDimension.height, this.tmp.height);
                    this.onNewLine();
                    if (textFragmentIndex < this.myTextFragments.size() - 1) {
                        this.storeBreakOffset(textFragmentIndex + 1, 0);
                    }
                }
            } else {
                this.currentLineDimension.width += fixedWidth;
                this.currentLineDimension.height = Math.max(this.currentLineDimension.height, this.tmp.height);
            }
        }

        void processRegularFragment(int fragmentIndex, int textFragmentStartOffset) {
            String fragmentText = (String)this.myTextFragments.get(fragmentIndex);
            WrapsAwareTextHelper.this.myDimensionCalculator.calculate(fragmentText.substring(textFragmentStartOffset), this.font, this.tmp);
            this.currentLineDimension.height = Math.max(this.currentLineDimension.height, this.tmp.height);
            if (this.myWidthLimit <= 0 || this.currentLineDimension.width + this.tmp.width <= this.myWidthLimit) {
                this.currentLineDimension.width += this.tmp.width;
                return;
            }
            int breakOffset = textFragmentStartOffset + (this.myWidthLimit - this.currentLineDimension.width) / this.mySampleWidth;
            breakOffset = Math.min(fragmentText.length(), breakOffset);
            WrapsAwareTextHelper.this.myDimensionCalculator.calculate(fragmentText.substring(textFragmentStartOffset, breakOffset), this.font, this.tmp);
            if (this.currentLineDimension.width + this.tmp.width <= this.myWidthLimit) {
                this.currentLineDimension.width += this.tmp.width;
                for (int i = breakOffset; i < fragmentText.length(); ++i) {
                    WrapsAwareTextHelper.this.myDimensionCalculator.calculate(fragmentText.substring(i, i + 1), this.font, this.tmp);
                    if (this.currentLineDimension.width + this.tmp.width <= this.myWidthLimit) {
                        this.currentLineDimension.width += this.tmp.width;
                        ++breakOffset;
                        continue;
                    }
                    break;
                }
            } else {
                --breakOffset;
                while (breakOffset > textFragmentStartOffset) {
                    WrapsAwareTextHelper.this.myDimensionCalculator.calculate(fragmentText.substring(textFragmentStartOffset, breakOffset), this.font, this.tmp);
                    if (this.currentLineDimension.width + this.tmp.width <= this.myWidthLimit) {
                        this.currentLineDimension.width += this.tmp.width;
                        break;
                    }
                    --breakOffset;
                }
            }
            this.storeBreakOffset(fragmentIndex, breakOffset);
            this.onNewLine();
            this.processRegularFragment(fragmentIndex, breakOffset);
        }

        private void onNewLine() {
            this.textDimension.width = Math.max(this.currentLineDimension.width, this.textDimension.width);
            this.textDimension.height += this.currentLineDimension.height;
            this.myLineHeights.put(this.line++, this.currentLineDimension.height);
            this.currentLineDimension.height = 0;
            this.currentLineDimension.width = 0;
        }

        private void storeBreakOffset(int fragmentIndex, int breakOffset) {
            TIntArrayList list = (TIntArrayList)this.myBreakOffsets.get(fragmentIndex);
            if (list == null) {
                list = new TIntArrayList();
                this.myBreakOffsets.put(fragmentIndex, (Object)list);
            }
            list.add(breakOffset);
        }
    }

    private static class CommonContext {
        @NotNull
        final Dimension tmp;
        int line;
        @NotNull
        protected final List<String> myTextFragments;
        @NotNull
        protected final TIntObjectHashMap<TIntArrayList> myBreakOffsets;
        @NotNull
        protected final TIntIntHashMap myLineHeights;
        @NotNull
        Font font;
        protected final int myBaseFontSize;
        private boolean myFontWasSmaller;

        CommonContext(@NotNull List<String> textFragments, @NotNull TIntObjectHashMap<TIntArrayList> breakOffsets, @NotNull TIntIntHashMap lineHeights, @NotNull Font font) {
            if (textFragments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textFragments", "com/android/tools/idea/ui/WrapsAwareTextHelper$CommonContext", "<init>"));
            }
            if (breakOffsets == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakOffsets", "com/android/tools/idea/ui/WrapsAwareTextHelper$CommonContext", "<init>"));
            }
            if (lineHeights == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineHeights", "com/android/tools/idea/ui/WrapsAwareTextHelper$CommonContext", "<init>"));
            }
            if (font == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "font", "com/android/tools/idea/ui/WrapsAwareTextHelper$CommonContext", "<init>"));
            }
            this.tmp = new Dimension();
            this.myTextFragments = textFragments;
            this.myBreakOffsets = breakOffsets;
            this.myLineHeights = lineHeights;
            this.font = font;
            this.myBaseFontSize = font.getSize();
        }

        void apply(@NotNull SimpleTextAttributes attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/android/tools/idea/ui/WrapsAwareTextHelper$CommonContext", "apply"));
            }
            boolean isSmaller = attributes.isSmaller();
            if (this.font.getStyle() != attributes.getFontStyle() || isSmaller != this.myFontWasSmaller) {
                this.font = this.font.deriveFont(attributes.getFontStyle(), isSmaller ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : (float)this.myBaseFontSize);
            }
            this.myFontWasSmaller = isSmaller;
        }
    }

    public static interface DimensionCalculator {
        public void calculate(@NotNull String var1, @NotNull Font var2, @NotNull Dimension var3);
    }
}

