/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.signing.KeystoreHelper;
import com.android.prefs.AndroidLocation;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.parser.NamedObject;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class KeystoreUtils {
    @NotNull
    public static File getDebugKeystore(@NotNull AndroidFacet facet) throws Exception {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/templates/KeystoreUtils", "getDebugKeystore"));
        }
        File gradleDebugKeystore = KeystoreUtils.getGradleDebugKeystore(facet);
        if (gradleDebugKeystore != null) {
            File file = gradleDebugKeystore;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/KeystoreUtils", "getDebugKeystore"));
            }
            return file;
        }
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)facet.getConfiguration()).getState();
        if (state != null && !Strings.isNullOrEmpty((String)state.CUSTOM_DEBUG_KEYSTORE_PATH)) {
            File file = new File(state.CUSTOM_DEBUG_KEYSTORE_PATH);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/KeystoreUtils", "getDebugKeystore"));
            }
            return file;
        }
        File file = KeystoreUtils.getOrCreateDefaultDebugKeystore();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/templates/KeystoreUtils", "getDebugKeystore"));
        }
        return file;
    }

    public static File getOrCreateDefaultDebugKeystore() throws Exception {
        try {
            File debugLocation = new File(KeystoreHelper.defaultDebugKeystoreLocation());
            if (!debugLocation.exists()) {
                StdLogger logger = new StdLogger(StdLogger.Level.ERROR);
                KeystoreHelper.createDebugStore(null, (File)debugLocation, (String)"android", (String)"android", (String)"AndroidDebugKey", (ILogger)logger);
            }
            if (!debugLocation.exists()) {
                throw new AndroidLocation.AndroidLocationException("Could not create debug keystore");
            }
            return debugLocation;
        }
        catch (AndroidLocation.AndroidLocationException e) {
            throw new Exception("Failed to get debug keystore path", e);
        }
    }

    @Nullable
    private static File getGradleDebugKeystore(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/templates/KeystoreUtils", "getGradleDebugKeystore"));
        }
        GradleSettingsFile gradleSettingsFile = GradleSettingsFile.get(facet.getModule().getProject());
        if (gradleSettingsFile == null) {
            return null;
        }
        String modulePath = GradleSettingsFile.getModuleGradlePath(facet.getModule());
        if (modulePath == null) {
            return null;
        }
        GradleBuildFile moduleBuildFile = gradleSettingsFile.getModuleBuildFile(modulePath);
        if (moduleBuildFile == null) {
            return null;
        }
        List signingConfigs = (List)moduleBuildFile.getValue(BuildFileKey.SIGNING_CONFIGS);
        if (signingConfigs == null) {
            return null;
        }
        for (NamedObject namedObject : signingConfigs) {
            VirtualFile moduleFile;
            File debugKey;
            if (!"debug".equals(namedObject.getName()) || (debugKey = (File)namedObject.getValue(BuildFileKey.STORE_FILE)) == null || (moduleFile = facet.getModule().getModuleFile()) == null) continue;
            return new File(moduleFile.getParent().getPath(), debugKey.getPath());
        }
        return null;
    }

    public static String sha1(File keystoreFile) throws Exception {
        Certificate signingCert;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(keystoreFile), "android".toCharArray());
            String keyAlias = keyStore.aliases().nextElement();
            signingCert = keyStore.getCertificate(keyAlias);
        }
        catch (Exception e) {
            throw new Exception("Could not extract certificate from file.", e);
        }
        try {
            byte[] certBytes = MessageDigest.getInstance("SHA1").digest(signingCert.getEncoded());
            return BaseEncoding.base16().withSeparator(":", 2).encode(certBytes);
        }
        catch (Exception e) {
            throw new Exception("Could not compute SHA1 hash from certificate", e);
        }
    }
}

