/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.DefaultProject;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

public class GradleFileMerger {
    private static final String DEPENDENCIES = "dependencies";
    private static final String COMPILE = "compile";
    public static final String COMPILE_FORMAT = "compile '%s'\n";

    public static String mergeGradleFiles(@NotNull String source, @NotNull String dest, @Nullable Project project) {
        Project project2;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/android/tools/idea/templates/GradleFileMerger", "mergeGradleFiles"));
        }
        if (dest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/android/tools/idea/templates/GradleFileMerger", "mergeGradleFiles"));
        }
        source = source.replace("\r", "");
        dest = dest.replace("\r", "");
        boolean projectNeedsCleanup = false;
        if (project != null && !(project instanceof DefaultProject)) {
            project2 = project;
        } else {
            project2 = ((ProjectManagerImpl)ProjectManager.getInstance()).newProject("MergingOnly", "", false, true);
            assert (project2 != null);
            ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).runStartupActivities();
            projectNeedsCleanup = true;
        }
        final GroovyFile templateBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project2).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)source);
        final GroovyFile existingBuildFile = (GroovyFile)PsiFileFactory.getInstance((Project)project2).createFileFromText("build.gradle", (FileType)GroovyFileType.GROOVY_FILE_TYPE, (CharSequence)dest);
        String result = (String)new WriteCommandAction<String>(project2, "Merge Gradle Files", new PsiFile[]{existingBuildFile}){

            protected void run(@NotNull Result<String> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/templates/GradleFileMerger$1", "run"));
                }
                GradleFileMerger.mergePsi((PsiElement)templateBuildFile, (PsiElement)existingBuildFile, project2);
                PsiElement formatted = CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)existingBuildFile);
                result.setResult((Object)formatted.getText());
            }
        }.execute().getResultObject();
        if (projectNeedsCleanup) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    Disposer.dispose((Disposable)project2);
                }
            });
        }
        return result;
    }

    private static void mergePsi(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project) {
        if (fromRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromRoot", "com/android/tools/idea/templates/GradleFileMerger", "mergePsi"));
        }
        if (toRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRoot", "com/android/tools/idea/templates/GradleFileMerger", "mergePsi"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/GradleFileMerger", "mergePsi"));
        }
        HashSet<PsiElement> destinationChildren = new HashSet<PsiElement>();
        destinationChildren.addAll(Arrays.asList(toRoot.getChildren()));
        if (toRoot instanceof GrCallExpression && fromRoot instanceof GrCallExpression) {
            PsiElement[] fromArguments = fromRoot.getLastChild().getChildren();
            PsiElement[] toArguments = toRoot.getLastChild().getChildren();
            if (toArguments.length == 1 && fromArguments.length == 1 && toArguments[0] instanceof GrLiteral && fromArguments[0] instanceof GrLiteral) {
                toArguments[0].replace(fromArguments[0]);
                return;
            }
        }
        for (PsiElement child : fromRoot.getChildren()) {
            PsiElement destination = GradleFileMerger.findEquivalentElement(destinationChildren, child);
            if (destination == null) {
                if (destinationChildren.isEmpty()) {
                    toRoot.add(child);
                    continue;
                }
                toRoot.addBefore(child, toRoot.getLastChild());
                continue;
            }
            if (child.getFirstChild() != null && child.getFirstChild().getText().equalsIgnoreCase(DEPENDENCIES) && destination.getFirstChild() != null && destination.getFirstChild().getText().equalsIgnoreCase(DEPENDENCIES)) {
                GradleFileMerger.mergeDependencies(child.getLastChild(), destination.getLastChild(), project);
                continue;
            }
            GradleFileMerger.mergePsi(child, destination, project);
        }
    }

    private static void mergeDependencies(@NotNull PsiElement fromRoot, @NotNull PsiElement toRoot, @NotNull Project project) {
        if (fromRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromRoot", "com/android/tools/idea/templates/GradleFileMerger", "mergeDependencies"));
        }
        if (toRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toRoot", "com/android/tools/idea/templates/GradleFileMerger", "mergeDependencies"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/templates/GradleFileMerger", "mergeDependencies"));
        }
        LinkedListMultimap dependencies = LinkedListMultimap.create();
        ArrayList<String> unparseableDependencies = new ArrayList<String>();
        GradleFileMerger.pullDependenciesIntoMap(toRoot, (Multimap<String, GradleCoordinate>)dependencies, null);
        GradleFileMerger.pullDependenciesIntoMap(fromRoot, (Multimap<String, GradleCoordinate>)dependencies, unparseableDependencies);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        RepositoryUrlManager urlManager = RepositoryUrlManager.get();
        for (String key : dependencies.keySet()) {
            File archiveFile;
            String libraryCoordinate;
            GradleCoordinate available;
            GradleCoordinate highest = (GradleCoordinate)Collections.max(dependencies.get((Object)key), GradleCoordinate.COMPARE_PLUS_LOWER);
            if ((!ApplicationManager.getApplication().isUnitTestMode() || Boolean.getBoolean("force.gradlemerger.repository.check")) && RepositoryUrlManager.supports(highest.getArtifactId()) && (available = GradleCoordinate.parseCoordinateString((String)(libraryCoordinate = urlManager.getLibraryCoordinate(highest.getArtifactId(), null, false)))) != null && (archiveFile = urlManager.getArchiveForCoordinate(available)) != null && archiveFile.exists() && GradleCoordinate.COMPARE_PLUS_LOWER.compare(available, highest) >= 0) {
                highest = available;
            }
            GrStatement dependencyElement = factory.createStatementFromText((CharSequence)String.format(COMPILE_FORMAT, highest.toString()));
            toRoot.addBefore((PsiElement)dependencyElement, toRoot.getLastChild());
        }
        for (String unparseableDependency : unparseableDependencies) {
            GrStatement dependencyElement = factory.createStatementFromText((CharSequence)unparseableDependency);
            toRoot.addBefore((PsiElement)dependencyElement, toRoot.getLastChild());
        }
    }

    private static boolean pullDependenciesIntoMap(@NotNull PsiElement root, Multimap<String, GradleCoordinate> map, @Nullable List<String> unparseableDependencies) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/templates/GradleFileMerger", "pullDependenciesIntoMap"));
        }
        boolean wasMapUpdated = false;
        for (PsiElement existingElem : root.getChildren()) {
            String coordinateText;
            GradleCoordinate coordinate;
            Object value;
            GrExpression[] expressionArguments;
            PsiElement reference;
            if (!(existingElem instanceof GrCall) || !((reference = existingElem.getFirstChild()) instanceof GrReferenceExpression) || !reference.getText().equalsIgnoreCase(COMPILE)) continue;
            boolean parsed = false;
            GrCall call = (GrCall)existingElem;
            GrArgumentList arguments = call.getArgumentList();
            if (arguments != null && call.getClosureArguments().length == 0 && (expressionArguments = arguments.getExpressionArguments()).length == 1 && expressionArguments[0] instanceof GrLiteral && (value = ((GrLiteral)expressionArguments[0]).getValue()) instanceof String && (coordinate = GradleCoordinate.parseCoordinateString((String)(coordinateText = (String)value))) != null) {
                parsed = true;
                if (!map.get((Object)coordinate.getId()).contains(coordinate)) {
                    map.put((Object)coordinate.getId(), (Object)coordinate);
                    existingElem.delete();
                    wasMapUpdated = true;
                }
            }
            if (parsed || unparseableDependencies == null) continue;
            unparseableDependencies.add(existingElem.getText());
        }
        return wasMapUpdated;
    }

    @Nullable
    private static PsiElement findEquivalentElement(@NotNull Collection<PsiElement> collection, @NotNull PsiElement element) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/android/tools/idea/templates/GradleFileMerger", "findEquivalentElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/templates/GradleFileMerger", "findEquivalentElement"));
        }
        ArrayList matchingItems = Lists.newArrayListWithExpectedSize((int)1);
        for (PsiElement item : collection) {
            if (item.getText() != null && item.getText().equals(element.getText())) {
                return item;
            }
            if (item.getFirstChild() == null || element.getFirstChild() == null || !item.getFirstChild().getText().equals(element.getFirstChild().getText())) continue;
            matchingItems.add(item);
        }
        if (matchingItems.size() == 1) {
            return (PsiElement)matchingItems.get(0);
        }
        return null;
    }
}

