/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.annotations.NonNull;
import com.android.tools.idea.stats.BuildRecord;
import com.android.tools.idea.stats.StudioBuildStatsPersistenceComponent;
import gnu.trove.TObjectLongHashMap;

public class StatsTimeCollector {
    private static final boolean isEnabled = StudioBuildStatsPersistenceComponent.getInstance() != null;
    private static final TObjectLongHashMap<String> myTimestampMap = new TObjectLongHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(@NonNull String key) {
        if (!isEnabled) {
            return;
        }
        TObjectLongHashMap<String> tObjectLongHashMap = myTimestampMap;
        synchronized (tObjectLongHashMap) {
            myTimestampMap.put((Object)key, System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(@NonNull String key) {
        if (!isEnabled) {
            return;
        }
        try {
            StudioBuildStatsPersistenceComponent stats;
            long start;
            long now = System.currentTimeMillis();
            TObjectLongHashMap<String> tObjectLongHashMap = myTimestampMap;
            synchronized (tObjectLongHashMap) {
                start = myTimestampMap.remove((Object)key);
            }
            if (start > 0L && start < now && (stats = StudioBuildStatsPersistenceComponent.getInstance()) != null) {
                BuildRecord record = new BuildRecord(key, Long.toString(now - start));
                stats.addBuildRecord(record);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

