/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.annotations.NonNull;
import com.android.sdklib.internal.repository.IListDescription;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.UpdateResult;
import com.android.sdklib.repository.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.SdkLifecycleListener;
import com.android.tools.idea.sdk.SdkState;
import com.android.tools.idea.sdk.wizard.SmwSelectionAction;
import com.android.utils.Pair;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.Nullable;

public class SmwSelectionTableModel
extends AbstractTableModel
implements Disposable {
    @NonNull
    private final List<IListDescription> myInfos = new ArrayList<IListDescription>();
    @NonNull
    private final Set<IListDescription> myChanged = new HashSet<IListDescription>();
    private boolean myIsDisposed;
    private final ColumnInfo[] myColumns;

    public SmwSelectionTableModel(ColumnInfo ... columns) {
        this.myColumns = columns;
    }

    @Override
    public int getRowCount() {
        return this.myInfos.size();
    }

    @Override
    public int getColumnCount() {
        return this.myColumns.length;
    }

    @NonNull
    public ColumnInfo getColumnInfo(int columnIndex) {
        return this.myColumns[columnIndex];
    }

    @Nullable
    public IListDescription getObjectAt(int rowIndex) {
        if (rowIndex < 0 || rowIndex >= this.myInfos.size()) {
            return null;
        }
        return this.myInfos.get(rowIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.myColumns[columnIndex].valueOf((Object)this.myInfos.get(rowIndex));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.myColumns[columnIndex].isCellEditable((Object)this.myInfos.get(rowIndex));
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.myColumns[columnIndex].setValue((Object)this.myInfos.get(rowIndex), aValue);
        for (int i = 0; i < this.myColumns.length; ++i) {
            this.fireTableCellUpdated(rowIndex, i);
        }
    }

    public void linkToSdkState(final @NonNull SdkState sdkState) {
        final Runnable resetInUiThread = new Runnable(){

            @Override
            public void run() {
                if (!SmwSelectionTableModel.this.myIsDisposed) {
                    SmwSelectionTableModel.this.resetTable(sdkState);
                }
            }
        };
        resetInUiThread.run();
        final ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        app.getMessageBus().connect((Disposable)this).subscribe(SdkLifecycleListener.TOPIC, (Object)new SdkLifecycleListener(){

            @Override
            public void localSdkLoaded(@NonNull AndroidSdkData sdkData) {
                if (sdkState.getSdkData() == sdkData) {
                    app.invokeLater(resetInUiThread, ModalityState.any());
                }
            }

            @Override
            public void remoteSdkLoaded(@NonNull AndroidSdkData sdkData) {
            }

            @Override
            public void updatesComputed(@NonNull AndroidSdkData sdkData) {
                if (sdkState.getSdkData() == sdkData) {
                    app.invokeLater(resetInUiThread, ModalityState.any());
                }
            }
        });
    }

    private void resetTable(SdkState sdkState) {
        this.myInfos.clear();
        this.myChanged.clear();
        Collections.addAll(this.myInfos, sdkState.getLocalPkgInfos());
        UpdateResult updates = sdkState.getUpdates();
        if (updates != null) {
            this.myInfos.addAll(updates.getNewPkgs());
        }
        this.fireTableDataChanged();
    }

    private SmwSelectionAction computeAction(IListDescription item) {
        boolean changed = this.myChanged.contains(item);
        if (item instanceof LocalPkgInfo) {
            LocalPkgInfo local = (LocalPkgInfo)item;
            if (changed) {
                return SmwSelectionAction.REMOVE;
            }
            if (local.hasUpdate()) {
                return SmwSelectionAction.UPDATE;
            }
        } else if (item instanceof RemotePkgInfo) {
            if (changed) {
                return SmwSelectionAction.INSTALL;
            }
            return SmwSelectionAction.NEW_REMOTE;
        }
        return SmwSelectionAction.KEEP_LOCAL;
    }

    public List<Pair<SmwSelectionAction, IListDescription>> getActions() {
        ArrayList<Pair<SmwSelectionAction, IListDescription>> actions = new ArrayList<Pair<SmwSelectionAction, IListDescription>>(this.myChanged.size());
        for (IListDescription item : this.myChanged) {
            SmwSelectionAction action = this.computeAction(item);
            switch (action) {
                case INSTALL: 
                case UPDATE: 
                case REMOVE: {
                    actions.add((Pair<SmwSelectionAction, IListDescription>)Pair.of((Object)((Object)action), (Object)item));
                }
            }
        }
        return actions;
    }

    public void dispose() {
        this.myIsDisposed = true;
    }

    public static class InstallColumnInfo
    extends ColumnInfo<IListDescription, Boolean> {
        private SmwSelectionTableModel myModel;

        public InstallColumnInfo(@NonNull String name) {
            super(name);
        }

        public void setModel(@NonNull SmwSelectionTableModel model) {
            this.myModel = model;
        }

        private boolean isChanged(IListDescription item) {
            return this.myModel != null && this.myModel.myChanged.contains(item);
        }

        public Boolean valueOf(IListDescription item) {
            boolean installed = item instanceof LocalPkgInfo;
            if (this.isChanged(item)) {
                installed = !installed;
            }
            return installed;
        }

        public boolean isCellEditable(IListDescription item) {
            return item instanceof LocalPkgInfo || item instanceof RemotePkgInfo;
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public TableCellEditor getEditor(IListDescription item) {
            return new BooleanTableCellEditor();
        }

        @Nullable
        public TableCellRenderer getRenderer(IListDescription o) {
            return new BooleanTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    return super.getTableCellRendererComponent(table, value == null ? Boolean.TRUE : value, isSelected, hasFocus, row, column);
                }
            };
        }

        public int getWidth(JTable table) {
            return new JCheckBox().getPreferredSize().width;
        }

        public void setValue(IListDescription item, Boolean value) {
            if (this.myModel != null) {
                boolean installed = item instanceof LocalPkgInfo;
                if (value != installed) {
                    this.myModel.myChanged.add(item);
                } else {
                    this.myModel.myChanged.remove(item);
                }
            }
            super.setValue((Object)item, (Object)value);
        }
    }

    public static class LabelColumnInfo
    extends ColumnInfo<IListDescription, String> {
        private SmwSelectionTableModel myModel;

        public LabelColumnInfo(@NonNull String name) {
            super(name);
        }

        public void setModel(@NonNull SmwSelectionTableModel model) {
            this.myModel = model;
        }

        public String valueOf(IListDescription item) {
            SmwSelectionAction action;
            String desc = item.getListDescription();
            SmwSelectionAction smwSelectionAction = action = this.myModel == null ? null : this.myModel.computeAction(item);
            if (action != null) {
                if (action == SmwSelectionAction.INSTALL) {
                    desc = "[Install] " + desc;
                } else if (action == SmwSelectionAction.REMOVE) {
                    desc = "[Remove] " + desc;
                } else if (action == SmwSelectionAction.UPDATE) {
                    assert (item instanceof LocalPkgInfo);
                    assert (((LocalPkgInfo)item).getUpdate() != null);
                    desc = "[Update] " + ((LocalPkgInfo)item).getUpdate().getListDescription();
                }
            }
            return desc;
        }

        public boolean isCellEditable(IListDescription item) {
            return false;
        }

        @Nullable
        public TableCellRenderer getRenderer(IListDescription item) {
            return new DefaultTableCellRenderer();
        }
    }
}

