/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.annotations.NonNull;
import com.android.tools.idea.sdk.wizard.SmwSelectionTableModel;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import javax.swing.JCheckBox;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class SmwSelectionTable
extends JBTable {
    public SmwSelectionTable() {
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setStriped(true);
        this.setTableHeader(null);
    }

    public SmwSelectionTable(@NonNull SmwSelectionTableModel model) {
        super((TableModel)model);
        this.setModel(model);
    }

    public void setModel(@NotNull TableModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/sdk/wizard/SmwSelectionTable", "setModel"));
        }
        super.setModel(model);
        if (!(model instanceof SmwSelectionTableModel)) {
            return;
        }
        SmwSelectionTableModel tableModel = (SmwSelectionTableModel)model;
        this.getColumnModel().setColumnMargin(0);
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            ColumnInfo columnInfo = tableModel.getColumnInfo(i);
            column.setCellEditor(columnInfo.getEditor(null));
            if (columnInfo.getColumnClass() != Boolean.class) continue;
            TableUtil.setupCheckboxColumn((TableColumn)column);
        }
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setStriped(true);
        this.setTableHeader(null);
        if (tableModel.getColumnCount() > 1) {
            this.setColumnWidth(1, new JCheckBox().getPreferredSize().width + 4);
        }
    }

    public void setColumnWidth(int columnIndex, int width) {
        TableColumn column = this.getColumnModel().getColumn(columnIndex);
        column.setMinWidth(width);
        column.setMaxWidth(width);
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableModel model = this.getModel();
        if (model instanceof SmwSelectionTableModel) {
            SmwSelectionTableModel smwModel = (SmwSelectionTableModel)this.getModel();
            ColumnInfo columnInfo = smwModel.getColumnInfo(column);
            return columnInfo.getRenderer((Object)smwModel.getObjectAt(row));
        }
        return super.getCellRenderer(row, column);
    }
}

