/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.sdklib.SdkManager;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.PkgType;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.tools.idea.rendering.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkMerger {
    private static final Logger LOG = Logger.getInstance(SdkMerger.class);

    public static void mergeSdks(@NotNull File srcDir, @NotNull File destDir, @Nullable ProgressIndicator indicator) {
        if (srcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcDir", "com/android/tools/idea/sdk/SdkMerger", "mergeSdks"));
        }
        if (destDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destDir", "com/android/tools/idea/sdk/SdkMerger", "mergeSdks"));
        }
        Collection<MergeablePackage> packages = SdkMerger.compareSdks(srcDir, destDir);
        int numPackages = packages.size();
        int i = 0;
        for (MergeablePackage pkg : packages) {
            if (indicator != null) {
                if (indicator.isCanceled()) {
                    return;
                }
                indicator.setFraction((double)i++ / (double)numPackages);
                indicator.setText(String.format("Copying SDK package %1s", pkg.srcPkg.getDesc().getInstallId()));
            }
            if (pkg.destPkg != null) {
                File destPkgDir = pkg.destPkg.getLocalDir();
                try {
                    FileUtil.delete((File)destPkgDir);
                }
                catch (RuntimeException e) {
                    LOG.warn("Failed to delete destination directory " + destPkgDir.getPath(), (Throwable)e);
                }
            }
            try {
                FileUtil.copyDir((File)pkg.srcPkg.getLocalDir(), (File)pkg.srcPkg.getDesc().getCanonicalInstallFolder(pkg.destLocation));
            }
            catch (IOException e) {
                LOG.error("Unable to copy package " + pkg.srcPkg.getDesc().getInstallId(), (Throwable)e);
            }
        }
        if (indicator != null) {
            indicator.setFraction(1.0);
        }
    }

    public static boolean hasMergeableContent(@NotNull File srcDir, @NotNull File destDir) {
        if (srcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcDir", "com/android/tools/idea/sdk/SdkMerger", "hasMergeableContent"));
        }
        if (destDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destDir", "com/android/tools/idea/sdk/SdkMerger", "hasMergeableContent"));
        }
        return !SdkMerger.compareSdks(srcDir, destDir).isEmpty();
    }

    @NotNull
    private static Collection<MergeablePackage> compareSdks(@NotNull File srcDir, @NotNull File destDir) {
        if (srcDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcDir", "com/android/tools/idea/sdk/SdkMerger", "compareSdks"));
        }
        if (destDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destDir", "com/android/tools/idea/sdk/SdkMerger", "compareSdks"));
        }
        ArrayList results = Lists.newArrayList();
        LogWrapper logger = new LogWrapper(LOG);
        SdkManager destManager = SdkManager.createManager((String)destDir.getPath(), (ILogger)logger);
        SdkManager srcManager = SdkManager.createManager((String)srcDir.getPath(), (ILogger)logger);
        if (srcManager == null || destManager == null) {
            ArrayList arrayList = results;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkMerger", "compareSdks"));
            }
            return arrayList;
        }
        LocalSdk srcSdk = srcManager.getLocalSdk();
        LocalSdk destSdk = destManager.getLocalSdk();
        LocalPkgInfo[] srcPkgs = srcSdk.getPkgsInfos(EnumSet.allOf(PkgType.class));
        File destLocation = destSdk.getLocation();
        if (destLocation == null) {
            ArrayList arrayList = results;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkMerger", "compareSdks"));
            }
            return arrayList;
        }
        HashMap destPackages = Maps.newHashMap();
        for (LocalPkgInfo pkg : destSdk.getPkgsInfos(EnumSet.allOf(PkgType.class))) {
            destPackages.put(pkg.getDesc().getInstallId(), pkg);
        }
        for (LocalPkgInfo srcPkg : srcPkgs) {
            IPkgDesc srcPkgDesc = srcPkg.getDesc();
            LocalPkgInfo destPkg = (LocalPkgInfo)destPackages.get(srcPkg.getDesc().getInstallId());
            if (destPkg != null) {
                IPkgDesc destPkgDesc = destPkg.getDesc();
                FullRevision srcFullRevision = srcPkgDesc.getFullRevision();
                FullRevision destFullRevision = destPkgDesc.getFullRevision();
                MajorRevision srcMajorRevision = srcPkgDesc.getMajorRevision();
                MajorRevision destMajorRevision = destPkgDesc.getMajorRevision();
                if ((srcFullRevision == null || destFullRevision == null || srcFullRevision.compareTo(destFullRevision) <= 0) && (srcMajorRevision == null || destMajorRevision == null || srcMajorRevision.compareTo((FullRevision)destMajorRevision) <= 0)) continue;
                results.add(new MergeablePackage(srcPkg, destPkg, destLocation));
                continue;
            }
            results.add(new MergeablePackage(srcPkg, null, destLocation));
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/sdk/SdkMerger", "compareSdks"));
        }
        return arrayList;
    }

    private static class MergeablePackage {
        @NotNull
        private final LocalPkgInfo srcPkg;
        @Nullable
        private final LocalPkgInfo destPkg;
        @NotNull
        private final File destLocation;

        private MergeablePackage(@NotNull LocalPkgInfo srcPkg, @Nullable LocalPkgInfo destPkg, @NotNull File destLocation) {
            if (srcPkg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "srcPkg", "com/android/tools/idea/sdk/SdkMerger$MergeablePackage", "<init>"));
            }
            if (destLocation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "destLocation", "com/android/tools/idea/sdk/SdkMerger$MergeablePackage", "<init>"));
            }
            this.srcPkg = srcPkg;
            this.destPkg = destPkg;
            this.destLocation = destLocation;
        }
    }
}

